/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.enterpriseresource.entity.EnterpriseDyTopManResultEntity;
import com.els.modules.enterpriseresource.entity.TopManEnterpriseInfoHeadEntity;
import com.els.modules.enterpriseresource.export.EnterpriseTopManExportServiceImpl;
import com.els.modules.enterpriseresource.service.EnterpriseDyTopManService;
import com.els.modules.enterpriseresource.service.TopManEnterpriseInfoHeadService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/enterprise/topMan"})
@Api(tags={"\u6296\u97f3\u4f01\u4e1a\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class EnterpriseDyTopManController
extends BaseController<TopManEnterpriseInfoHeadEntity, TopManEnterpriseInfoHeadService> {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseDyTopManController.class);
    @Resource
    private EnterpriseDyTopManService elsTopManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listDyAll"})
    @PermissionDataView(businessType="companyResource")
    public Result<?> listDyAll(@RequestBody SimplePostRequestParam<RequestOptionVO> topManDto) {
        try {
            IPage<EnterpriseDyTopManResultEntity> pageList = this.elsTopManInformationService.queryTopManListAll(topManDto);
            return Result.ok(pageList);
        }
        catch (IllegalAccessException e) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u8f6c\u6362\u5f02\u5e38"));
        }
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listDyPublic"})
    @PermissionDataView(businessType="companyResource")
    public Result<?> listDyPublic(@RequestBody SimplePostRequestParam<RequestOptionVO> topManDto) {
        IPage<EnterpriseDyTopManResultEntity> pageList = this.elsTopManInformationService.listDyPublic(topManDto);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listDyMyTopMan"})
    @PermissionDataView(businessType="companyResource")
    public Result<?> listDyMyTopMan(@RequestBody SimplePostRequestParam<RequestOptionVO> topManDto) {
        try {
            IPage<EnterpriseDyTopManResultEntity> pageList = this.elsTopManInformationService.queryTopManListMyTopMan(topManDto);
            return Result.ok(pageList);
        }
        catch (IllegalAccessException e) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u8f6c\u6362\u5f02\u5e38"));
        }
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam(value="param") String param) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put("ids", param.split(","));
        return super.exportXls(request, map, EnterpriseTopManExportServiceImpl.class);
    }

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.elsTopManInformationService.getOptions(type, clearCache));
    }
}

