/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.enterpriseresource.entity.DyTopManInformationHead;
import com.els.modules.enterpriseresource.entity.EnterpriseDyTopManResultEntity;
import com.els.modules.enterpriseresource.enumerate.DecideStatusEnum;
import com.els.modules.enterpriseresource.mapper.EnterpriseDyTopManMapper;
import com.els.modules.enterpriseresource.service.EnterpriseDyTopManService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.enumerate.DyOptionType;
import com.els.modules.industryInfo.api.optiondic.DouYinTopManOptionSource;
import com.els.modules.industryInfo.api.weboption.MultipleOptionTag;
import com.els.modules.industryInfo.api.weboption.OptionComponentType;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseDyTopManServiceImpl
extends BaseServiceImpl<EnterpriseDyTopManMapper, DyTopManInformationHead>
implements EnterpriseDyTopManService {
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public IPage<EnterpriseDyTopManResultEntity> queryTopManListAll(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<DyTopManInformationHead> ksQueryWrapper = this.getQueryWrapperNew(topManDto);
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        IPage<EnterpriseDyTopManResultEntity> result = ((EnterpriseDyTopManMapper)this.baseMapper).listTopManAll((Page<EnterpriseDyTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser(), this.permissionDataRpcService.getCompany("companyResource"), company);
        this.transitionTopMan(result.getRecords());
        return result;
    }

    @Override
    public IPage<EnterpriseDyTopManResultEntity> listDyPublic(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<DyTopManInformationHead> ksQueryWrapper = this.getQueryWrapperNew(topManDto);
        ksQueryWrapper.eq((Object)"decide_status", (Object)"1");
        ksQueryWrapper.isNull((Object)"sub_account");
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        IPage<EnterpriseDyTopManResultEntity> result = ((EnterpriseDyTopManMapper)this.baseMapper).listTopManAll((Page<EnterpriseDyTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser(), this.permissionDataRpcService.getCompany("companyResource"), company);
        this.transitionTopMan(result.getRecords());
        return result;
    }

    @Override
    public IPage<EnterpriseDyTopManResultEntity> queryTopManListMyTopMan(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<DyTopManInformationHead> ksQueryWrapper = this.getQueryWrapperNew(topManDto);
        LoginUser loginUser = SysUtil.getLoginUser();
        ksQueryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        IPage<EnterpriseDyTopManResultEntity> result = ((EnterpriseDyTopManMapper)this.baseMapper).listTopManAll((Page<EnterpriseDyTopManResultEntity>)page, ksQueryWrapper, loginUser, this.permissionDataRpcService.getCompany("companyResource"), company);
        this.transitionTopMan(result.getRecords());
        return result;
    }

    private void transitionTopMan(List<EnterpriseDyTopManResultEntity> list) {
        list.forEach(h -> {
            h.setTopmanLevel(StringUtils.isNotBlank((CharSequence)h.getTopmanLevel()) ? (String)DouYinTopManOptionSource.level.get(Integer.valueOf(h.getTopmanLevel())) : "");
            h.setTopmanGender(StringUtils.isNotBlank((CharSequence)h.getTopmanGender()) ? (String)DouYinTopManOptionSource.gender.get(Integer.valueOf(h.getTopmanGender())) : "");
        });
    }

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        ArrayList<TopManOptionsEntity> result = new ArrayList<TopManOptionsEntity>(10);
        TopManOptionsEntity vo = DyOptionType.category.getTopManOptionsEntity();
        vo.setChildren(DouYinTopManOptionSource.cataTypeToChildren((Map)DouYinTopManOptionSource.category, (OptionComponentType)OptionComponentType.RMultipleChoice));
        result.add(vo);
        TopManOptionsEntity vo1 = DyOptionType.contentType.getTopManOptionsEntity();
        vo1.setChildren(DouYinTopManOptionSource.toChildren((Map)DouYinTopManOptionSource.contentType, (OptionComponentType)OptionComponentType.RButton));
        result.add(vo1);
        result.add(this.handleTopManInfoVo());
        result.add(this.handleOtherVo(type));
        return result;
    }

    private TopManOptionsEntity handleOtherVo(String type) {
        TopManOptionsEntity.Tag tag;
        TopManOptionsEntity vo = DyOptionType.other.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        if (!"12".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u786e\u8ba4\u72b6\u6001");
            List<Object> tags = this.getDefaultTagList();
            tag.setSubTags(tags);
            tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId(DecideStatusEnum.CONFIRMED.getCode());
            tag.setStarTagValue(DecideStatusEnum.CONFIRMED.getCode());
            tag.setStarTagName(DecideStatusEnum.CONFIRMED.getDesc());
            tags.add(tag);
            tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId(DecideStatusEnum.TO_BE_CONFIRMED.getCode());
            tag.setStarTagValue(DecideStatusEnum.TO_BE_CONFIRMED.getCode());
            tag.setStarTagName(DecideStatusEnum.TO_BE_CONFIRMED.getDesc());
            tags.add(tag);
        }
        if ("11".equals(type)) {
            List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u8d1f\u8d23\u4eba");
            ArrayList<TopManOptionsEntity.Tag> tags = new ArrayList<TopManOptionsEntity.Tag>(allByAccount.size() + 1);
            tag.setSubTags(tags);
            tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId("\u65e0");
            tag.setStarTagValue("\u65e0");
            tag.setStarTagName("\u65e0");
            tags.add(tag);
            allByAccount.forEach(a -> {
                TopManOptionsEntity.Tag tag1 = new TopManOptionsEntity.Tag();
                tag1.setStarTagId(a.getSubAccount());
                tag1.setStarTagValue(a.getSubAccount());
                tag1.setStarTagName(a.getRealname());
                tags.add(tag1);
            });
        }
        return vo;
    }

    private List<Object> getDefaultTagList() {
        ArrayList<Object> tags = new ArrayList<Object>(3);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId("0");
        tag.setStarTagValue("0");
        tag.setStarTagName("\u5168\u90e8");
        tags.add(tag);
        return tags;
    }

    private TopManOptionsEntity handleSaleDataVo() {
        TopManOptionsEntity vo = DyOptionType.saleData.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("30\u65e5\u9500\u552e\u989d");
        tag.setTips("\u8fd130\u5929\u8fbe\u4eba\u901a\u8fc7\u6240\u6709\u6765\u6e90\u5e26\u8d27\u7684\u603b\u9500\u552e\u989d");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d");
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u573a\u6b21\u7684\u5e73\u5747GMV\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u7684\u89c2\u770b\u4eba\u6570\u7684\u4e2d\u4f4d\u6570\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
        tag.setStarTagName("\u76f4\u64ad\u89c2\u770b\u4eba\u6570");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.viwerCount));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u76f4\u64adGPM");
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u8d2d\u7269\u8f66\u5343\u6b21\u66dd\u5149\u4ea7\u751f\u7684GMV\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gpmAndPriceAvg));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u5355\u89c6\u9891\u9500\u552e\u989d");
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u5e73\u5747GMV");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u89c6\u9891\u64ad\u653e\u91cf");
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u7684\u64ad\u653e\u91cf\u7684\u4e2d\u4f4d\u6570");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.playCount));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u89c6\u9891GPM");
        tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u8d2d\u7269\u8f66\u5343\u6b21\u66dd\u5149\u4ea7\u751f\u7684GMV");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gpmAndPriceAvg));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setTips("\u7ed3\u7b97\u7387\u9ad8\u6307\u8be5\u8fbe\u4eba\u8fd130\u65e5\u7ed3\u7b97\u7387\u5904\u4e8e\u8fbe\u4eba\u9886\u5148\u6c34\u5e73");
        tag.setStarTagName("\u7ed3\u7b97\u7387\u9ad8");
        return vo;
    }

    private TopManOptionsEntity handleTopManInfoVo() {
        TopManOptionsEntity vo = DyOptionType.topManInfo.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u8fbe\u4eba\u7b49\u7ea7");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.level));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u8fbe\u4eba\u6027\u522b");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gender));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCascader);
        tag.setStarTagName("\u8fbe\u4eba\u5730\u57df");
        Map topManArea = DouYinTopManOptionSource.topManArea;
        ArrayList<TopManOptionsEntity.Tag> subTags = new ArrayList<TopManOptionsEntity.Tag>(topManArea.size());
        tag.setSubTags(subTags);
        for (Map.Entry gp : topManArea.entrySet()) {
            TopManOptionsEntity.Tag province = new TopManOptionsEntity.Tag();
            subTags.add(province);
            province.setStarTagName((String)gp.getKey());
            province.setStarTagValue((String)gp.getKey());
            List value = (List)gp.getValue();
            ArrayList citys = new ArrayList(value.size());
            province.setSubTags(citys);
            province.setLevel(Integer.valueOf(1));
            value.forEach(a -> {
                TopManOptionsEntity.Tag city = new TopManOptionsEntity.Tag();
                citys.add(city);
                city.setLevel(Integer.valueOf(2));
                city.setStarTagName(a);
                city.setStarTagValue(a);
            });
        }
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u7eaf\u4f63\u8fbe\u4eba");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u660e\u661f");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u9ed1\u9a6c");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u6709\u8054\u7cfb\u65b9\u5f0f");
        return vo;
    }

    private QueryWrapper<DyTopManInformationHead> getQueryWrapperNew(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Map screenItem;
        String[] columns;
        QueryWrapper queryWrapper = new QueryWrapper();
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            queryWrapper.and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lambda().eq(DyTopManInformationHead::getTopmanId, (Object)keyWord)).or(b -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)b.like(DyTopManInformationHead::getTopmanName, (Object)keyWord);
                });
            });
        }
        String column = topManDto.getColumn();
        final String order = topManDto.getOrder();
        if (column != null && order != null && (columns = column.split(",")).length > 0) {
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new DyTopManInformationHead()));
        }
        if ((screenItem = ((RequestOptionVO)topManDto.getFilterInfo()).getScreenItem()) != null && screenItem.size() > 0) {
            for (String key : screenItem.keySet()) {
                DyOptionType dyOptionType = DyOptionType.getDyOptionType((String)key);
                Assert.isNotNull((Object)dyOptionType, (String)I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b"));
                List screenItems = (List)screenItem.get(key);
                SFunction & Serializable categoryOrContentType = null;
                if (screenItems == null || screenItems.size() == 0) continue;
                switch (dyOptionType) {
                    case category: {
                        categoryOrContentType = DyTopManInformationHead::getCategory;
                    }
                    case contentType: {
                        if (categoryOrContentType == null) {
                            categoryOrContentType = DyTopManInformationHead::getContentType;
                        }
                        AtomicReference next = new AtomicReference();
                        queryWrapper.lambda().and(next::set);
                        for (int i = 0; i < screenItems.size(); ++i) {
                            RequestOptionVO.ScreenItem item = (RequestOptionVO.ScreenItem)screenItems.get(i);
                            ((LambdaQueryWrapper)next.get()).like((Object)categoryOrContentType, (Object)item.getTitle());
                            if (i == screenItems.size() - 1) continue;
                            ((LambdaQueryWrapper)next.get()).or(next::set);
                        }
                    }
                    case topManInfo: {
                        this.handleTopManInfoWrapper(screenItems, (QueryWrapper<DyTopManInformationHead>)queryWrapper);
                        break;
                    }
                    case saleData: {
                        this.handleSaleDataWrapper(screenItems, (QueryWrapper<DyTopManInformationHead>)queryWrapper);
                        break;
                    }
                    case other: {
                        this.handleOtherWrapper(screenItems, (QueryWrapper<DyTopManInformationHead>)queryWrapper);
                    }
                }
            }
        }
        return queryWrapper;
    }

    private void handleOtherWrapper(List<RequestOptionVO.ScreenItem> screenItems, QueryWrapper<DyTopManInformationHead> queryWrapper) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u786e\u8ba4\u72b6\u6001": {
                    queryWrapper.eq((Object)"decide_status", (Object)value);
                    break;
                }
                case "\u8d1f\u8d23\u4eba": {
                    queryWrapper.eq((Object)"sub_account", (Object)value);
                }
            }
        }
    }

    private void handleSaleDataWrapper(List<RequestOptionVO.ScreenItem> screenItems, QueryWrapper<DyTopManInformationHead> queryWrapper) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "30\u65e5\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getSaleD30High);
                    break;
                }
                case "\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveSaleHigh);
                    break;
                }
                case "\u76f4\u64ad\u89c2\u770b\u4eba\u6570": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveWatchingNumber);
                    break;
                }
                case "\u76f4\u64adGPM": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveGpmHigh);
                    break;
                }
                case "\u5355\u89c6\u9891\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoSaleHigh);
                    break;
                }
                case "\u89c6\u9891\u64ad\u653e\u91cf": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoPlayMedian);
                    break;
                }
                case "\u89c6\u9891GPM": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoGpmHigh);
                    break;
                }
                case "\u7ed3\u7b97\u7387\u9ad8": 
                case "\u76f4\u64ad\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": 
                case "\u89c6\u9891\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getHighReply, (Object)"\u5904\u7406\u7387\u9ad8");
                }
            }
        }
    }

    private void handleTopManInfoWrapper(List<RequestOptionVO.ScreenItem> screenItems, QueryWrapper<DyTopManInformationHead> queryWrapper) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u8fbe\u4eba\u7b49\u7ea7": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanLevel, (Object)value);
                    break;
                }
                case "\u7c89\u4e1d\u603b\u6570": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getFansNum);
                    break;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanSex, (Object)value);
                    break;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List region = (List)JSONObject.parseObject((String)value, List.class);
                    String regionParam = StringUtils.join((Iterable)region, (String)"\u00b7");
                    queryWrapper.lambda().eq(DyTopManInformationHead::getRegion, (Object)regionParam);
                    break;
                }
                case "\u662f\u5426\u7b7e\u7ea6\u673a\u6784": {
                    break;
                }
                case "\u7eaf\u4f63\u8fbe\u4eba": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getPriceType, (Object)"1");
                    queryWrapper.lambda().eq(DyTopManInformationHead::getPriceType2, (Object)"1");
                    break;
                }
                case "\u660e\u661f": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getStar, (Object)"true");
                    break;
                }
                case "\u9ed1\u9a6c": {
                    queryWrapper.lambda().isNotNull(DyTopManInformationHead::getDarkHorse);
                    break;
                }
                case "\u6709\u8054\u7cfb\u65b9\u5f0f": {
                    queryWrapper.lambda().isNotNull(DyTopManInformationHead::getContactIcon);
                }
            }
        }
    }

    private void handleMultipleQueryWrapperBetween(QueryWrapper<DyTopManInformationHead> queryWrapper, String value, SFunction<DyTopManInformationHead, ?> field) {
        AtomicReference next = new AtomicReference();
        queryWrapper.and(next::set);
        List tags = JSON.parseArray((String)value, MultipleOptionTag.class);
        for (int i = 0; i < tags.size(); ++i) {
            MultipleOptionTag item = (MultipleOptionTag)tags.get(i);
            this.handleScope((QueryWrapper<DyTopManInformationHead>)((QueryWrapper)next.get()), item.getName(), field);
            if (i == tags.size() - 1) continue;
            ((QueryWrapper)next.get()).or(next::set);
        }
    }

    private void handleScope(QueryWrapper<DyTopManInformationHead> queryWrapper, String value, SFunction<DyTopManInformationHead, ?> function) {
        if (value.contains("\u4ee5\u4e0b")) {
            queryWrapper.lambda().lt(function, (Object)this.formatNumber(value));
        }
        if (value.contains("\u4ee5\u4e0a")) {
            queryWrapper.lambda().gt(function, (Object)this.formatNumber(value));
        }
        if (value.contains("-")) {
            String[] split = value.split("-");
            queryWrapper.lambda().between(function, (Object)this.formatNumber(split[0]), (Object)this.formatNumber(split[1]));
        }
    }

    private Integer formatNumber(String value) {
        return Integer.valueOf(value.replace("\u4ee5\u4e0b", "").replace("\u4ee5\u4e0a", "").replace("w", "0000"));
    }
}

