/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.intentioninvest.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.intentioninvest.entity.IntentionInvestHead;
import com.els.modules.intentioninvest.entity.IntentionServiceComm;
import com.els.modules.intentioninvest.entity.IntentionServiceFee;
import com.els.modules.intentioninvest.enumerate.BusStatusEmun;
import com.els.modules.intentioninvest.service.IntentionInvestHeadService;
import com.els.modules.intentioninvest.service.IntentionServiceCommService;
import com.els.modules.intentioninvest.service.IntentionServiceFeeService;
import com.els.modules.intentioninvest.vo.IntentionInvestHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/intentionInvestHead"})
@Api(tags={"\u6295\u653e\u610f\u5411\u7ba1\u7406"})
public class IntentionInvestHeadController
extends BaseController<IntentionInvestHead, IntentionInvestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(IntentionInvestHeadController.class);
    @Autowired
    private IntentionInvestHeadService intentionInvestHeadService;
    @Autowired
    private IntentionServiceFeeService intentionServiceFeeService;
    @Autowired
    private IntentionServiceCommService intentionServiceCommService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(IntentionInvestHead intentionInvestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)intentionInvestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.intentionInvestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody IntentionInvestHeadVO intentionInvestHeadPage) {
        IntentionInvestHead intentionInvestHead = new IntentionInvestHead();
        BeanUtils.copyProperties((Object)((Object)intentionInvestHeadPage), (Object)((Object)intentionInvestHead));
        if (StrUtil.isBlank((CharSequence)intentionInvestHeadPage.getId())) {
            this.intentionInvestHeadService.saveMain(intentionInvestHead, intentionInvestHeadPage.getIntentionServiceFeeList(), intentionInvestHeadPage.getIntentionServiceCommList());
        } else {
            this.intentionInvestHeadService.updateMain(intentionInvestHead, intentionInvestHeadPage.getIntentionServiceFeeList(), intentionInvestHeadPage.getIntentionServiceCommList(), BusStatusEmun.NEWLY_BUILD);
        }
        return Result.ok((Object)((Object)intentionInvestHead));
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody IntentionInvestHeadVO intentionInvestHeadPage) {
        IntentionInvestHead intentionInvestHead = new IntentionInvestHead();
        BeanUtils.copyProperties((Object)((Object)intentionInvestHeadPage), (Object)((Object)intentionInvestHead));
        this.intentionInvestHeadService.updateMain(intentionInvestHead, intentionInvestHeadPage.getIntentionServiceFeeList(), intentionInvestHeadPage.getIntentionServiceCommList(), BusStatusEmun.NEWLY_BUILD);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody IntentionInvestHeadVO intentionInvestHeadPage) {
        IntentionInvestHead intentionInvestHead = new IntentionInvestHead();
        BeanUtils.copyProperties((Object)((Object)intentionInvestHeadPage), (Object)((Object)intentionInvestHead));
        intentionInvestHead.setBusStatus(BusStatusEmun.BE_QUOTED.getValue());
        this.intentionInvestHeadService.updateMain(intentionInvestHead, intentionInvestHeadPage.getIntentionServiceFeeList(), intentionInvestHeadPage.getIntentionServiceCommList(), BusStatusEmun.BE_QUOTED);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u5df2\u62a5\u4ef7")
    @ApiOperation(value="\u5df2\u62a5\u4ef7", notes="\u5df2\u62a5\u4ef7")
    @PostMapping(value={"/quoted"})
    public Result<?> quoted(@RequestBody IntentionInvestHeadVO intentionInvestHeadPage) {
        IntentionInvestHead intentionInvestHead = new IntentionInvestHead();
        BeanUtils.copyProperties((Object)((Object)intentionInvestHeadPage), (Object)((Object)intentionInvestHead));
        this.intentionInvestHeadService.updateMain(intentionInvestHead, intentionInvestHeadPage.getIntentionServiceFeeList(), intentionInvestHeadPage.getIntentionServiceCommList(), BusStatusEmun.QUOTED);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.intentionInvestHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.intentionInvestHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        IntentionInvestHead intentionInvestHead = (IntentionInvestHead)((Object)this.intentionInvestHeadService.getById((Serializable)((Object)id)));
        IntentionInvestHeadVO intentionInvestHeadVO = new IntentionInvestHeadVO();
        BeanUtils.copyProperties((Object)((Object)intentionInvestHead), (Object)((Object)intentionInvestHeadVO));
        List<IntentionServiceFee> intentionServiceFeeList = this.intentionServiceFeeService.selectByMainId(id);
        intentionInvestHeadVO.setIntentionServiceFeeList(intentionServiceFeeList);
        List<IntentionServiceComm> intentionServiceCommList = this.intentionServiceCommService.selectByMainId(id);
        intentionInvestHeadVO.setIntentionServiceCommList(intentionServiceCommList);
        return Result.ok((Object)((Object)intentionInvestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u6295\u653e\u610f\u5411\u7ba1\u7406id\u67e5\u8be2\u63a8\u5e7f\u670d\u52a1\u8d39", notes="\u901a\u8fc7\u6295\u653e\u610f\u5411\u7ba1\u7406id\u67e5\u8be2\u63a8\u5e7f\u670d\u52a1\u8d39")
    @GetMapping(value={"/queryIntentionServiceFeeByMainId"})
    public Result<?> queryIntentionServiceFeeListByMainId(@RequestParam(name="id") String id) {
        List<IntentionServiceFee> intentionServiceFeeList = this.intentionServiceFeeService.selectByMainId(id);
        return Result.ok(intentionServiceFeeList);
    }

    @ApiOperation(value="\u901a\u8fc7\u6295\u653e\u610f\u5411\u7ba1\u7406id\u67e5\u8be2\u63a8\u5e7f\u4f63\u91d1", notes="\u901a\u8fc7\u6295\u653e\u610f\u5411\u7ba1\u7406id\u67e5\u8be2\u63a8\u5e7f\u4f63\u91d1")
    @GetMapping(value={"/queryIntentionServiceCommByMainId"})
    public Result<?> queryIntentionServiceCommListByMainId(@RequestParam(name="id") String id) {
        List<IntentionServiceComm> intentionServiceCommList = this.intentionServiceCommService.selectByMainId(id);
        return Result.ok(intentionServiceCommList);
    }

    @AutoLog(busModule="\u6295\u653e\u610f\u5411\u7ba1\u7406", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    public Result<?> cancel(@RequestBody IntentionInvestHeadVO intentionInvestHeadPage) {
        IntentionInvestHead intentionInvestHead = (IntentionInvestHead)((Object)((IntentionInvestHeadService)this.service).getById((Serializable)((Object)intentionInvestHeadPage.getId())));
        if (Arrays.asList(BusStatusEmun.BE_QUOTED.getValue(), BusStatusEmun.QUOTED.getValue(), BusStatusEmun.LAUNCH.getValue()).contains(intentionInvestHead.getBusStatus()) && !AuditStatusEnum.AUDIT_DOING.getValue().equals(intentionInvestHead.getResultAuditStatus())) {
            intentionInvestHead.setBusStatus(BusStatusEmun.TO_VOID.getValue());
            ((IntentionInvestHeadService)this.service).updateById((Object)intentionInvestHead);
        } else {
            Assert.isTrue((boolean)false, (String)"\u8be5\u5355\u636e\u72b6\u6001\u4e0d\u652f\u6301\u4f5c\u5e9f", (Object[])new Object[0]);
        }
        return this.commonSuccessResult(7);
    }

    @GetMapping(value={"/counts"})
    public Result<?> counts(IntentionInvestHead intentionInvestHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)intentionInvestHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        queryWrapper.select(new String[]{"bus_status", "count(0) as quantity"});
        queryWrapper.groupBy((Object)"bus_status");
        List list = ((IntentionInvestHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(IntentionInvestHead::getBusStatus, IntentionInvestHead::getQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "busStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("intentionInvestStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "busStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

