/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.monitor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.account.api.service.ApiCallCountRpcService;
import com.els.modules.common.spider.properties.MonitorMethodProperties;
import com.els.modules.common.spider.properties.SpiderBaseProperties;
import com.els.modules.common.utils.HttpRequestUtils;
import com.els.modules.monitor.entity.WorksMonitorCommentEntity;
import com.els.modules.monitor.entity.WorksMonitorDetail;
import com.els.modules.monitor.entity.WorksMonitorEntity;
import com.els.modules.monitor.entity.WorksMonitorItemEntity;
import com.els.modules.monitor.entity.WorksTrendEntity;
import com.els.modules.monitor.mapper.WorksMonitorMapper;
import com.els.modules.monitor.service.WorksMonitorService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class WorksMonitorServiceImpl
extends BaseServiceImpl<WorksMonitorMapper, WorksMonitorEntity>
implements WorksMonitorService {
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private MonitorMethodProperties monitorMethodProperties;
    @Autowired
    private ApiCallCountRpcService apiCallcountRpcService;
    private static final String SUCCESS_CODE = "1000";
    private static final String WORKS_MONITOR_COUNT_LIMIT = "works_monitor_count_limit";
    @Value(value="${els.env}")
    private String env;

    public WorksMonitorDetail<WorksMonitorEntity> searchWorksMonitor(String workUrl) throws Exception {
        String url = this.spiderBaseProperties.getMonitor();
        String detailMethod = this.monitorMethodProperties.getDetails();
        WorksMonitorDetail<WorksMonitorEntity> detail = new WorksMonitorDetail<WorksMonitorEntity>();
        String param = WorksMonitorServiceImpl.apiGetList(workUrl);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + detailMethod, param);
        String code = jsonObject.getString("code");
        detail.setCode(code);
        detail.setMessage(jsonObject.getString("message"));
        if (SUCCESS_CODE.equals(code)) {
            JSONObject dataJson = jsonObject.getJSONObject("data");
            WorksMonitorEntity data = (WorksMonitorEntity)((Object)dataJson.toJavaObject(WorksMonitorEntity.class));
            data.setLogo(this.spiderBaseProperties.getImageUrl() + dataJson.getString("cover"));
            data.setBusinessId(dataJson.getString("business_id"));
            data.setCollects(dataJson.getInteger("collect_count"));
            data.setComments(dataJson.getInteger("comment_count"));
            data.setNikeName(dataJson.getString("nickname"));
            data.setTopmanUrl(this.spiderBaseProperties.getImageUrl() + dataJson.getString("avatar"));
            data.setTitle(dataJson.getString("desc"));
            data.setWorkUrl(dataJson.getString("share_url"));
            data.setLikes(dataJson.getInteger("digg_count"));
            data.setDownloads(dataJson.getInteger("download_count"));
            data.setShares(dataJson.getInteger("share_count"));
            data.setAccount(dataJson.getString("unique_id"));
            data.setAwemeId(dataJson.getString("aweme_id"));
            data.setReleaseTime(this.apiCallcountRpcService.getCount(WORKS_MONITOR_COUNT_LIMIT));
            detail.setData(data);
        }
        return detail;
    }

    private static String apiGetList(String workUrl) throws Exception {
        HashMap<String, String> apiParam = new HashMap<String, String>();
        apiParam.put("aweme_url", workUrl);
        String json = JSON.toJSONString(apiParam);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    @Override
    public int startMonitor(WorksMonitorEntity entity) {
        int allcount = this.apiCallcountRpcService.getCount(WORKS_MONITOR_COUNT_LIMIT);
        int times = entity.getTimes();
        int allTimes = 1;
        String other = entity.getMonitorOther();
        allTimes = times / 1440;
        if ("1".equals(other)) {
            allTimes *= 2;
        }
        if (allTimes > allcount) {
            return 0;
        }
        entity.setTotalTimes(entity.getTimes() / entity.getMonitorRate());
        entity.setResidueTimes(entity.getTimes() / entity.getMonitorRate());
        Date monitorStartDate = new Date();
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(12, entity.getTimes());
        entity.setMonitorStartDate(monitorStartDate);
        entity.setMonitorEndDate(nowTime.getTime());
        entity.setDepletionTimes(allTimes);
        entity.setEnv(this.env);
        entity.setStatus("0");
        ((WorksMonitorMapper)this.baseMapper).insert((Object)entity);
        this.mongoTemplate.save((Object)entity);
        this.apiCallcountRpcService.deductionCount(WORKS_MONITOR_COUNT_LIMIT, allTimes, null);
        return 1;
    }

    @Override
    public WorksTrendEntity queryItemDataByHeadId(String headId) {
        List<WorksMonitorItemEntity> list = ((WorksMonitorMapper)this.baseMapper).queryItemDataByHeadId(headId);
        WorksTrendEntity result = new WorksTrendEntity();
        result.setHeadId(headId);
        result.setGatherTime((Date[])list.stream().map(el -> el.getGatherTime()).toArray(Date[]::new));
        result.setLikes((Integer[])list.stream().map(el -> el.getLikes()).toArray(Integer[]::new));
        result.setLikesAdd((Integer[])list.stream().map(el -> el.getLikesAdd()).toArray(Integer[]::new));
        result.setCollects((Integer[])list.stream().map(el -> el.getCollects()).toArray(Integer[]::new));
        result.setCollectsAdd((Integer[])list.stream().map(el -> el.getCollectsAdd()).toArray(Integer[]::new));
        result.setShares((Integer[])list.stream().map(el -> el.getShares()).toArray(Integer[]::new));
        result.setSharesAdd((Integer[])list.stream().map(el -> el.getSharesAdd()).toArray(Integer[]::new));
        result.setComments((Integer[])list.stream().map(el -> el.getComments()).toArray(Integer[]::new));
        result.setCommentsAdd((Integer[])list.stream().map(el -> el.getCommentsAdd()).toArray(Integer[]::new));
        return result;
    }

    @Override
    public List<WorksMonitorCommentEntity> queryCommDataByHeadId(String headId) {
        return ((WorksMonitorMapper)this.baseMapper).queryCommDataByHeadId(headId);
    }

    @Override
    public IPage<WorksMonitorCommentEntity> queryCommDataByHeadIdPage(Page<WorksMonitorCommentEntity> page, String headId) {
        return ((WorksMonitorMapper)this.baseMapper).queryCommDataByHeadId(page, headId);
    }

    @Override
    public IPage<WorksMonitorItemEntity> queryItemDataByHeadIdPage(Page<WorksMonitorItemEntity> page, String headId) {
        return ((WorksMonitorMapper)this.baseMapper).queryItemDataByHeadId(page, headId);
    }
}

