/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.purchasercooperation.entity.PurchaserTalentPotencyItem;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentPotencyItemMapper;
import com.els.modules.purchasercooperation.service.PurchaserTalentPotencyItemService;
import com.els.modules.suppliercooperation.entity.SupplierTalentPotencyItem;
import com.els.modules.suppliercooperation.service.SupplierTalentPotencyItemService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaserTalentPotencyItemServiceImpl
extends BaseServiceImpl<PurchaserTalentPotencyItemMapper, PurchaserTalentPotencyItem>
implements PurchaserTalentPotencyItemService {
    @Autowired
    private SupplierTalentPotencyItemService potencyItemService;

    @Override
    public int insertBatch(List<PurchaserTalentPotencyItem> purchaserTalentPotencyItemList) {
        purchaserTalentPotencyItemList.forEach(a -> {
            if (a.getHeadId() == null) {
                throw new ELSBootException("\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        int i = ((PurchaserTalentPotencyItemMapper)this.baseMapper).insertBatchSomeColumn(purchaserTalentPotencyItemList);
        return i;
    }

    @Override
    public void deleteById(List<PurchaserTalentPotencyItem> potencyItems) {
        List<PurchaserTalentPotencyItem> purchaserTalentPotencyItems = ((PurchaserTalentPotencyItemMapper)this.baseMapper).selectByIds(potencyItems, TenantContext.getTenant());
        purchaserTalentPotencyItems.forEach(a -> Assert.isTrue((boolean)"0".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u5220\u9664\u65b0\u5efa\u72b6\u6001\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u884c\u72b6\u6001\u662f\u5426\u4e3a\u65b0\u5efa")));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().in(BaseEntity::getId, potencyItems)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(BaseEntity::getDeleted, (Object)"1");
        ((PurchaserTalentPotencyItemMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void affirmPotencyById(String status, List<PurchaserTalentPotencyItem> purchaserTalentPotencyItemList) {
        List<SupplierTalentPotencyItem> potencyItems = this.checkPotency(purchaserTalentPotencyItemList);
        PurchaserTalentPotencyItem purchaserTalentPotencyItem = new PurchaserTalentPotencyItem();
        purchaserTalentPotencyItem.setItemStatus(status);
        purchaserTalentPotencyItem.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentPotencyItem.setUpdateTime(new Date());
        ((PurchaserTalentPotencyItemMapper)this.baseMapper).updateStatus(purchaserTalentPotencyItem, purchaserTalentPotencyItemList);
        this.potencyItemService.affirmTakeById(potencyItems);
    }

    private List<SupplierTalentPotencyItem> checkPotency(List<PurchaserTalentPotencyItem> purchaserTalentPotencyItemList) {
        ArrayList<SupplierTalentPotencyItem> potencyItems = new ArrayList<SupplierTalentPotencyItem>();
        if (CollectionUtils.isNotEmpty(purchaserTalentPotencyItemList)) {
            purchaserTalentPotencyItemList.forEach(a -> {
                Assert.isTrue((boolean)"1".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u5f85\u786e\u5b9a\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                SupplierTalentPotencyItem potencyItem = new SupplierTalentPotencyItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)potencyItem));
                potencyItems.add(potencyItem);
            });
            this.potencyItemService.affirmTakeById(potencyItems);
        }
        return potencyItems;
    }
}

