/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.adapter.msg;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.adapter.msg.IKsMessageAdapter;
import com.els.modules.companystore.config.KuaiShouProperties;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.KsItemsService;
import com.kuaishou.merchant.open.api.KsMerchantApiException;
import com.kuaishou.merchant.open.api.KsMerchantRequest;
import com.kuaishou.merchant.open.api.client.AccessTokenKsMerchantClient;
import com.kuaishou.merchant.open.api.request.item.OpenItemListGetRequest;
import com.kuaishou.merchant.open.api.response.item.OpenItemListGetResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"kwaishop_item_addItem"})
public class AddItemlAdapter
implements IKsMessageAdapter {
    private static final Logger log = LoggerFactory.getLogger(AddItemlAdapter.class);
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private KsItemsService ksItemsService;
    @Autowired
    private KuaiShouProperties kuaiShouProperties;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void accept(String info, String shopId) {
        log.info("\u5904\u7406\u65b0\u589e\u5546\u54c1\u4e1a\u52a1:{}|\u5c0f\u5e97id\uff1a{}", (Object)info, (Object)shopId);
        JSONObject jsonObject = JSON.parseObject((String)info);
        String itemId = jsonObject.getString("itemId");
        String sellerId = jsonObject.getString("sellerId");
        List companyStoreHeads = this.companyStoreHeadService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getShopId, (Object)shopId)).ne(BaseEntity::getElsAccount, (Object)"100000")).eq(BaseEntity::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)companyStoreHeads)) {
            companyStoreHeads.forEach(companyStoreHead -> {
                String ksShopAccessToken;
                String assertToken;
                KsItems items = (KsItems)((Object)((Object)this.ksItemsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).eq(KsItems::getDeleted, (Object)"0")).eq(KsItems::getKwaiItemId, (Object)itemId), false)));
                if (ObjectUtil.isEmpty((Object)((Object)items)) && StrUtil.isNotBlank((CharSequence)(assertToken = (String)this.redisUtil.get(ksShopAccessToken = "ks_shop_access_token:" + shopId)))) {
                    AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
                    OpenItemListGetRequest request = new OpenItemListGetRequest();
                    request.setAccessToken(assertToken);
                    request.setApiMethodVersion(1L);
                    request.setKwaiItemId(Long.valueOf(itemId));
                    request.setPageNumber(Integer.valueOf(1));
                    request.setPageSize(Integer.valueOf(10));
                    try {
                        OpenItemListGetResponse response = (OpenItemListGetResponse)client.execute((KsMerchantRequest)request);
                        Object[] param = response.getData().getItems();
                        if (ArrayUtil.isNotEmpty((Object[])param)) {
                            Object shelfItemInfoResponseParam = param[0];
                            KsItems newDb = new KsItems();
                            BeanUtil.copyProperties((Object)shelfItemInfoResponseParam, (Object)((Object)newDb), (String[])new String[0]);
                            if (ObjectUtil.isNotEmpty((Object)shelfItemInfoResponseParam.getCreateTime()) && !shelfItemInfoResponseParam.getCreateTime().equals(0L)) {
                                newDb.setItemCreateTime(new Date(shelfItemInfoResponseParam.getCreateTime()));
                            } else {
                                newDb.setItemCreateTime(null);
                            }
                            if (ObjectUtil.isNotEmpty((Object)shelfItemInfoResponseParam.getUpdateTime()) && !shelfItemInfoResponseParam.getUpdateTime().equals(0L)) {
                                newDb.setItemUpdateTime(new Date(shelfItemInfoResponseParam.getUpdateTime()));
                            } else {
                                newDb.setItemUpdateTime(null);
                            }
                            newDb.setCompany(companyStoreHead.getCompany());
                            newDb.setCompanyName(companyStoreHead.getCompanyName());
                            newDb.setShopName(companyStoreHead.getName());
                            newDb.setShopId(companyStoreHead.getShopId());
                            newDb.setElsAccount(companyStoreHead.getElsAccount());
                            newDb.setDeleted(CommonConstant.STATUS_NO);
                            this.ksItemsService.save((Object)newDb);
                        }
                    }
                    catch (KsMerchantApiException e) {
                        log.error("\u5904\u7406\u65b0\u589e\u5546\u54c1\u4e1a\u52a1", (Throwable)e);
                    }
                }
            });
        }
    }
}

