/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.CompanyStoreItem;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.excel.CompanyStoreHeadExportServiceImpl;
import com.els.modules.companystore.query.CompanyGoodsHeadQueryParam;
import com.els.modules.companystore.query.CompanyStoreHeadQueryParam;
import com.els.modules.companystore.query.CompanyTopmanRecordQueryParam;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreItemService;
import com.els.modules.companystore.service.CompanyStoreTopmanRecordService;
import com.els.modules.companystore.vo.CompanyStoreHeadVO;
import com.els.modules.companystore.vo.CompanyTopmanItemVO;
import com.els.modules.companystore.vo.KsChartsVO;
import com.els.modules.companystore.vo.KsShopItemsVO;
import com.els.modules.companystore.vo.KsTopMansVO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/companystore/companyStoreHead"})
@Api(tags={"\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934"})
public class CompanyStoreHeadController
extends BaseController<CompanyStoreHead, CompanyStoreHeadService> {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreHeadController.class);
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private CompanyStoreTopmanRecordService companyStoreTopmanRecordService;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private CompanyStoreItemService itemService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private SmsRpcService smsRpcService;

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868", notes="\u5e97\u94fa\u5217\u8868")
    @GetMapping(value={"/queryList"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> queryList(CompanyStoreHead companyStoreHead, CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)companyStoreHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        return Result.ok((Object)this.companyStoreHeadService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868", notes="\u5e97\u94fa\u5217\u8868")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> queryPageList(CompanyStoreHead companyStoreHead, CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] var;
        String platform = queryDTO.getPlatform();
        QueryWrapper<CompanyStoreHead> queryWrapper = CompanyStoreHeadQueryParam.getQueryParam(companyStoreHead, req.getParameterMap(), queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsShopType())) {
            queryWrapper.eq((Object)"type", (Object)queryDTO.getKsShopType());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsTopManNum()) && ObjectUtil.isNotEmpty((Object)(var = queryDTO.getKsTopManNum().split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var[0])) {
                queryWrapper.ge((Object)"topmanNum", (Object)var[0]);
            }
            if (var.length == 2 && ObjectUtil.isNotEmpty((Object)var[1])) {
                queryWrapper.le((Object)"topmanNum", (Object)var[1]);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsSales()) && ObjectUtil.isNotEmpty((Object)(var = queryDTO.getKsSales().split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var[0])) {
                queryWrapper.ge((Object)"salesAmountMax", (Object)var[0]);
            }
            if (var.length == 2 && ObjectUtil.isNotEmpty((Object)var[1])) {
                queryWrapper.le((Object)"salesAmountMax", (Object)var[1]);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsNum()) && ObjectUtil.isNotEmpty((Object)(var = queryDTO.getKsItemsNum().split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var[0])) {
                queryWrapper.ge((Object)"goodsNum", (Object)var[0]);
            }
            if (var.length == 2 && ObjectUtil.isNotEmpty((Object)var[1])) {
                queryWrapper.le((Object)"goodsNum", (Object)var[1]);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsAuthStatus())) {
            queryWrapper.eq((Object)"auth_state", (Object)queryDTO.getKsAuthStatus());
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if ("2".equals(platform)) {
            queryWrapper.eq((Object)"is_page_add", (Object)"1");
        }
        if ("1".equals(platform)) {
            queryWrapper.eq((Object)"data_type", (Object)1);
        }
        queryDTO.setPlatform(platform);
        queryDTO.setDataType(companyStoreHead.getDataType());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage<CompanyStoreHead> pageList = this.companyStoreHeadService.queryPage((Page<CompanyStoreHead>)page, queryWrapper, queryDTO);
        pageList.getRecords().forEach(row -> {
            if (ObjectUtil.isNotEmpty((Object)row.getExpireTime()) && System.currentTimeMillis() > row.getExpireTime().getTime()) {
                row.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue());
            }
        });
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868", notes="\u5e97\u94fa\u5217\u8868")
    @GetMapping(value={"/monitorList"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> monitorList(CompanyStoreHead companyStoreHead, CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String platform = queryDTO.getPlatform();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)companyStoreHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"platform", (Object)platform);
        queryWrapper.eq((Object)"data_type", (Object)"2");
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.companyStoreHeadService.page((IPage)page, (Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List ids = pageList.getRecords().stream().map(x -> x.getId()).collect(Collectors.toList());
            List items = this.itemService.list((Wrapper)Wrappers.lambdaQuery().in(CompanyStoreItem::getHeadId, ids));
            if (CollUtil.isNotEmpty((Collection)items)) {
                Map<String, CompanyStoreItem> maps = items.stream().collect(Collectors.toMap(x -> x.getHeadId(), y -> y));
                pageList.getRecords().forEach(row -> {
                    CompanyStoreItem item = (CompanyStoreItem)((Object)((Object)maps.get(row.getId())));
                    if (ObjectUtil.isNotEmpty((Object)((Object)item))) {
                        row.setSalesNum(item.getSalesNum());
                        row.setGoodsNum(item.getGoodsNum());
                        row.setSalesAmountMax(item.getSalesAmountMax());
                        row.setTopmanNum(item.getTopmanNum());
                        row.setLivesNum(item.getLivesNum());
                        row.setVideosNum(item.getVideosNum());
                    }
                });
            }
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody SmsDto smsDto) {
        Result result = new Result();
        smsDto.setMobile("13799766536");
        SmsResult smsResult = this.smsRpcService.sendSms(smsDto);
        result.setSuccess(smsResult.isSuccess());
        result.setMessage(smsResult.getMessage());
        return result;
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CompanyStoreHeadVO headVO) {
        CompanyStoreHead companyStoreHead = new CompanyStoreHead();
        LoginUser user = SysUtil.getLoginUser();
        headVO.setAdminId(user.getSubAccount());
        if ("2".equals(headVO.getDataType())) {
            headVO.setIsPageAdd("1");
            this.companyStoreHeadService.addMonitorShop(headVO);
            this.companyStoreHeadService.handleItems(headVO);
        } else {
            this.companyStoreHeadService.validated(headVO);
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyStoreHead));
            companyStoreHead.setBusAccount(this.getTenantId());
            this.companyStoreHeadService.saveMain(companyStoreHead, headVO);
        }
        return Result.ok((Object)((Object)companyStoreHead));
    }

    @PostMapping(value={"/monitorAdd"})
    public Result<?> monitorAdd(@RequestBody CompanyStoreHeadVO headVO) {
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        LoginUser user = SysUtil.getLoginUser();
        headVO.setAdminId(user.getSubAccount());
        int count = this.companyStoreHeadService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(CompanyStoreHead::getName, (Object)headVO.getName())).eq(CompanyStoreHead::getPlatform, (Object)headVO.getPlatform())).eq(CompanyStoreHead::getDataType, (Object)"2")).eq(CompanyStoreHead::getCompany, (Object)company)).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(CompanyStoreHead::getName, (Object)headVO.getName())).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(CompanyStoreHead::getShopId, (Object)headVO.getShopId());
            });
        }));
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u6b64\u5e97\u94fa\u5df2\u5b58\u5728");
        CompanyStoreHead companyStoreHead = new CompanyStoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyStoreHead));
        companyStoreHead.setBusAccount(this.getTenantId());
        LoginUser loginUser = SysUtil.getLoginUser();
        companyStoreHead.setAdminId(loginUser.getSubAccount());
        companyStoreHead.setAdminName(loginUser.getSubAccount());
        this.companyStoreHeadService.saveMain(companyStoreHead, headVO);
        this.companyStoreHeadService.handleItems(headVO);
        return Result.ok((Object)((Object)companyStoreHead));
    }

    @GetMapping(value={"/getKsShopDetailById"})
    public Result<?> getShopDetailById(@RequestParam(value="id") String id) {
        CompanyStoreHead companyStoreHead = this.companyStoreHeadService.getShopDetailById(id);
        return Result.ok((Object)((Object)companyStoreHead));
    }

    @GetMapping(value={"/getKsSalesCharts"})
    public Result<?> getKsSalesCharts(@RequestParam(value="id") String id) {
        List<KsChartsVO> ksChartsVOS = this.companyStoreHeadService.getKsSalesCharts(id);
        return Result.ok(ksChartsVOS);
    }

    @GetMapping(value={"/getKsShopItmes"})
    public Result<?> getKsShopItmes(CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<KsShopItemsVO> pageList = this.companyStoreHeadService.getKsShopItmes((Page<KsShopItemsVO>)page, queryDTO);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/getKsTopMans"})
    public Result<?> getKsTopMans(CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<KsTopMansVO> pageList = this.companyStoreHeadService.getKsTopMans((Page<KsTopMansVO>)page, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/ksAdd"})
    public Result<?> ksAdd(@RequestBody CompanyStoreHead companyStoreHead) {
        LoginUser user = SysUtil.getLoginUser();
        companyStoreHead.setAdminId(user.getSubAccount());
        this.companyStoreHeadService.ksAdd(companyStoreHead);
        return Result.ok();
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody CompanyStoreHeadVO headVO) {
        LoginUser user = SysUtil.getLoginUser();
        headVO.setAdminId(user.getSubAccount());
        CompanyStoreHead companyStoreHead = new CompanyStoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyStoreHead));
        this.companyStoreHeadService.updateMain(companyStoreHead, headVO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5e97\u94fa\u8be6\u60c5", notes="\u5e97\u94fa\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CompanyStoreHeadVO headVO = this.companyStoreHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(CompanyStoreOrderItem item, CompanyTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyStoreOrderItem> queryWrapper = CompanyTopmanRecordQueryParam.getQueryParam(item, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyTopmanItemVO> pageList = this.companyStoreTopmanRecordService.queryTopmanPageNew((Page<CompanyStoreOrderItem>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyStoreTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyStoreTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868", notes="\u5546\u54c1\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> queryPageList(CompanyGoodsHead goodsHead, CompanyGoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyGoodsHead> queryWrapper = CompanyGoodsHeadQueryParam.getQueryParam(goodsHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("30");
        }
        this.companyGoodsHeadService.categoryConvert(queryDTO);
        IPage<CompanyGoodsHead> pageList = this.companyGoodsHeadService.queryPage((Page<CompanyGoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/categoryCounts"})
    public Result<?> contentTypeCounts(CompanyGoodsHeadQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsHeadService.categoryCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa", notes="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    @PermissionDataView(businessType="companyStore")
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyStoreHeadExportServiceImpl.class);
    }

    @AutoLog(value="\u6296\u97f3\u76d1\u63a7\u5546\u54c1-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.companyStoreHeadService.delete(id);
        return this.commonSuccessResult(4);
    }
}

