/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doudian.open.api.open_getAuthInfo.OpenGetAuthInfoRequest;
import com.doudian.open.api.open_getAuthInfo.OpenGetAuthInfoResponse;
import com.doudian.open.api.open_getAuthInfo.data.OpenGetAuthInfoData;
import com.doudian.open.api.open_getAuthInfo.param.OpenGetAuthInfoParam;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.gson.Gson;
import com.doudian.open.utils.SignUtil;
import com.els.common.adapter.AdapterFactory;
import com.els.common.enumerate.PlatformEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.barcode.rpc.service.ElsSubAccountApiRpcService;
import com.els.modules.companystore.adapter.msg.IKsMessageAdapter;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.config.KuaiShouProperties;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.dto.KSMsgDto;
import com.els.modules.companystore.entity.CompanyStoreAuthorize;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.CompanyStoreItem;
import com.els.modules.companystore.entity.CompanyStoreTopmanItem;
import com.els.modules.companystore.entity.CompanyStoreTopmanRecord;
import com.els.modules.companystore.entity.DyItems;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.entity.KsOrderBaseInfo;
import com.els.modules.companystore.enumerate.AuthStateEnum;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.CompanyStoreAuthorizeMapper;
import com.els.modules.companystore.mapper.CompanyStoreHeadMapper;
import com.els.modules.companystore.mapper.CompanyStoreTopmanItemMapper;
import com.els.modules.companystore.mapper.CompanyStoreTopmanRecordMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreItemService;
import com.els.modules.companystore.service.DyItemsService;
import com.els.modules.companystore.service.KsItemsService;
import com.els.modules.companystore.service.KsOrderBaseInfoService;
import com.els.modules.companystore.vo.CompanyStoreHeadVO;
import com.els.modules.companystore.vo.KsChartsVO;
import com.els.modules.companystore.vo.KsShopItemsVO;
import com.els.modules.companystore.vo.KsTopMansVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Maps;
import com.kuaishou.merchant.open.api.KsMerchantApiException;
import com.kuaishou.merchant.open.api.KsMerchantRequest;
import com.kuaishou.merchant.open.api.client.AccessTokenKsMerchantClient;
import com.kuaishou.merchant.open.api.client.oauth.OauthAccessTokenKsClient;
import com.kuaishou.merchant.open.api.domain.shop.ShopInfo;
import com.kuaishou.merchant.open.api.domain.user.GetSellerInfoResponseParam;
import com.kuaishou.merchant.open.api.request.servicemarket.OpenServiceMarketBuyerServiceInfoRequest;
import com.kuaishou.merchant.open.api.request.servicemarket.OpenServiceMarketOrderListRequest;
import com.kuaishou.merchant.open.api.request.shop.OpenShopInfoGetRequest;
import com.kuaishou.merchant.open.api.request.user.OpenUserSellerGetRequest;
import com.kuaishou.merchant.open.api.response.oauth.KsAccessTokenResponse;
import com.kuaishou.merchant.open.api.response.servicemarket.OpenServiceMarketBuyerServiceInfoResponse;
import com.kuaishou.merchant.open.api.response.servicemarket.OpenServiceMarketOrderListResponse;
import com.kuaishou.merchant.open.api.response.shop.OpenShopInfoGetResponse;
import com.kuaishou.merchant.open.api.response.user.OpenUserSellerGetResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CompanyStoreHeadServiceImpl
extends BaseServiceImpl<CompanyStoreHeadMapper, CompanyStoreHead>
implements CompanyStoreHeadService {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreHeadServiceImpl.class);
    @Resource
    private CompanyStoreHeadMapper companyStoreHeadMapper;
    @Autowired
    private CompanyStoreItemService companyStoreItemService;
    @Resource
    private CompanyStoreTopmanItemMapper companyStoreTopmanItemMapper;
    @Resource
    private CompanyStoreTopmanRecordMapper companyStoreTopmanRecordMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private CompanyStoreAuthorizeMapper companyStoreAuthorizeMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DouDianProperties douDianProperties;
    @Autowired
    private KuaiShouProperties kuaiShouProperties;
    @Autowired
    private KsItemsService ksItemsService;
    @Autowired
    private KsOrderBaseInfoService ksOrderBaseInfoService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    @Lazy
    private DyItemsService dyItemsServicel;
    @Autowired
    private ElsSubAccountApiRpcService elsSubAccountApiRpcService;
    @Value(value="${spider-api.dyMonitorUrl}")
    private String dyMonitorUrl;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AdapterFactory adapterFactory;

    @Override
    public IPage<CompanyStoreHead> queryPage(Page<CompanyStoreHead> page, QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHeadQueryDTO queryDTO) {
        return ((CompanyStoreHeadMapper)this.baseMapper).companyStoreHeadPage(page, queryWrapper, queryDTO, this.permissionDataRpcService.getCompany("companyStore"));
    }

    @Override
    public List<CompanyStoreHead> queryList(QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHeadQueryDTO queryDTO) {
        return ((CompanyStoreHeadMapper)this.baseMapper).companyStoreHeadList(queryWrapper, queryDTO);
    }

    @Override
    public CompanyStoreHeadVO queryById(String id) {
        CompanyStoreHeadVO storeHeadVO = new CompanyStoreHeadVO();
        CompanyStoreHead storeHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            return storeHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)storeHead), (Object)((Object)storeHeadVO));
        String timeSelect = "30";
        CompanyStoreItem storeItem = "2".equals(storeHeadVO.getDataType()) ? (CompanyStoreItem)((Object)this.companyStoreItemService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreItem::getHeadId, (Object)id)).eq(BaseEntity::getDeleted, (Object)"0"))) : this.companyStoreItemService.queryStoreItem(id, timeSelect);
        if (storeItem != null) {
            storeHeadVO.setSalesNum(storeItem.getSalesNum());
            storeHeadVO.setSalesAmountMin(storeItem.getSalesAmountMin());
            storeHeadVO.setSalesAmountMax(storeItem.getSalesAmountMax());
            storeHeadVO.setGoodsNum(storeItem.getGoodsNum());
            storeHeadVO.setTopmanNum(storeItem.getTopmanNum());
            storeHeadVO.setVideosNum(storeItem.getVideosNum());
            storeHeadVO.setLivesNum(storeItem.getLivesNum());
            storeHeadVO.setQueryDay(storeItem.getQueryDay());
        }
        return storeHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        String platform = companyStoreHead.getPlatform();
        String account = companyStoreHead.getBusAccount();
        companyStoreHead.setStoreCode(platform + account + this.invokeBaseRpcService.getNextCode("mcnSrmStoreCode", (Object)companyStoreHead));
        ElsSubAccountDTO elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(companyStoreHead.getAdminId());
        if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
            companyStoreHead.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId()));
        }
        super.setHeadDefaultValue((BaseEntity)companyStoreHead);
        this.companyStoreHeadMapper.insert((Object)companyStoreHead);
        this.insertData(companyStoreHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        this.check(companyStoreHead.getId());
        ElsSubAccountDTO elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(companyStoreHead.getAdminId());
        String company = null;
        if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
            company = this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId());
            companyStoreHead.setCompany(company);
        }
        this.companyStoreHeadMapper.updateById((Object)companyStoreHead);
        companyStoreHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)companyStoreHead.getId())));
        this.companyStoreTopmanItemMapper.deleteByMainId(companyStoreHead.getId());
        this.insertData(companyStoreHead, headVO);
        if ("2".equals(companyStoreHead.getPlatform())) {
            this.ksItemsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(KsItems::getCompany, (Object)company)).eq(KsItems::getShopId, (Object)companyStoreHead.getShopId())).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
            this.ksOrderBaseInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(KsOrderBaseInfo::getCompany, (Object)company)).eq(KsOrderBaseInfo::getShopId, (Object)companyStoreHead.getShopId())).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
        }
    }

    private void check(String id) {
        CompanyStoreHead storeHead = (CompanyStoreHead)((Object)super.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            throw new ELSBootException("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u5e97\u94fa\u6570\u636e\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!TenantContext.getTenant().equals(storeHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u5e97\u94fa\u6570\u636e");
        }
    }

    private void insertData(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        List<CompanyStoreTopmanRecord> records;
        List<CompanyStoreItem> companyStoreItemList = headVO.getCompanyStoreItemList();
        List<CompanyStoreTopmanItem> companyStoreTopmanItemList = headVO.getCompanyStoreTopmanItemList();
        List<CompanyStoreTopmanRecord> companyStoreTopmanRecordList = headVO.getCompanyStoreTopmanRecordList();
        if (!CollectionUtils.isEmpty(companyStoreItemList)) {
            for (CompanyStoreItem companyStoreItem : companyStoreItemList) {
                companyStoreItem.setHeadId(companyStoreHead.getId());
                SysUtil.setSysParam((BaseEntity)companyStoreItem, (BaseEntity)companyStoreHead);
            }
            if (!companyStoreItemList.isEmpty()) {
                this.companyStoreItemService.saveBatch(companyStoreItemList);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1");
            list.add("7");
            list.add("30");
            list.add("90");
            ArrayList<CompanyStoreItem> arrayList = new ArrayList<CompanyStoreItem>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String queryDay = (String)iterator.next();
                CompanyStoreItem entity = new CompanyStoreItem();
                entity.setHeadId(companyStoreHead.getId());
                entity.setQueryDay(queryDay);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)companyStoreHead);
                arrayList.add(entity);
            }
            if (!arrayList.isEmpty()) {
                this.companyStoreItemService.saveBatch(arrayList);
            }
        }
        if (!CollectionUtils.isEmpty(companyStoreTopmanRecordList)) {
            for (CompanyStoreTopmanRecord companyStoreTopmanRecord : companyStoreTopmanRecordList) {
                companyStoreTopmanRecord.setHeadId(companyStoreHead.getId());
                SysUtil.setSysParam((BaseEntity)companyStoreTopmanRecord, (BaseEntity)companyStoreHead);
            }
            if (!companyStoreTopmanRecordList.isEmpty()) {
                this.companyStoreTopmanRecordMapper.insertBatchSomeColumn(companyStoreTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.companyStoreTopmanRecordMapper.selectByMainId(companyStoreHead.getId()))) {
            for (CompanyStoreTopmanRecord entity : records) {
                if (CollectionUtils.isEmpty(companyStoreTopmanItemList)) continue;
                for (CompanyStoreTopmanItem entity2 : companyStoreTopmanItemList) {
                    entity2.setRecordId(entity.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)companyStoreHead);
                }
                if (companyStoreTopmanItemList.isEmpty()) continue;
                this.companyStoreTopmanItemMapper.insertBatchSomeColumn(companyStoreTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.companyStoreTopmanRecordMapper.deleteByMainId(id);
        this.companyStoreHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.companyStoreTopmanRecordMapper.deleteByMainId(serializable.toString());
            this.companyStoreHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void validated(CompanyStoreHeadVO headVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CompanyStoreHead::getShopId, (Object)headVO.getShopId())).eq(CompanyStoreHead::getPlatform, (Object)headVO.getPlatform())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List companyStoreHeads = ((CompanyStoreHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)companyStoreHeads), (String)"\u91cd\u590d\u6dfb\u52a0\u8be5\u5e97\u94fa\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Override
    public AccessTokenResponse callBack(final String code) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("code", code);
                this.put("grant_type", "authorization_code");
            }
        };
        return this.executeAuthorizeToken("token.create", param, true);
    }

    private void updateAuthorizeStatus(String shopId, OpenGetAuthInfoResponse authInfoResponse) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreHead::getShopId, (Object)shopId);
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)((CompanyStoreHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (companyStoreHead != null) {
            companyStoreHead.setAuthTime(new Date());
            companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.APPROVED.getValue());
            OpenGetAuthInfoData data = (OpenGetAuthInfoData)authInfoResponse.getData();
            if (ObjectUtil.isNotEmpty((Object)data)) {
                companyStoreHead.setAuthState(data.getStatus() + "");
                companyStoreHead.setAuthTime(new Date(data.getAuthSuccessTime() * 1000L));
                companyStoreHead.setAuthExpireTime(new Date(data.getAuthEndTime() * 1000L));
            }
            ((CompanyStoreHeadMapper)this.baseMapper).updateById((Object)companyStoreHead);
        }
    }

    private void updateAuthorizeData(AccessTokenData data, OpenGetAuthInfoResponse authInfoResponse) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreAuthorize::getShopId, (Object)data.getShopId());
        CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)Optional.ofNullable(this.companyStoreAuthorizeMapper.selectOne((Wrapper)queryWrapper)).orElse((Object)new CompanyStoreAuthorize()));
        companyStoreAuthorize.setRefreshToken(data.getRefreshToken());
        companyStoreAuthorize.setShopId(data.getShopId());
        companyStoreAuthorize.setAccessToken(data.getAccessToken());
        companyStoreAuthorize.setPlatform("1");
        companyStoreAuthorize.setAuthPeriod(this.douDianProperties.getAuthPeriod());
        if (ObjectUtil.isNotEmpty((Object)authInfoResponse)) {
            companyStoreAuthorize.setValidityPeriod(new Date(((OpenGetAuthInfoData)authInfoResponse.getData()).getAuthEndTime() * 1000L));
        }
        if (companyStoreAuthorize.getId() != null) {
            companyStoreAuthorize.setUpdateBy(companyStoreAuthorize.getSubAccount());
            companyStoreAuthorize.setUpdateTime(new Date());
            this.companyStoreAuthorizeMapper.updateById((Object)companyStoreAuthorize);
        } else {
            companyStoreAuthorize.setCreateBy(companyStoreAuthorize.getSubAccount());
            companyStoreAuthorize.setCreateTime(new Date());
            this.companyStoreAuthorizeMapper.insert((Object)companyStoreAuthorize);
        }
    }

    private OpenGetAuthInfoResponse getDyAUthInfo(AccessTokenData data) {
        OpenGetAuthInfoRequest request = new OpenGetAuthInfoRequest();
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey(this.douDianProperties.getAppKey());
        doudianOpConfig.setAppSecret(this.douDianProperties.getAppSecret());
        request.setConfig(doudianOpConfig);
        OpenGetAuthInfoParam param = (OpenGetAuthInfoParam)request.getParam();
        param.setAuthId(data.getShopId());
        AccessToken accessToken = AccessToken.wrap("a771906e-c0a3-42b1-a868-ca4b68be0b54", "501772d3-3de4-437c-b1f7-091e9f409530");
        OpenGetAuthInfoResponse response = (OpenGetAuthInfoResponse)request.execute(accessToken);
        return response;
    }

    @Override
    public boolean startAuthorize(String shopId) {
        String shopAccessToken = "shopAccessToken" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(shopAccessToken);
        if (data != null) {
            data.setExpiresIn(this.redisUtil.getExpire(shopAccessToken));
            this.updateAuthorizeData(data, null);
            this.updateAuthorizeStatus(shopId, null);
            return false;
        }
        this.redisUtil.set("shopAuthorize" + shopId, (Object)SysUtil.getLoginUser(), 600L);
        return true;
    }

    @Override
    public AccessTokenData getAuthorizeToken(String shopId) throws IOException {
        String shopAccessToken = "shopAccessToken" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(shopAccessToken);
        if (data == null) {
            data = (AccessTokenData)this.refreshToken(shopId).getData();
        }
        return data;
    }

    @Override
    public AccessTokenResponse refreshToken(String shopId) throws IOException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreAuthorize::getShopId, (Object)shopId);
        final CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)this.companyStoreAuthorizeMapper.selectOne((Wrapper)queryWrapper));
        if (companyStoreAuthorize == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8d85\u51fa\u6388\u6743\u9650\u671f\uff0c\u8bf7\u91cd\u65b0\u6388\u6743"));
        }
        HashMap<String, String> param = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("refresh_token", companyStoreAuthorize.getRefreshToken());
                this.put("grant_type", "refresh_token");
            }
        };
        LoginUser loginUser = new LoginUser();
        loginUser.setElsAccount(companyStoreAuthorize.getElsAccount());
        loginUser.setSubAccount(companyStoreAuthorize.getSubAccount());
        return this.executeAuthorizeToken("token.refresh", param, false);
    }

    @Override
    public void ksCallBack(String code) {
        String appKey = this.kuaiShouProperties.getAppKey();
        String appSecret = this.kuaiShouProperties.getAppSecret();
        String grantCode = code;
        OauthAccessTokenKsClient oauthAccessTokenKsClient = new OauthAccessTokenKsClient(appKey, appSecret);
        KsAccessTokenResponse response = null;
        try {
            response = oauthAccessTokenKsClient.getAccessToken(grantCode);
            log.info("access response is {}", (Object)JSON.toJSONString((Object)response));
            if (StrUtil.isNotBlank((CharSequence)response.getAccessToken())) {
                this.handleKsShop(response);
            }
        }
        catch (Exception e) {
            log.error("\u5feb\u624b\u6388\u6743\u5f02\u5e38:", (Throwable)e);
        }
        if (StrUtil.isBlank((CharSequence)response.getAccessToken())) {
            throw new ELSBootException("\u6388\u6743\u5f02\u5e38:" + response.getErrorMsg());
        }
    }

    @Override
    public List<DictModel> getStores(String tenant, String platForm) {
        return ((CompanyStoreHeadMapper)this.baseMapper).getStores(tenant, platForm);
    }

    @Override
    public void ksAdd(CompanyStoreHead companyStoreHead) {
        this.checkMarketOrder(companyStoreHead);
        CompanyStoreHead db = (CompanyStoreHead)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getName, (Object)companyStoreHead.getName()), false));
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            companyStoreHead.setPlatform("2");
            companyStoreHead.setElsAccount(TenantContext.getTenant());
            companyStoreHead.setAuthState("0");
            companyStoreHead.setIsPageAdd("1");
            ElsSubAccountDTO elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(companyStoreHead.getAdminId());
            if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
                companyStoreHead.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId()));
            }
            this.save((Object)companyStoreHead);
        } else {
            Assert.isTrue((StrUtil.isEmpty((CharSequence)db.getElsAccount()) || db.getElsAccount().equals("100000") ? 1 : 0) != 0, (String)"\u8be5\u4f01\u4e1a\u5df2\u88ab\u6dfb\u52a0");
            db.setElsAccount(TenantContext.getTenant());
            db.setIsPageAdd("1");
            this.updateById((Object)db);
        }
    }

    @Override
    public CompanyStoreHead getShopDetailById(String id) {
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)id)));
        int goodsNum = this.ksItemsService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).eq(KsItems::getShopId, (Object)companyStoreHead.getShopId())).eq(KsItems::getDeleted, (Object)"0"));
        companyStoreHead.setGoodsNum(goodsNum + "");
        companyStoreHead.setD30SaleNum(((CompanyStoreHeadMapper)this.baseMapper).getD30SaleNumByShopId(companyStoreHead.getShopId()));
        companyStoreHead.setD30SaleVol(((CompanyStoreHeadMapper)this.baseMapper).getD30SaleVolByShopId(companyStoreHead.getShopId()));
        companyStoreHead.setD30TopManNum(((CompanyStoreHeadMapper)this.baseMapper).getD30TopManNumByShopId(companyStoreHead.getShopId()));
        return companyStoreHead;
    }

    @Override
    public IPage<KsShopItemsVO> getKsShopItmes(Page<KsShopItemsVO> page, CompanyStoreHeadQueryDTO queryDTO) {
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)queryDTO.getId())));
        queryDTO.setShopId(companyStoreHead.getShopId());
        queryDTO.setElsAccount(companyStoreHead.getElsAccount());
        return ((CompanyStoreHeadMapper)this.baseMapper).getKsShopItmes(page, queryDTO);
    }

    @Override
    public IPage<KsTopMansVO> getKsTopMans(Page<KsTopMansVO> page, CompanyStoreHeadQueryDTO queryDTO) {
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)queryDTO.getId())));
        queryDTO.setShopId(companyStoreHead.getShopId());
        queryDTO.setElsAccount(companyStoreHead.getElsAccount());
        return ((CompanyStoreHeadMapper)this.baseMapper).getKsTopMans(page, queryDTO);
    }

    @Override
    public List<KsChartsVO> getKsSalesCharts(String id) {
        HashMap saleValMap;
        ArrayList saleVals;
        HashMap saleNumMap;
        Date now = new Date();
        ArrayList saleNums = ((CompanyStoreHeadMapper)this.baseMapper).getSaleNum(id);
        if (saleNums == null) {
            saleNums = Lists.newArrayList();
        }
        if ((saleNumMap = saleNums.stream().collect(Collectors.toMap(x -> x.getLabel(), y -> y.getSaleNum()))) == null) {
            saleNumMap = Maps.newHashMap();
        }
        if ((saleVals = ((CompanyStoreHeadMapper)this.baseMapper).getSaleVal(id)) == null) {
            saleVals = Lists.newArrayList();
        }
        if ((saleValMap = saleVals.stream().collect(Collectors.toMap(x -> x.getLabel(), y -> y.getSaleVal()))) == null) {
            saleValMap = Maps.newHashMap();
        }
        ArrayList chartsVOS = Lists.newArrayList();
        for (int i = -29; i <= 0; ++i) {
            String x2 = DateUtil.format((Date)DateUtil.offsetDay((Date)now, (int)i).toJdkDate(), (String)"yyyy-MM-dd");
            KsChartsVO ksChartsVO = new KsChartsVO();
            ksChartsVO.setLabel(x2);
            ksChartsVO.setSaleNum((String)saleNumMap.get(x2));
            ksChartsVO.setSaleVal((String)saleValMap.get(x2));
            chartsVOS.add(ksChartsVO);
        }
        return chartsVOS;
    }

    @Override
    public void addMonitorShop(CompanyStoreHeadVO headVO) {
        int count;
        ElsSubAccountDTO elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(headVO.getAdminId());
        String company = null;
        if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
            company = this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId());
            headVO.setCompany(company);
        }
        Assert.isTrue(((count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(CompanyStoreHead::getName, (Object)headVO.getName())).eq(CompanyStoreHead::getPlatform, (Object)headVO.getPlatform())).eq(CompanyStoreHead::getDataType, (Object)"2")).eq(CompanyStoreHead::getCompany, (Object)company)).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(CompanyStoreHead::getName, (Object)headVO.getName())).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(CompanyStoreHead::getShopId, (Object)headVO.getShopId());
            });
        }))) == 0 ? 1 : 0) != 0, (String)"\u6b64\u5e97\u94fa\u5df2\u5b58\u5728");
        headVO.setPlatform("1");
        headVO.setElsAccount(TenantContext.getTenant());
        headVO.setAuthState("0");
        headVO.setIsPageAdd("1");
        this.save((Object)headVO);
    }

    @Override
    public void delete(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void handleItems(CompanyStoreHeadVO headVO) {
        String elsAccount = TenantContext.getTenant();
        if (StrUtil.isNotBlank((CharSequence)headVO.getShopId())) {
            DyItems items = (DyItems)((Object)this.dyItemsServicel.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyItems::getShopId, (Object)headVO.getShopId())).eq(DyItems::getDeleted, (Object)"0")).last(" limit 1"), false));
            if (ObjectUtil.isNotEmpty((Object)((Object)items))) {
                List copys = this.dyItemsServicel.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyItems::getShopId, (Object)headVO.getShopId())).eq(DyItems::getDeleted, (Object)"0")).eq(BaseEntity::getElsAccount, (Object)items.getElsAccount()));
                ArrayList dbs = Lists.newArrayList();
                copys.forEach(copy -> {
                    copy.setElsAccount(elsAccount);
                    copy.setId(null);
                    dbs.add(copy);
                });
                this.dyItemsServicel.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyItems::getShopId, (Object)headVO.getShopId())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
                this.dyItemsServicel.saveBatch(dbs);
                List os = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getShopId, (Object)headVO.getShopId())).eq(BaseEntity::getDeleted, (Object)"0")).isNotNull(CompanyStoreHead::getLogo)).ne(BaseEntity::getId, (Object)headVO.getId()));
                if (CollUtil.isNotEmpty((Collection)os)) {
                    CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)os.get(0));
                    TenantContext.setTenant((String)companyStoreHead.getElsAccount());
                    List companyStoreItems = this.companyStoreItemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreItem::getHeadId, (Object)companyStoreHead.getId())).eq(BaseEntity::getDeleted, (Object)"0"));
                    LoginUser loginUser = SysUtil.getLoginUser();
                    companyStoreHead.setAdminId(loginUser.getSubAccount());
                    companyStoreHead.setElsAccount(headVO.getElsAccount());
                    companyStoreHead.setCompany(headVO.getCompany());
                    companyStoreHead.setId(headVO.getId());
                    companyStoreItems.forEach(row -> {
                        row.setHeadId(companyStoreHead.getId());
                        row.setId(null);
                        row.setElsAccount(companyStoreHead.getElsAccount());
                    });
                    TenantContext.setTenant((String)loginUser.getElsAccount());
                    this.companyStoreItemService.saveBatch(companyStoreItems);
                    this.updateById((Object)companyStoreHead);
                }
            } else {
                ArrayList shops = Lists.newArrayList();
                HashMap shopMap = Maps.newHashMap();
                shopMap.put("shopId", headVO.getShopId());
                shopMap.put("needShopData", "1".equals(headVO.getIsPageAdd()));
                shopMap.put("shopName", headVO.getName());
                shops.add(shopMap);
                HashMap params = Maps.newHashMap();
                params.put("platform", "1");
                params.put("shops", shops);
                ResponseEntity res = this.restTemplate.postForEntity(this.dyMonitorUrl, (Object)params, String.class, new Object[0]);
                log.info("\u76d1\u63a7\u6296\u5e97\u8c03\u7528python\u63a5\u53e3\uff0curl[{}],\u5165\u53c2:[{}],\u54cd\u5e94:[{}]", new Object[]{this.dyMonitorUrl, JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), res});
            }
        }
    }

    @Override
    public void acceptKsEvent(String events) {
        KSMsgDto ksMsgDto = (KSMsgDto)JSON.parseObject((String)events, KSMsgDto.class);
        if (ObjectUtil.isEmpty((Object)ksMsgDto) || StrUtil.isBlank((CharSequence)ksMsgDto.getEvent())) {
            return;
        }
        IKsMessageAdapter adapter = (IKsMessageAdapter)this.adapterFactory.get(ksMsgDto.getEvent(), IKsMessageAdapter.class);
        if (ObjectUtil.isNotEmpty((Object)adapter)) {
            adapter.accept(ksMsgDto.getInfo(), ksMsgDto.getOpenId());
        }
    }

    @Override
    public Map<String, CompanyStoreHead> getDyInitData() {
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getPlatform, (Object)PlatformEnum.DOU_YIN.value)).eq(CompanyStoreHead::getAuthState, (Object)AuthStateEnum.AUTHORIZED.getValue())).eq(BaseEntity::getDeleted, (Object)"0")).lt(CompanyStoreHead::getAuthTime, (Object)new Date()));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)list), (String)"\u672a\u6709\u6388\u6743\u5e97\u94fa");
        Map<String, CompanyStoreHead> storeMap = list.stream().collect(Collectors.toMap(x -> x.getShopId(), y -> y));
        return storeMap;
    }

    private String getKsClientAccessToken() {
        String redisKey = "ks_client_access_token";
        if (this.redisUtil.hasKey(redisKey)) {
            return this.redisUtil.get(redisKey).toString();
        }
        String url = "https://openapi.kwaixiaodian.com/oauth2/access_token?app_id=" + this.kuaiShouProperties.getAppKey() + "&grant_type=client_credentials&app_secret=" + this.kuaiShouProperties.getAppSecret();
        String get = HttpUtil.get((String)url);
        JSONObject jsonObject = JSONObject.parseObject((String)get);
        Long expiresIn = jsonObject.getLong("expires_in");
        this.redisUtil.set(redisKey, (Object)jsonObject.getString("access_token"), expiresIn.longValue());
        return jsonObject.getString("access_token");
    }

    public static void main(String[] args) {
        OpenGetAuthInfoRequest request = new OpenGetAuthInfoRequest();
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey("7238784366355154487");
        doudianOpConfig.setAppSecret("1c216dd8-7cab-40fb-99cd-33d2273f68ce");
        request.setConfig(doudianOpConfig);
        OpenGetAuthInfoParam param = (OpenGetAuthInfoParam)request.getParam();
        param.setAuthId("4463798");
        AccessToken accessToken = AccessToken.wrap("a771906e-c0a3-42b1-a868-ca4b68be0b54", "501772d3-3de4-437c-b1f7-091e9f409530");
        OpenGetAuthInfoResponse response = (OpenGetAuthInfoResponse)request.execute(accessToken);
        System.out.println(DateUtil.formatDateTime((Date)new Date(((OpenGetAuthInfoData)response.getData()).getAuthEndTime() * 1000L)));
    }

    private void checkMarketOrder(CompanyStoreHead companyStoreHead) {
        String accessToken = this.getKsClientAccessToken();
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        Long startTime = DateUtil.offsetMonth((Date)new Date(), (int)-36).getTime();
        boolean endFlag = true;
        int pageNum = 1;
        while (endFlag) {
            if (startTime > System.currentTimeMillis()) {
                return;
            }
            OpenServiceMarketOrderListRequest request = new OpenServiceMarketOrderListRequest();
            request.setAccessToken(accessToken);
            request.setApiMethodVersion(1L);
            request.setStartTime(startTime);
            request.setEndTime(Long.valueOf(System.currentTimeMillis()));
            request.setQueryType(Integer.valueOf(2));
            request.setPageSize(Integer.valueOf(100));
            request.setPageNum(Integer.valueOf(pageNum));
            OpenServiceMarketOrderListResponse response = null;
            try {
                response = (OpenServiceMarketOrderListResponse)client.execute((KsMerchantRequest)request);
                Assert.isTrue((response.getData().getTotalCount() > 0L ? 1 : 0) != 0, (String)"\u8bf7\u6838\u5bf9\u5e97\u94fa\u540d\u79f0\u662f\u5426\u548c\u6388\u6743\u5e97\u94fa\u540d\u5b8c\u5168\u4e00\u81f4\u3002");
                Assert.isTrue((response.getData().getOrderList().size() > 0 ? 1 : 0) != 0, (String)"\u8bf7\u6838\u5bf9\u5e97\u94fa\u540d\u79f0\u662f\u5426\u548c\u6388\u6743\u5e97\u94fa\u540d\u5b8c\u5168\u4e00\u81f4\u3002");
                if (response.getData().getOrderList().stream().filter(x -> x.getBuyerShopName().equals(companyStoreHead.getName())).count() > 0L) {
                    return;
                }
                ++pageNum;
            }
            catch (KsMerchantApiException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private GetSellerInfoResponseParam getKsSellerInfo(String accessToken) {
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        OpenUserSellerGetRequest request = new OpenUserSellerGetRequest();
        request.setAccessToken(accessToken);
        request.setApiMethodVersion(1L);
        try {
            OpenUserSellerGetResponse response = (OpenUserSellerGetResponse)client.execute((KsMerchantRequest)request);
            return response.getData();
        }
        catch (KsMerchantApiException e) {
            log.error("KsMerchantApiException", (Throwable)e);
            return null;
        }
    }

    private void handleKsShop(KsAccessTokenResponse tokenResponse) throws KsMerchantApiException {
        GetSellerInfoResponseParam seller = this.getKsSellerInfo(tokenResponse.getAccessToken());
        if (ObjectUtil.isEmpty((Object)seller)) {
            seller = new GetSellerInfoResponseParam();
            seller.setOpenId(tokenResponse.getOpenId());
        }
        log.info("seller:{}", (Object)JSON.toJSONString((Object)seller));
        String appKey = this.kuaiShouProperties.getAppKey();
        String signSecret = this.kuaiShouProperties.getSignSecret();
        log.info("appKey:{},signSecret:{}", (Object)appKey, (Object)signSecret);
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(appKey, signSecret);
        String ksShopAccessToken = "ks_shop_access_token:" + seller.getOpenId();
        this.redisUtil.set(ksShopAccessToken, (Object)tokenResponse.getAccessToken(), tokenResponse.getExpiresIn());
        OpenServiceMarketBuyerServiceInfoResponse serviceOrderResponse = this.getServiceOrder(tokenResponse.getAccessToken(), seller.getOpenId());
        OpenShopInfoGetResponse response = null;
        OpenShopInfoGetRequest request = new OpenShopInfoGetRequest();
        request.setAccessToken(tokenResponse.getAccessToken());
        request.setApiMethodVersion(1L);
        response = (OpenShopInfoGetResponse)client.execute((KsMerchantRequest)request);
        ShopInfo shopInfo = response.getData();
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getName, (Object)shopInfo.getShopName())).eq(CompanyStoreHead::getPlatform, (Object)"2"), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)companyStoreHead))) {
            companyStoreHead.setShopId(seller.getOpenId());
            companyStoreHead.setLogo(seller.getHead());
            if (ObjectUtil.isNotEmpty((Object)seller.getSellerId())) {
                companyStoreHead.setSellerId(seller.getSellerId().toString());
            }
            companyStoreHead.setAuthState(AuthStateEnum.AUTHORIZED.getValue());
            if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse)) {
                log.info("serviceOrderResponse : {}", (Object)JSON.toJSONString((Object)serviceOrderResponse));
                if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse.getData().getAuthorized())) {
                    companyStoreHead.setAuthState(serviceOrderResponse.getData().getAuthorized() != false ? AuthStateEnum.AUTHORIZED.getValue() : AuthStateEnum.PENDING.getValue());
                }
                if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse.getData().getEndTime()) && !serviceOrderResponse.getData().getEndTime().equals(0L)) {
                    companyStoreHead.setExpireTime(new Date(serviceOrderResponse.getData().getEndTime()));
                }
            }
            companyStoreHead.setType(shopInfo.getShopType().toString());
            companyStoreHead.setAuthTime(new Date());
            this.updateById((Object)companyStoreHead);
        } else {
            companyStoreHead = new CompanyStoreHead();
            companyStoreHead.setShopId(seller.getOpenId());
            companyStoreHead.setLogo(seller.getHead());
            if (ObjectUtil.isNotEmpty((Object)seller.getSellerId())) {
                companyStoreHead.setSellerId(seller.getSellerId().toString());
            }
            companyStoreHead.setAuthState(AuthStateEnum.AUTHORIZED.getValue());
            if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse)) {
                if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse.getData().getAuthorized())) {
                    companyStoreHead.setAuthState(serviceOrderResponse.getData().getAuthorized() != false ? AuthStateEnum.AUTHORIZED.getValue() : AuthStateEnum.PENDING.getValue());
                }
                if (ObjectUtil.isNotEmpty((Object)serviceOrderResponse.getData().getEndTime()) && !serviceOrderResponse.getData().getEndTime().equals(0L)) {
                    companyStoreHead.setExpireTime(new Date(serviceOrderResponse.getData().getEndTime()));
                }
            }
            companyStoreHead.setName(shopInfo.getShopName());
            companyStoreHead.setType(shopInfo.getShopType().toString());
            companyStoreHead.setPlatform("2");
            companyStoreHead.setAuthTime(new Date());
            this.save((Object)companyStoreHead);
        }
    }

    private OpenServiceMarketBuyerServiceInfoResponse getServiceOrder(String accessToken, String openId) {
        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
        OpenServiceMarketBuyerServiceInfoRequest request = new OpenServiceMarketBuyerServiceInfoRequest();
        request.setAccessToken(accessToken);
        request.setApiMethodVersion(1L);
        request.setBuyerOpenId(openId);
        OpenServiceMarketBuyerServiceInfoResponse response = null;
        try {
            response = (OpenServiceMarketBuyerServiceInfoResponse)client.execute((KsMerchantRequest)request);
        }
        catch (KsMerchantApiException e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
        }
        return response;
    }

    private AccessTokenResponse executeAuthorizeToken(String method, HashMap<String, String> param, boolean isFirst) throws IOException {
        String line;
        String appKey = this.douDianProperties.getAppKey();
        String appSecret = this.douDianProperties.getAppSecret();
        String url = this.douDianProperties.getUrl();
        String paramJson = JSON.toJSONString(param);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        String sign = SignUtil.sign(appKey, appSecret, method, timestamp, paramJson, "2");
        String authUrl = url + "/" + method.replace(".", "/") + "?method=" + URLEncoder.encode(method, "UTF-8") + "&app_key=" + URLEncoder.encode(appKey, "UTF-8") + "&timestamp=" + URLEncoder.encode(timestamp, "UTF-8") + "&v=" + URLEncoder.encode(this.douDianProperties.getVersion(), "UTF-8") + "&param_json=" + URLEncoder.encode(paramJson, "UTF-8") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
        URL urlConnect = new URL(authUrl);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        StringBuilder result = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        Gson gson = new Gson();
        AccessTokenResponse accessTokenData = gson.fromJson(result.toString(), AccessTokenResponse.class);
        log.info("accessTokenData is {}", (Object)JSON.toJSONString((Object)accessTokenData));
        Assert.isTrue((boolean)accessTokenData.isSuccess(), (String)"\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6388\u6743");
        String shopId = ((AccessTokenData)accessTokenData.getData()).getShopId();
        AccessTokenData data = (AccessTokenData)accessTokenData.getData();
        this.redisUtil.set("dy_shop_access_token:" + shopId, (Object)data, data.getExpiresIn().longValue());
        OpenGetAuthInfoResponse authInfoResponse = this.getDyAUthInfo(data);
        this.updateAuthorizeData(data, authInfoResponse);
        this.updateAuthorizeStatus(shopId, authInfoResponse);
        return accessTokenData;
    }
}

