/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.companystore.entity.KsItemsCategory;
import com.els.modules.companystore.mapper.KsItemsCategoryMapper;
import com.els.modules.companystore.service.KsItemsCategoryService;
import com.els.modules.companystore.vo.GoodsCategoryVo;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class KsItemsCategoryServiceImpl
extends BaseServiceImpl<KsItemsCategoryMapper, KsItemsCategory>
implements KsItemsCategoryService {
    @Override
    public void add(KsItemsCategory ksItemsCategory) {
        ((KsItemsCategoryMapper)this.baseMapper).insert((Object)ksItemsCategory);
    }

    @Override
    public void edit(KsItemsCategory ksItemsCategory) {
        int count = ((KsItemsCategoryMapper)this.baseMapper).updateById((Object)ksItemsCategory);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((KsItemsCategoryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((KsItemsCategoryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<Tree<Integer>> ksCategory() {
        List dbs = this.list();
        List goodsCategoryVos = dbs.stream().map(x -> {
            GoodsCategoryVo vo = new GoodsCategoryVo();
            vo.setCategoryId(x.getCategoryId());
            vo.setParentId(x.getCategoryPid());
            vo.setTitle(x.getCategoryName());
            return vo;
        }).collect(Collectors.toList());
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setIdKey("categoryId");
        treeNodeConfig.setNameKey("title");
        treeNodeConfig.setParentIdKey("parentId");
        treeNodeConfig.setChildrenKey("children");
        List treeNodes = TreeUtil.build(goodsCategoryVos, (Object)0, (TreeNodeConfig)treeNodeConfig, (treeNode, tree) -> {
            tree.setId((Object)treeNode.getCategoryId());
            tree.setParentId((Object)treeNode.getParentId());
            tree.setName((CharSequence)treeNode.getTitle());
            tree.putExtra("id", (Object)treeNode.getCategoryId());
            tree.putExtra("description", (Object)"cascader");
            tree.putExtra("value", (Object)treeNode.getCategoryId());
        });
        return treeNodes;
    }
}

