/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.entity.CompanyStoreAuthorize;
import com.els.modules.companystore.mapper.CompanyStoreAuthorizeMapper;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DouDianApiUtil {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DouDianProperties douDianProperties;
    @Resource
    private CompanyStoreAuthorizeMapper companyStoreAuthorizeMapper;

    public DoudianOpConfig getDoudianOpConfig() {
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey(this.douDianProperties.getAppKey());
        doudianOpConfig.setAppSecret(this.douDianProperties.getAppSecret());
        return doudianOpConfig;
    }

    public AccessToken getToken(String shopId) {
        String dyShopAccessToken = "dy_shop_access_token:" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(dyShopAccessToken);
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return AccessToken.wrap(data.getAccessToken(), data.getRefreshToken());
        }
        CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)this.companyStoreAuthorizeMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreAuthorize::getShopId, (Object)shopId)));
        if (ObjectUtil.isEmpty((Object)((Object)companyStoreAuthorize)) || StrUtil.isBlank((CharSequence)companyStoreAuthorize.getAccessToken()) || StrUtil.isBlank((CharSequence)companyStoreAuthorize.getRefreshToken())) {
            return null;
        }
        return AccessToken.wrap(companyStoreAuthorize.getAccessToken(), companyStoreAuthorize.getRefreshToken());
    }
}

