/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.intentioninvest.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.intentioninvest.entity.IntentionInvestHead;
import com.els.modules.intentioninvest.entity.IntentionServiceComm;
import com.els.modules.intentioninvest.entity.IntentionServiceFee;
import com.els.modules.intentioninvest.enumerate.BusStatusEmun;
import com.els.modules.intentioninvest.mapper.IntentionInvestHeadMapper;
import com.els.modules.intentioninvest.service.IntentionInvestHeadService;
import com.els.modules.intentioninvest.service.IntentionServiceCommService;
import com.els.modules.intentioninvest.service.IntentionServiceFeeService;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntentionInvestHeadServiceImpl
extends BaseServiceImpl<IntentionInvestHeadMapper, IntentionInvestHead>
implements IntentionInvestHeadService {
    @Resource
    private IntentionServiceFeeService intentionServiceFeeService;
    @Resource
    private IntentionServiceCommService intentionServiceCommService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Resource
    private WorkflowAuditRpcService workflowAuditRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(IntentionInvestHead intentionInvestHead, List<IntentionServiceFee> intentionServiceFeeList, List<IntentionServiceComm> intentionServiceCommList) {
        intentionInvestHead.setBusStatus(BusStatusEmun.NEWLY_BUILD.getValue());
        this.handleBefore(intentionInvestHead, BusStatusEmun.NEWLY_BUILD);
        ((IntentionInvestHeadMapper)this.baseMapper).insert((Object)intentionInvestHead);
        super.setHeadDefaultValue((BaseEntity)intentionInvestHead);
        this.insertData(intentionInvestHead, intentionServiceFeeList, intentionServiceCommList);
    }

    private void handleBefore(IntentionInvestHead intentionInvestHead, BusStatusEmun step) {
        intentionInvestHead.setCompanyCode(this.subaccountOrgRpcService.getSubaccountOrgCode());
        if (StrUtil.isBlank((CharSequence)intentionInvestHead.getBusNumber())) {
            intentionInvestHead.setBusNumber(this.invokeBaseRpcService.getNextCode("intentionInvestNumber", (Object)intentionInvestHead));
        }
        if ("1".equals(intentionInvestHead.getResultAudit())) {
            intentionInvestHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            intentionInvestHead.setResultAudit("0");
            intentionInvestHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (step.equals((Object)BusStatusEmun.QUOTED)) {
            if ("1".equals(intentionInvestHead.getResultAudit())) {
                intentionInvestHead.setBusStatus(BusStatusEmun.QUOTED.getValue());
                intentionInvestHead.setResultAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
                this.saveOrUpdate((Object)intentionInvestHead);
                this.submitAudit(intentionInvestHead);
            } else {
                intentionInvestHead.setBusStatus(BusStatusEmun.LAUNCH.getValue());
            }
        }
    }

    public void submitAudit(IntentionInvestHead intentionInvestHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(intentionInvestHead.getId());
        if (StringUtils.isNotBlank((CharSequence)intentionInvestHead.getResultFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(intentionInvestHead.getResultFlowId())));
        }
        auditInputParamVO.setBusinessType("intentionInvestApprove");
        auditInputParamVO.setAuditSubject("\u6295\u653e\u610f\u5411\u5ba1\u6279\u5355\u636e:" + intentionInvestHead.getBusNumber());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)intentionInvestHead)));
        String s = JSONObject.toJSONString((Object)((Object)intentionInvestHead));
        this.workflowAuditRpcService.submit(auditInputParamVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(IntentionInvestHead intentionInvestHead, List<IntentionServiceFee> intentionServiceFeeList, List<IntentionServiceComm> intentionServiceCommList, BusStatusEmun step) {
        this.handleBefore(intentionInvestHead, step);
        int count = ((IntentionInvestHeadMapper)this.baseMapper).updateById((Object)intentionInvestHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.intentionServiceFeeService.deleteByMainId(intentionInvestHead.getId());
        this.intentionServiceCommService.deleteByMainId(intentionInvestHead.getId());
        this.insertData(intentionInvestHead, intentionServiceFeeList, intentionServiceCommList);
    }

    private void insertData(IntentionInvestHead intentionInvestHead, List<IntentionServiceFee> intentionServiceFeeList, List<IntentionServiceComm> intentionServiceCommList) {
        if (!CollectionUtils.isEmpty(intentionServiceFeeList)) {
            for (IntentionServiceFee intentionServiceFee : intentionServiceFeeList) {
                intentionServiceFee.setHeadId(intentionInvestHead.getId());
                SysUtil.setSysParam((BaseEntity)intentionServiceFee, (BaseEntity)intentionInvestHead);
            }
            this.intentionServiceFeeService.saveBatch(intentionServiceFeeList, 2000);
        }
        if (!CollectionUtils.isEmpty(intentionServiceCommList)) {
            for (IntentionServiceComm intentionServiceComm : intentionServiceCommList) {
                intentionServiceComm.setHeadId(intentionInvestHead.getId());
                SysUtil.setSysParam((BaseEntity)intentionServiceComm, (BaseEntity)intentionInvestHead);
            }
            this.intentionServiceCommService.saveBatch(intentionServiceCommList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.intentionServiceFeeService.deleteByMainId(id);
        this.intentionServiceCommService.deleteByMainId(id);
        ((IntentionInvestHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.intentionServiceFeeService.deleteByMainId(serializable.toString());
            this.intentionServiceCommService.deleteByMainId(serializable.toString());
            ((IntentionInvestHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

