/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.purchasercooperation.common.utils.BeanEntityUtils;
import com.els.modules.purchasercooperation.entity.PurchaserTalentWorksItem;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentWorksItemMapper;
import com.els.modules.purchasercooperation.service.PurchaserTalentWorksItemService;
import com.els.modules.suppliercooperation.entity.SupplierTalentWorksItem;
import com.els.modules.suppliercooperation.service.SupplierTalentWorksItemService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaserTalentWorksItemServiceImpl
extends BaseServiceImpl<PurchaserTalentWorksItemMapper, PurchaserTalentWorksItem>
implements PurchaserTalentWorksItemService {
    @Autowired
    SupplierTalentWorksItemService worksItemService;

    @Override
    public int insertBatch(List<PurchaserTalentWorksItem> purchasertalentWorksItemList) {
        purchasertalentWorksItemList.forEach(a -> {
            if (a.getHeadId() == null) {
                throw new ELSBootException("\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        int i = ((PurchaserTalentWorksItemMapper)this.baseMapper).insertBatchSomeColumn(purchasertalentWorksItemList);
        return i;
    }

    @Override
    public void deleteById(List<PurchaserTalentWorksItem> worksItemList) {
        List<PurchaserTalentWorksItem> purchaserTalentWorksItems = ((PurchaserTalentWorksItemMapper)this.baseMapper).selectByIds(worksItemList, TenantContext.getTenant());
        purchaserTalentWorksItems.forEach(a -> Assert.isTrue((boolean)"0".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u5220\u9664\u65b0\u5efa\u72b6\u6001\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u884c\u72b6\u6001\u662f\u5426\u4e3a\u65b0\u5efa")));
        ((PurchaserTalentWorksItemMapper)this.baseMapper).deleteBatchIds(worksItemList);
    }

    @Override
    public void updateWorkStatusById(String status, List<PurchaserTalentWorksItem> purchasertalentWorksItemList) {
        Map<String, Object> stringObjectMap = this.checkStatus(status, purchasertalentWorksItemList);
        List purchaser = (List)stringObjectMap.get("purchaser");
        List worksItems = (List)stringObjectMap.get("supplier");
        PurchaserTalentWorksItem purchaserTalentWorksItem = new PurchaserTalentWorksItem();
        purchaserTalentWorksItem.setItemStatus(status);
        purchaserTalentWorksItem.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentWorksItem.setUpdateTime(new Date());
        ((PurchaserTalentWorksItemMapper)this.baseMapper).updateStatus(purchaserTalentWorksItem, purchasertalentWorksItemList);
        if ("1".equals(status) && CollectionUtils.isNotEmpty((Collection)purchaser)) {
            ((PurchaserTalentWorksItemMapper)this.baseMapper).insertBatchSomeColumn(purchaser);
            ArrayList<SupplierTalentWorksItem> insetWorksItems = new ArrayList<SupplierTalentWorksItem>();
            purchaser.forEach(a -> {
                SupplierTalentWorksItem worksItem = new SupplierTalentWorksItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)worksItem));
                worksItem.setToElsAccount(a.getElsAccount());
                worksItem.setElsAccount(a.getToElsAccount());
                insetWorksItems.add(worksItem);
            });
            this.worksItemService.insertBatch(false, insetWorksItems);
        }
        this.worksItemService.worksItemRelease(false, status, worksItems);
    }

    public Map<String, Object> checkStatus(String status, List<PurchaserTalentWorksItem> purchasertalentWorksItemList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList worksItems = new ArrayList();
        ArrayList worksItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty(purchasertalentWorksItemList)) {
            purchasertalentWorksItemList.forEach(a -> {
                if ("1".equals(status)) {
                    if (StringUtils.isEmpty((CharSequence)a.getId())) {
                        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)a.getWorks()), (String)I18nUtil.translate((String)"", (String)"\u4f5c\u54c1\u4e0d\u80fd\u4e3a\u7a7a!"));
                        PurchaserTalentWorksItem purchaserTalentWorksItem = new PurchaserTalentWorksItem();
                        BeanUtils.copyProperties((Object)a, (Object)((Object)purchaserTalentWorksItem));
                        BeanEntityUtils.initSysPram(purchaserTalentWorksItem);
                        purchaserTalentWorksItem.setItemStatus("1");
                        worksItemList.add(purchaserTalentWorksItem);
                    } else {
                        Assert.isTrue((boolean)"0".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u65b0\u5efa\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                    }
                }
                if ("2".equals(status)) {
                    Assert.isTrue((boolean)"1".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u5f85\u786e\u5b9a\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                }
                if ("3".equals(status)) {
                    Assert.isTrue((boolean)"1".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u5f85\u786e\u5b9a\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                }
                if ("4".equals(status)) {
                    Assert.isTrue((!"0".equals(a.getItemStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u72b6\u6001\u7684\u6570\u636e\u4e0d\u652f\u6301\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                }
                SupplierTalentWorksItem worksItem = new SupplierTalentWorksItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)worksItem));
                if (StringUtils.isNotEmpty((CharSequence)a.getId())) {
                    worksItems.add(worksItem);
                }
            });
        }
        map.put("purchaser", worksItemList);
        map.put("supplier", worksItems);
        return map;
    }

    public static void main(String[] args) {
        String str = "123";
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)str), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u65b0\u5efa\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
    }
}

