/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.entity.GoodsLabelGroup;
import com.els.modules.alliance.entity.GoodsLabelitem;
import com.els.modules.alliance.service.GoodsLabelGroupService;
import com.els.modules.alliance.service.GoodsLabelitemService;
import com.els.modules.alliance.vo.GoodsLabelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u6807\u7b7e\u7ec4"})
@RestController
@RequestMapping(value={"/goodsLabelGroup"})
public class GoodsLabelGroupController
extends BaseController<GoodsLabelGroup, GoodsLabelGroupService> {
    @Autowired
    @Lazy
    private GoodsLabelGroupService goodsLabelGroupService;
    @Autowired
    @Lazy
    private GoodsLabelitemService goodsLabelitemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(GoodsLabelitem goodsLabelitem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsLabelitem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.goodsLabelitemService.page((IPage)page, (Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List ids = pageList.getRecords().stream().map(x -> x.getGroupId()).distinct().collect(Collectors.toList());
            List groups = ((GoodsLabelGroupService)this.service).listByIds(ids);
            Map<String, String> groupMap = groups.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getLabel()));
            pageList.getRecords().forEach(item -> item.setGroupId((String)groupMap.get(item.getGroupId())));
        }
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/noToken/getQueryConfig"})
    public Result<?> getQueryConfig(@RequestParam(value="elsAccount") String elsAccount) {
        return Result.ok((Object)((GoodsLabelGroupService)this.service).getQueryConfig(elsAccount));
    }

    @AutoLog(value="\u5546\u54c1\u6807\u7b7e\u7ec4-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody GoodsLabelVo goodsLabelVo) {
        this.goodsLabelGroupService.saveMain(goodsLabelVo);
        return Result.ok((Object)goodsLabelVo);
    }

    @AutoLog(value="\u5546\u54c1\u6807\u7b7e\u7ec4-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody GoodsLabelGroup goodsLabelGroup) {
        this.goodsLabelGroupService.edit(goodsLabelGroup);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5546\u54c1\u6807\u7b7e\u7ec4-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.goodsLabelGroupService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5546\u54c1\u6807\u7b7e\u7ec4-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.goodsLabelGroupService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        GoodsLabelGroup goodsLabelGroup = (GoodsLabelGroup)((Object)this.goodsLabelGroupService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)goodsLabelGroup));
    }

    @GetMapping(value={"/getByElsAccount"})
    public Result<?> getByElsAccount() {
        GoodsLabelVo goodsLabelVo = this.goodsLabelGroupService.getByElsAccount();
        return Result.ok((Object)goodsLabelVo);
    }
}

