/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.entity.GoodsLabelGroup;
import com.els.modules.alliance.entity.GoodsLabelitem;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.mapper.GoodsLabelGroupMapper;
import com.els.modules.alliance.service.GoodsLabelGroupService;
import com.els.modules.alliance.service.GoodsLabelitemService;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.vo.GoodsLabelVo;
import com.els.modules.alliance.vo.GoodsQueryLabelVo;
import com.els.modules.alliance.vo.GoodsQueryVo;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.compress.utils.Lists;
import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GoodsLabelGroupServiceImpl
extends BaseServiceImpl<GoodsLabelGroupMapper, GoodsLabelGroup>
implements GoodsLabelGroupService {
    @Autowired
    @Lazy
    private GoodsLabelitemService goodsLabelitemService;
    @Autowired
    @Lazy
    private GoodsSquareService goodsSquareService;
    @Autowired
    @Lazy
    private DictItemService dictItemService;
    @Autowired
    @Lazy
    private DictService dictService;

    @Override
    public void add(GoodsLabelGroup goodsLabelGroup) {
        ((GoodsLabelGroupMapper)this.baseMapper).insert((Object)goodsLabelGroup);
    }

    @Override
    public void edit(GoodsLabelGroup goodsLabelGroup) {
        int count = ((GoodsLabelGroupMapper)this.baseMapper).updateById((Object)goodsLabelGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((GoodsLabelGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((GoodsLabelGroupMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveMain(GoodsLabelVo goodsLabelVo) {
        String elsAccount = TenantContext.getTenant();
        List<GoodsLabelGroup> groups = goodsLabelVo.getGroups();
        List<GoodsLabelitem> items = goodsLabelVo.getItems();
        Map<String, List<GoodsLabelitem>> itemsMap = items.stream().collect(Collectors.groupingBy(x -> x.getGroupCode()));
        Map<String, GoodsLabelGroup> groupMap = groups.stream().collect(Collectors.toMap(x -> x.getCode(), y -> y));
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        this.goodsLabelitemService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        groupMap.forEach((groupCode, group) -> {
            String headId = IdWorker.getIdStr();
            group.setId(headId);
            List dbItems = (List)itemsMap.get(groupCode);
            dbItems.forEach(dbItem -> dbItem.setGroupId(headId));
            this.save(group);
            this.goodsLabelitemService.saveBatch(dbItems);
        });
    }

    @Override
    public GoodsLabelVo getByElsAccount() {
        GoodsLabelVo goodsLabelVo = new GoodsLabelVo();
        goodsLabelVo.setGroups(this.list((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())));
        goodsLabelVo.setItems(this.goodsLabelitemService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())));
        return goodsLabelVo;
    }

    @Override
    public GoodsQueryVo getQueryConfig(String elsAccount) {
        GoodsQueryVo goodsQueryVo = new GoodsQueryVo();
        List goodsSquares = this.goodsSquareService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{GoodsSquare::getLabelId, GoodsSquare::getBrandName}).eq(BaseEntity::getElsAccount, (Object)elsAccount)).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.isNotNull(GoodsSquare::getLabelId);
        })).or(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.isNotNull(GoodsSquare::getLabelId);
        }));
        List<String> labelIds = goodsSquares.stream().map(x -> x.getLabelId()).collect(Collectors.toList());
        List brandIds = goodsSquares.stream().map(x -> x.getBrandName()).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(brandIds)) {
            Dict dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDictCode, (Object)"brand")).eq(Dict::getElsAccount, (Object)elsAccount), false);
            if (ObjectUtil.isEmpty((Object)dict)) {
                dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDictCode, (Object)"brand")).eq(Dict::getElsAccount, (Object)"100000"), false);
            }
            if (ObjectUtil.isNotEmpty((Object)dict)) {
                List dictItems = this.dictItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictItem::getDictId, (Object)dict.getId())).in(DictItem::getItemValue, brandIds)).orderByAsc(DictItem::getSortOrder));
                goodsQueryVo.setBrand(dictItems.stream().map(m -> {
                    Pair pair = new Pair((Object)m.getItemValue(), (Object)m.getItemText());
                    return pair;
                }).collect(Collectors.toList()));
            }
        }
        if (CollUtil.isNotEmpty(labelIds)) {
            HashSet li = Sets.newHashSet();
            labelIds.forEach(id -> {
                String[] i;
                for (String s : i = id.split(",")) {
                    li.add(s);
                }
            });
            List groupItems = this.goodsLabelitemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, (Collection)li));
            ArrayList label = Lists.newArrayList();
            List groupIds = groupItems.stream().map(x -> x.getGroupId()).distinct().collect(Collectors.toList());
            List groups = this.listByIds(groupIds);
            groups = groups.stream().sorted(Comparator.comparing(GoodsLabelGroup::getSortNum)).collect(Collectors.toList());
            Map<String, List<GoodsLabelitem>> itemMap = groupItems.stream().collect(Collectors.groupingBy(x -> x.getGroupId()));
            for (GoodsLabelGroup group : groups) {
                GoodsQueryLabelVo goodsQueryLabelVo = new GoodsQueryLabelVo();
                goodsQueryLabelVo.setKey(group.getId());
                goodsQueryLabelVo.setValue(group.getLabel());
                if (CollUtil.isNotEmpty((Collection)itemMap.get(group.getId()))) {
                    goodsQueryLabelVo.setItems(itemMap.get(group.getId()).stream().map(x -> new Pair((Object)x.getId(), (Object)x.getLabel())).collect(Collectors.toList()));
                }
                label.add(goodsQueryLabelVo);
            }
            goodsQueryVo.setLabel(label);
        }
        return goodsQueryVo;
    }
}

