/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.alliance.dto.H5DTO;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTop;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.enumerate.MyGoodsSpreaderItemStatusEnum;
import com.els.modules.alliance.mapper.GoodsSquareMapper;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsSpreaderItemService;
import com.els.modules.alliance.service.MyGoodsTopService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsSquareServiceImpl
extends BaseServiceImpl<GoodsSquareMapper, GoodsSquare>
implements GoodsSquareService {
    @Autowired
    private MyGoodsTopService myGoodsTopService;
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private MyGoodsSpreaderItemService myGoodsSpreaderItemService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public IPage<GoodsSquare> queryPage(GoodsSquare goodsSquare, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.remove("column");
        parameterMap.remove("order");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsSquare), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByDesc((Object)"flag");
        queryWrapper.orderByAsc((Object)"ISNULL(sort_num)");
        queryWrapper.orderByAsc((Object)"sort_num");
        queryWrapper.orderByDesc((Object)"update_time");
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((GoodsSquareMapper)this.baseMapper).queryPage((Page<GoodsSquare>)page, (QueryWrapper<GoodsSquare>)queryWrapper, loginUser.getElsAccount(), loginUser.getSubAccount());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addSpreader(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        GoodsSquare goodsSquare = this.addSpreaderCheck(id, loginUser);
        MyGoodsSpreaderItem spreaderItem = new MyGoodsSpreaderItem();
        spreaderItem.setElsAccount(goodsSquare.getElsAccount());
        spreaderItem.setSubAccount(goodsSquare.getSubAccount());
        spreaderItem.setToElsAccount(loginUser.getElsAccount());
        spreaderItem.setToSubAccount(loginUser.getSubAccount());
        spreaderItem.setHeadId(goodsSquare.getRelationId());
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        spreaderItem.setStartTime(goodsSquare.getStartTime());
        spreaderItem.setEndTime(goodsSquare.getEndTime());
        spreaderItem.setMerchantName(goodsSquare.getMerchantName());
        spreaderItem.setSpreaderElsAccount(loginUser.getElsAccount());
        spreaderItem.setCompanyName(loginUser.getEnterpriseName());
        spreaderItem.setSpreaderSubAccount(loginUser.getSubAccount());
        spreaderItem.setSpreaderName(loginUser.getRealname());
        this.myGoodsSpreaderItemService.save((Object)spreaderItem);
        MyPromotionalHead promotional = new MyPromotionalHead();
        BeanUtils.copyProperties((Object)((Object)goodsSquare), (Object)((Object)promotional));
        promotional.setElsAccount(loginUser.getElsAccount());
        promotional.setSubAccount(loginUser.getSubAccount());
        promotional.setToElsAccount(goodsSquare.getElsAccount());
        promotional.setToSubAccount(goodsSquare.getSubAccount());
        promotional.setRelationId(goodsSquare.getRelationId());
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)promotional.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            promotional.setTemplateNumber(templateHead.getTemplateNumber());
            promotional.setTemplateName(templateHead.getTemplateName());
            promotional.setTemplateVersion(templateHead.getTemplateVersion());
            promotional.setTemplateAccount(templateHead.getElsAccount());
        }
        promotional.setId("");
        promotional.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
        this.myPromotionalHeadService.save((Object)promotional);
    }

    @Override
    public void topOrCancel(String id, Boolean flag) {
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsSquare == null) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (flag.booleanValue()) {
            MyGoodsTop top = new MyGoodsTop();
            top.setElsAccount(loginUser.getElsAccount());
            top.setSubAccount(loginUser.getSubAccount());
            top.setHeadId(goodsSquare.getId());
            top.setPlatform(goodsSquare.getPlatform());
            this.myGoodsTopService.save((Object)top);
        } else {
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            this.myGoodsTopService.deleteTop(id, elsAccount, subAccount, goodsSquare.getPlatform());
        }
    }

    @Override
    public void delMain(String id) {
        ((GoodsSquareMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public void h5AddSpreader(H5DTO.GoodsSquareDto h5DTO) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)h5DTO), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)h5DTO.getOpenId()), (String)"openId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)h5DTO.getElsAccount()), (String)"elsAccount\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)h5DTO.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> elsAccounts = Arrays.asList(h5DTO.getElsAccount().split(","));
        String openId = h5DTO.getOpenId();
        String id = h5DTO.getId();
        String nickName = h5DTO.getNickName();
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)goodsSquare)), (String)"\u8be5\u5546\u54c1\u5df2\u4e0b\u67b6", (Object[])new Object[0]);
        String elsAccount = goodsSquare.getElsAccount();
        Assert.isTrue((boolean)elsAccounts.contains(elsAccount), (String)"\u5546\u54c1\u4fe1\u606f\u5df2\u5931\u6548", (Object[])new Object[0]);
        goodsSquare.setUpdateTime(new Date());
        this.updateById((Object)goodsSquare);
        MyGoodsSpreaderItem spreaderItem = this.myGoodsSpreaderItemService.getH5MyGoodsSpreaderItem(goodsSquare.getRelationId(), elsAccount, openId);
        Assert.isTrue((boolean)ObjectUtil.isEmpty((Object)((Object)spreaderItem)), (String)"\u5df2\u6709\u8be5\u5546\u54c1\u7684\u9009\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        spreaderItem = new MyGoodsSpreaderItem();
        spreaderItem.setElsAccount(elsAccount);
        spreaderItem.setOpenId(openId);
        spreaderItem.setAddType("H5");
        spreaderItem.setH5NickName(nickName);
        spreaderItem.setHeadId(goodsSquare.getRelationId());
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        spreaderItem.setStartTime(goodsSquare.getStartTime());
        spreaderItem.setEndTime(goodsSquare.getEndTime());
        spreaderItem.setCreateTime(new Date());
        spreaderItem.setMerchantName(goodsSquare.getMerchantName());
        this.myGoodsSpreaderItemService.save((Object)spreaderItem);
        MyPromotionalHead promotional = new MyPromotionalHead();
        BeanUtils.copyProperties((Object)((Object)goodsSquare), (Object)((Object)promotional));
        promotional.setElsAccount(elsAccount);
        promotional.setSubAccount(null);
        promotional.setToElsAccount(goodsSquare.getElsAccount());
        promotional.setToSubAccount(goodsSquare.getSubAccount());
        promotional.setRelationId(goodsSquare.getRelationId());
        promotional.setCreateTime(new Date());
        promotional.setOpenId(openId);
        promotional.setH5NickName(nickName);
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)promotional.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            promotional.setTemplateNumber(templateHead.getTemplateNumber());
            promotional.setTemplateName(templateHead.getTemplateName());
            promotional.setTemplateVersion(templateHead.getTemplateVersion());
            promotional.setTemplateAccount(templateHead.getElsAccount());
        }
        promotional.setId("");
        this.myPromotionalHeadService.save((Object)promotional);
    }

    @Override
    public IPage<GoodsSquare> queryh5Page(GoodsSquare goodsSquare, String elsAccount, String openId, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        String[] column = (String[])parameterMap.get("column");
        String[] order = (String[])parameterMap.get("order");
        String[] labelIdArr = (String[])parameterMap.get("labelId");
        String[] brandNameArr = (String[])parameterMap.get("brandName");
        String label = goodsSquare.getLabelId();
        String brandName = goodsSquare.getBrandName();
        if (ObjectUtil.isNotEmpty((Object)labelIdArr)) {
            goodsSquare.setLabelId(null);
            parameterMap.remove("labelId");
        }
        if (ObjectUtil.isNotEmpty((Object)brandNameArr)) {
            goodsSquare.setBrandName(null);
            parameterMap.remove("brandName");
        }
        if (ObjectUtil.isNotEmpty((Object)column) && StrUtil.isNotBlank((CharSequence)openId)) {
            parameterMap.remove("column");
            parameterMap.remove("order");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsSquare), (Map)parameterMap);
        queryWrapper.in((Object)"els_account", (Object[])elsAccount.split(","));
        if (StrUtil.isNotBlank((CharSequence)goodsSquare.getPriceStart())) {
            queryWrapper.ge((Object)"goods_price", (Object)new BigDecimal(goodsSquare.getPriceStart()));
        }
        if (StrUtil.isNotBlank((CharSequence)brandName)) {
            queryWrapper.in((Object)"brand_name", (Object[])brandName.split(","));
        }
        if (StrUtil.isNotBlank((CharSequence)label)) {
            String[] labelIds = label.split(",");
            String sql = "(";
            int i = 0;
            for (String labelId : labelIds) {
                sql = i == 0 ? sql + "(FIND_IN_SET ('" + labelId + "',label_id))" : sql + "or (FIND_IN_SET ('" + labelId + "',label_id))";
                ++i;
            }
            sql = sql + ")";
            queryWrapper.apply(sql, new Object[0]);
        }
        if (StrUtil.isNotBlank((CharSequence)goodsSquare.getPriceEnd())) {
            queryWrapper.le((Object)"goods_price", (Object)new BigDecimal(goodsSquare.getPriceEnd()));
        }
        if (StrUtil.isNotBlank((CharSequence)openId)) {
            String sql = " order by flag desc,ISNULL( sort_num ) ASC,sort_num ASC";
            if (ObjectUtil.isNotEmpty((Object)column) && StrUtil.isNotBlank((CharSequence)column[0]) && StrUtil.isNotBlank((CharSequence)order[0])) {
                sql = sql + "," + column[0] + " " + order[0];
            }
            queryWrapper.last(sql);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        return ((GoodsSquareMapper)this.baseMapper).queryh5Page((Page<GoodsSquare>)page, (QueryWrapper<GoodsSquare>)queryWrapper, openId);
    }

    @Override
    public void h5TopOrCancel(H5DTO.TopDto topDto) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)topDto), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topDto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topDto.getFlag()), (String)"flag\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topDto.getElsAccount()), (String)"elsAccount\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = topDto.getId();
        Boolean flag = topDto.getFlag();
        String openId = topDto.getOpenId();
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsSquare == null) {
            return;
        }
        List<String> elsAccounts = Arrays.asList(topDto.getElsAccount().split(","));
        Assert.isTrue((boolean)elsAccounts.contains(goodsSquare.getElsAccount()), (String)"\u5546\u54c1\u4fe1\u606f\u5df2\u5931\u6548", (Object[])new Object[0]);
        if (flag.booleanValue()) {
            MyGoodsTop db = (MyGoodsTop)((Object)this.myGoodsTopService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsTop::getOpenId, (Object)openId)).eq(MyGoodsTop::getHeadId, (Object)goodsSquare.getId())).eq(MyGoodsTop::getPlatform, (Object)goodsSquare.getPlatform())));
            if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
                return;
            }
            MyGoodsTop top = new MyGoodsTop();
            top.setOpenId(openId);
            top.setHeadId(goodsSquare.getId());
            top.setPlatform(goodsSquare.getPlatform());
            this.myGoodsTopService.save((Object)top);
        } else {
            this.myGoodsTopService.removeByOpenId(id, openId, goodsSquare.getPlatform());
        }
    }

    private GoodsSquare addSpreaderCheck(String id, LoginUser loginUser) {
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsSquare == null) {
            throw new ELSBootException("\u5934\u6570\u636eID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        MyGoodsSpreaderItem spreaderItem = this.myGoodsSpreaderItemService.getMyGoodsSpreaderItem(goodsSquare.getRelationId(), loginUser.getElsAccount(), loginUser.getSubAccount());
        if (spreaderItem != null) {
            throw new ELSBootException("\u5df2\u63a8\u5e7f\u8be5\u5546\u54c1");
        }
        goodsSquare.setUpdateTime(new Date());
        this.updateById((Object)goodsSquare);
        return goodsSquare;
    }
}

