/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.adapter.msg;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.adapter.msg.IKsMessageAdapter;
import com.els.modules.companystore.config.KuaiShouProperties;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.KsOrderBaseInfo;
import com.els.modules.companystore.entity.KsOrderItemInfo;
import com.els.modules.companystore.entity.KsOrderRefund;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreOrderHeadService;
import com.els.modules.companystore.service.KsOrderBaseInfoService;
import com.els.modules.companystore.service.KsOrderItemInfoService;
import com.els.modules.companystore.service.KsOrderRefundService;
import com.kuaishou.merchant.open.api.KsMerchantRequest;
import com.kuaishou.merchant.open.api.client.AccessTokenKsMerchantClient;
import com.kuaishou.merchant.open.api.domain.order.OrderDetail;
import com.kuaishou.merchant.open.api.domain.order.OrderDetailBaseInfo;
import com.kuaishou.merchant.open.api.domain.order.OrderItemInfo;
import com.kuaishou.merchant.open.api.request.order.OpenOrderDetailRequest;
import com.kuaishou.merchant.open.api.response.order.OpenOrderDetailResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"kwaishop_order_addOrder"})
public class AddOrderAdapter
implements IKsMessageAdapter {
    private static final Logger log = LoggerFactory.getLogger(AddOrderAdapter.class);
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private KsOrderBaseInfoService ksOrderBaseInfoService;
    @Autowired
    private KuaiShouProperties kuaiShouProperties;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KsOrderItemInfoService orderItemInfoService;
    @Autowired
    private KsOrderRefundService orderRefundService;
    @Autowired
    private CompanyStoreOrderHeadService companyStoreOrderHeadService;

    @Override
    public void accept(String info, String shopId) {
        log.info("\u5904\u7406\u65b0\u589e\u8ba2\u5355\u4e1a\u52a1:{},shopId:{}", (Object)info, (Object)shopId);
        JSONObject jsonObject = JSON.parseObject((String)info);
        Long oid = jsonObject.getLong("oid");
        List companyStoreHeads = this.companyStoreHeadService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getShopId, (Object)shopId)).ne(BaseEntity::getElsAccount, (Object)"100000")).eq(CompanyStoreHead::getPlatform, (Object)"2")).eq(BaseEntity::getDeleted, (Object)"0"));
        log.info("companyStoreHeads:{}", (Object)JSON.toJSONString((Object)companyStoreHeads));
        if (CollUtil.isNotEmpty((Collection)companyStoreHeads)) {
            companyStoreHeads.forEach(companyStoreHead -> {
                KsOrderBaseInfo items = (KsOrderBaseInfo)((Object)((Object)this.ksOrderBaseInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).eq(KsOrderBaseInfo::getDeleted, (Object)"0")).eq(KsOrderBaseInfo::getOid, (Object)oid), false)));
                log.info("KsOrderBaseInfo:{}", (Object)(items == null ? 1 : 0));
                if (ObjectUtil.isEmpty((Object)((Object)items))) {
                    String ksShopAccessToken = "ks_shop_access_token:" + shopId;
                    log.info("ksShopAccessToken\uff1a{}", (Object)ksShopAccessToken);
                    String assertToken = (String)this.redisUtil.get(ksShopAccessToken);
                    log.info("\u65b0\u589e\u8ba2\u5355token\uff1a{}", (Object)assertToken);
                    if (StrUtil.isNotBlank((CharSequence)assertToken)) {
                        AccessTokenKsMerchantClient client = new AccessTokenKsMerchantClient(this.kuaiShouProperties.getAppKey(), this.kuaiShouProperties.getSignSecret());
                        OpenOrderDetailRequest request = new OpenOrderDetailRequest();
                        request.setAccessToken(assertToken);
                        request.setApiMethodVersion(1L);
                        request.setOid(oid);
                        try {
                            OpenOrderDetailResponse response = (OpenOrderDetailResponse)client.execute((KsMerchantRequest)request);
                            OrderDetail orderDetail = response.getData();
                            if (ObjectUtil.isNotEmpty((Object)orderDetail) && ObjectUtil.isNotEmpty((Object)orderDetail.getOrderBaseInfo())) {
                                OrderDetailBaseInfo orderDetailBaseInfo = orderDetail.getOrderBaseInfo();
                                KsOrderBaseInfo ksOrderBaseInfo = new KsOrderBaseInfo();
                                BeanUtil.copyProperties((Object)orderDetailBaseInfo, (Object)((Object)ksOrderBaseInfo), (String[])new String[0]);
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getCreateTime()) && !orderDetailBaseInfo.getCreateTime().equals(0L)) {
                                    ksOrderBaseInfo.setOrderCreateTime(new Date(orderDetailBaseInfo.getCreateTime()));
                                } else {
                                    ksOrderBaseInfo.setOrderCreateTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getUpdateTime()) && !orderDetailBaseInfo.getUpdateTime().equals(0L)) {
                                    ksOrderBaseInfo.setOrderUpdateTime(new Date(orderDetailBaseInfo.getUpdateTime()));
                                } else {
                                    ksOrderBaseInfo.setOrderUpdateTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getPayTime()) && !orderDetailBaseInfo.getPayTime().equals(0L)) {
                                    ksOrderBaseInfo.setPayTime(new Date(orderDetailBaseInfo.getPayTime()));
                                } else {
                                    ksOrderBaseInfo.setPayTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getSendTime()) && !orderDetailBaseInfo.getSendTime().equals(0L)) {
                                    ksOrderBaseInfo.setSendTime(new Date(orderDetailBaseInfo.getSendTime()));
                                } else {
                                    ksOrderBaseInfo.setSendTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getRefundTime()) && !orderDetailBaseInfo.getRefundTime().equals(0L)) {
                                    ksOrderBaseInfo.setRefundTime(new Date(orderDetailBaseInfo.getRefundTime()));
                                } else {
                                    ksOrderBaseInfo.setRefundTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetailBaseInfo.getRecvTime()) && !orderDetailBaseInfo.getRecvTime().equals(0L)) {
                                    ksOrderBaseInfo.setRecvTime(new Date(orderDetailBaseInfo.getRecvTime()));
                                } else {
                                    ksOrderBaseInfo.setRecvTime(null);
                                }
                                if (ObjectUtil.isNotEmpty((Object)orderDetail.getOrderCpsInfo())) {
                                    if (ObjectUtil.isNotEmpty((Object)orderDetail.getOrderCpsInfo().getDistributorId())) {
                                        ksOrderBaseInfo.setDistributorId(orderDetail.getOrderCpsInfo().getDistributorId().toString());
                                    }
                                    ksOrderBaseInfo.setDistributorName(orderDetail.getOrderCpsInfo().getDistributorName());
                                }
                                ksOrderBaseInfo.setOid(oid);
                                ksOrderBaseInfo.setCompany(companyStoreHead.getCompany());
                                ksOrderBaseInfo.setCompanyName(companyStoreHead.getCompanyName());
                                ksOrderBaseInfo.setShopId(companyStoreHead.getShopId());
                                ksOrderBaseInfo.setElsAccount(companyStoreHead.getElsAccount());
                                ksOrderBaseInfo.setDeleted(CommonConstant.STATUS_NO);
                                this.ksOrderBaseInfoService.save((Object)ksOrderBaseInfo);
                                this.orderItemInfoService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsOrderItemInfo::getOid, new Object[]{oid})).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                                this.orderRefundService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KsOrderRefund::getOid, new Object[]{oid})).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                                OrderItemInfo orderItemInfo = orderDetail.getOrderItemInfo();
                                KsOrderItemInfo ksOrderItemInfo = new KsOrderItemInfo();
                                BeanUtil.copyProperties((Object)orderItemInfo, (Object)((Object)ksOrderItemInfo), (String[])new String[0]);
                                ksOrderItemInfo.setElsAccount(companyStoreHead.getElsAccount());
                                ksOrderItemInfo.setOid(ksOrderBaseInfo.getOid());
                                this.orderItemInfoService.save((Object)ksOrderItemInfo);
                                ArrayList ksOrderRefunds = Lists.newArrayList();
                                Object[] orderRefundInfos = orderDetail.getOrderRefundList();
                                if (ArrayUtil.isNotEmpty((Object[])orderRefundInfos)) {
                                    for (Object orderRefundInfo : orderRefundInfos) {
                                        KsOrderRefund ksOrderRefund = new KsOrderRefund();
                                        BeanUtil.copyProperties((Object)orderRefundInfo, (Object)((Object)ksOrderRefund), (String[])new String[0]);
                                        ksOrderRefund.setOid(ksOrderBaseInfo.getOid());
                                        ksOrderRefund.setElsAccount(companyStoreHead.getElsAccount());
                                        ksOrderRefunds.add(ksOrderRefund);
                                    }
                                    this.orderRefundService.saveBatch(ksOrderRefunds);
                                }
                                this.companyStoreOrderHeadService.pullOrderBill(assertToken, oid, companyStoreHead.getElsAccount());
                            }
                        }
                        catch (Exception e) {
                            log.error("\u65b0\u589e\u8ba2\u5355\u6d88\u606f\u5904\u7406\u5f02\u5e38", (Throwable)e);
                        }
                    }
                }
            });
        }
    }
}

