/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companystore.entity.DyProductCategory;
import com.els.modules.companystore.entity.DyShopProduct;
import com.els.modules.companystore.service.DyProductCategoryService;
import com.els.modules.companystore.service.DyShopProductPromotionService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.vo.DyShopItemsVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6296\u5e97\u5546\u54c1\u6765\u6e90\u8868"})
@RestController
@RequestMapping(value={"/dyShopProduct"})
public class DyShopProductController
extends BaseController<DyShopProduct, DyShopProductService> {
    @Autowired
    private DyShopProductService dyShopProductService;
    @Autowired
    private DyShopProductPromotionService dyShopProductPromotionService;
    @Autowired
    private DyProductCategoryService dyProductCategoryService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(DyShopItemsVO dyShopProduct, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] var;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        dyShopProduct.setElsAccount(TenantContext.getTenant());
        ArrayList categorys = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)dyShopProduct.getGoodsCategory())) {
            String[] s = dyShopProduct.getGoodsCategory().split(",");
            for (String s1 : s) {
                String[] v = s1.split("-");
                ArrayList c = Lists.newArrayList();
                for (int i = 0; i < v.length; ++i) {
                    DyProductCategory category = (DyProductCategory)((Object)this.dyProductCategoryService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyProductCategory::getCategoryName, (Object)v[i])).eq(DyProductCategory::getLevel, (Object)(i + 1))));
                    if (!ObjectUtil.isNotEmpty((Object)((Object)category))) continue;
                    c.add(category);
                }
                categorys.add(c);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)categorys)) {
            ArrayList row = Lists.newArrayList();
            for (List category : categorys) {
                StringBuffer stringBuffer = new StringBuffer();
                int i = 0;
                for (DyProductCategory category2 : category) {
                    if (i > 0) {
                        stringBuffer.append(" and ");
                    }
                    ++i;
                    switch (category2.getLevel() + "") {
                        case "1": {
                            stringBuffer.append(" first_cid =");
                            break;
                        }
                        case "2": {
                            stringBuffer.append(" second_cid =");
                            break;
                        }
                        case "3": {
                            stringBuffer.append(" third_cid =");
                            break;
                        }
                        case "4": {
                            stringBuffer.append(" fourth_cid =");
                        }
                    }
                    stringBuffer.append(category2.getCategoryId());
                }
                row.add(stringBuffer.toString());
            }
            if (CollUtil.isNotEmpty((Collection)row)) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                for (String s : row) {
                    if (i > 0) {
                        sb.append(" or ");
                    } else if (i == 0) {
                        sb.append(" and (");
                    }
                    sb.append("(");
                    sb.append(s);
                    sb.append(")");
                    if (i == row.size() - 1) {
                        sb.append(")");
                    }
                    ++i;
                }
                dyShopProduct.setGoodsCategorySql(sb.toString());
            }
        }
        boolean selectTotal = false;
        if (ObjectUtil.isNotEmpty((Object)dyShopProduct.getKsTopManNum()) && ObjectUtil.isNotEmpty((Object)(var = dyShopProduct.getKsTopManNum().split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var[0])) {
                page.setSearchCount(false);
                selectTotal = true;
                dyShopProduct.setKsTopManNumStart(var[0]);
            }
            if (var.length == 2 && ObjectUtil.isNotEmpty((Object)var[1])) {
                dyShopProduct.setKsTopManNumEnd(var[1]);
            }
        }
        IPage<DyShopItemsVO> pageList = this.dyShopProductService.queryPage((Page<DyShopProduct>)page, dyShopProduct);
        if (selectTotal) {
            pageList.setTotal(this.dyShopProductService.queryPageCount(dyShopProduct));
        }
        pageList.getRecords().forEach(r -> {
            if (ObjectUtil.isNotEmpty((Object)r.getDiscountPrice())) {
                Double d = (double)r.getDiscountPrice().longValue() / 100.0;
                r.setPriceShow(d.toString());
            }
            if (StrUtil.isNotBlank((CharSequence)r.getStatus()) && StrUtil.isNotBlank((CharSequence)r.getCheckStatus()) && StrUtil.isNotBlank((CharSequence)r.getDraftStatus())) {
                if ("0".equals(r.getStatus()) && "3".equals(r.getCheckStatus()) && "3".equals(r.getDraftStatus())) {
                    r.setStatusShow("\u5df2\u4e0a\u67b6");
                } else if ("2".equals(r.getStatus()) && "1".equals(r.getCheckStatus()) && "0".equals(r.getDraftStatus())) {
                    r.setStatusShow("\u5df2\u5220\u9664");
                } else {
                    r.setStatusShow("\u5df2\u4e0b\u67b6");
                }
            } else {
                r.setStatusShow("\u5df2\u4e0b\u67b6");
            }
        });
        return Result.ok(pageList);
    }

    @AutoLog(value="\u6296\u5e97\u5546\u54c1\u6765\u6e90\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody DyShopProduct dyShopProduct) {
        this.dyShopProductService.add(dyShopProduct);
        return Result.ok((Object)((Object)dyShopProduct));
    }

    @AutoLog(value="\u6296\u5e97\u5546\u54c1\u6765\u6e90\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody DyShopProduct dyShopProduct) {
        this.dyShopProductService.edit(dyShopProduct);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6296\u5e97\u5546\u54c1\u6765\u6e90\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.dyShopProductService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6296\u5e97\u5546\u54c1\u6765\u6e90\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.dyShopProductService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        DyShopProduct dyShopProduct = (DyShopProduct)((Object)this.dyShopProductService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)dyShopProduct));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryByProductId"})
    public Result<?> queryByProductId(@RequestParam(name="productId") String productId) {
        DyShopProduct dyShopProduct = (DyShopProduct)((Object)this.dyShopProductService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(DyShopProduct::getProductId, (Object)productId), false));
        return Result.ok((Object)((Object)dyShopProduct));
    }
}

