/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.utils.TimeTranslateUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.companystore.dto.CompanyGoodsTopmanItemQueryDTO;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsTopmanItem;
import com.els.modules.companystore.entity.CompanyGoodsTopmanRecord;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.mapper.CompanyGoodsTopmanRecordMapper;
import com.els.modules.companystore.service.CompanyGoodsTopmanItemService;
import com.els.modules.companystore.service.CompanyGoodsTopmanRecordService;
import com.els.modules.companystore.vo.CompanyTabCountVO;
import com.els.modules.companystore.vo.CompanyTopmanItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGoodsTopmanRecordServiceImpl
extends BaseServiceImpl<CompanyGoodsTopmanRecordMapper, CompanyGoodsTopmanRecord>
implements CompanyGoodsTopmanRecordService {
    @Autowired
    private CompanyGoodsTopmanRecordMapper companyGoodsTopmanRecordMapper;
    @Autowired
    private CompanyGoodsTopmanItemService companyGoodsTopmanItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<CompanyGoodsTopmanRecord> selectByMainId(String mainId) {
        return this.companyGoodsTopmanRecordMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyTopmanItemVO> queryTopmanPage(Page<CompanyStoreOrderItem> page, QueryWrapper<CompanyStoreOrderItem> queryWrapper, CompanyTopmanItemQueryDTO queryDTO) {
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        String contentType = queryDTO.getTopmanContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            if (contentType.contains(",")) {
                contentType = contentType.replace(",", "|");
            } else if (contentType.contains("\u5168\u90e8")) {
                contentType = "";
            }
            queryDTO.setTopmanContentType(contentType);
        }
        List<CompanyTopmanItemVO> itemList = this.companyGoodsTopmanRecordMapper.topmanItemList(queryWrapper, queryDTO);
        return this.replenishNew(itemList);
    }

    private List<CompanyTopmanItemVO> replenishNew(List<CompanyTopmanItemVO> records) {
        ArrayList<CompanyTopmanItemVO> list = new ArrayList<CompanyTopmanItemVO>();
        if (CollectionUtils.isNotEmpty(records)) {
            List topmanIds = records.stream().map(CompanyTopmanItemVO::getTopmanId).distinct().collect(Collectors.toList());
            Map<String, List<CompanyTopmanItemVO>> listMap = records.stream().collect(Collectors.groupingBy(CompanyTopmanItemVO::getTopmanId));
            for (String topmanId : topmanIds) {
                CompanyTopmanItemVO vo = new CompanyTopmanItemVO();
                List<CompanyTopmanItemVO> itemList = listMap.get(topmanId);
                if (CollectionUtil.isEmpty(itemList)) break;
                CompanyTopmanItemVO itemVO = itemList.get(0);
                BeanUtil.copyProperties((Object)itemVO, (Object)vo, (String[])new String[0]);
                BigDecimal salesNum = itemList.stream().map(CompanyTopmanItemVO::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setSalesNum(salesNum);
                long livesNum = itemList.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getLiveId())).count();
                vo.setLivesNum(new BigDecimal(livesNum));
                long videosNum = itemList.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getVideoId())).count();
                vo.setVideosNum(new BigDecimal(videosNum));
                if (vo.getPrice() != null) {
                    vo.setSalesAmountMin(vo.getPrice().multiply(salesNum));
                    vo.setSalesAmountMax(vo.getPrice().multiply(salesNum));
                }
                list.add(vo);
            }
        }
        return list;
    }

    @Override
    public QueryWrapper<CompanyGoodsTopmanRecord> criteriaQuery(QueryWrapper<CompanyGoodsTopmanRecord> queryWrapper, CompanyGoodsTopmanItemQueryDTO queryDTO) {
        List<CompanyGoodsTopmanItem> records;
        Boolean phoneNumber;
        String goodsWom;
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        if (timeSelect.length() < 10) {
            Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)dates[0], (Object)dates[1]);
        } else if (timeSelect.contains("\u81f3")) {
            String[] strings = timeSelect.split("\u81f3");
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)strings[0], (Object)strings[1]);
        }
        String fansNum = queryDTO.getTopmanFansNum();
        if (StringUtils.isNotBlank((CharSequence)fansNum)) {
            String[] strings;
            if (fansNum.contains("-")) {
                strings = fansNum.split("-");
                queryWrapper.lambda().gt(CompanyGoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(CompanyGoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains("<")) {
                strings = fansNum.split("<");
                queryWrapper.lambda().lt(CompanyGoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains(">")) {
                strings = fansNum.split(">");
                queryWrapper.lambda().gt(CompanyGoodsTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsWom = queryDTO.getTopmanGoodsWom()))) {
            String[] strings;
            if (goodsWom.contains("-")) {
                strings = goodsWom.split("-");
                queryWrapper.lambda().between(CompanyGoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (goodsWom.contains("<")) {
                strings = goodsWom.split("<");
                queryWrapper.lambda().lt(CompanyGoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(CompanyGoodsTopmanRecord::getGoodsWom, (Object)new BigDecimal(goodsWom));
            }
        }
        if ((phoneNumber = queryDTO.getTopmanPhoneNumber()) != null && phoneNumber.booleanValue()) {
            queryWrapper.lambda().isNotNull(CompanyGoodsTopmanRecord::getPhoneNumber);
        }
        if (CollectionUtil.isNotEmpty(records = this.companyGoodsTopmanItemService.queryList(queryDTO))) {
            List recordIds = records.stream().map(CompanyGoodsTopmanItem::getRecordId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, recordIds);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    public List<CountVO> contentTypeCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        this.timeConvert(queryDTO);
        List<CompanyTabCountVO> list = this.companyGoodsTopmanRecordMapper.tabCountList(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "talentClassification", null, Integer.valueOf(list.size())));
        if (CollectionUtil.isEmpty(list)) {
            return result;
        }
        LinkedHashSet<String> finalTypes = new LinkedHashSet<String>();
        for (CompanyTabCountVO vo : list) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getType())) continue;
            if (vo.getType().contains("-")) {
                String[] split = vo.getType().split("-");
                finalTypes.addAll(Arrays.asList(split));
                continue;
            }
            finalTypes.add(vo.getType());
        }
        if (CollectionUtil.isNotEmpty(finalTypes)) {
            for (String finalType : finalTypes) {
                long count = list.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getType()) && h.getType().contains(finalType)).count();
                result.add(new CountVO(I18nUtil.translate((String)"", (String)finalType), "talentClassification", finalType, Integer.valueOf((int)count)));
            }
        }
        return result;
    }

    @Override
    public List<CountVO> goodsWomCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        this.timeConvert(queryDTO);
        List<CompanyTabCountVO> list = this.companyGoodsTopmanRecordMapper.tabCountList(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "topmanGoodsWom", null, Integer.valueOf(list.size())));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("topmanGoodsWom", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            long total = 0L;
            if (dto.getValue().contains("-")) {
                String[] strings = dto.getValue().split("-");
                total = list.stream().filter(h -> h.getGoodsWom() != null && h.getGoodsWom().compareTo(new BigDecimal(strings[0])) >= 0 && h.getGoodsWom().compareTo(new BigDecimal(strings[1])) <= 0).count();
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "topmanGoodsWom", dto.getValue(), Integer.valueOf((int)total)));
        }
        return result;
    }

    private CompanyTopmanItemQueryDTO timeConvert(CompanyTopmanItemQueryDTO queryDTO) {
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        return queryDTO;
    }
}

