/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companystore.entity.DyOrder;
import com.els.modules.companystore.entity.DyOrderItem;
import com.els.modules.companystore.entity.DyShopProduct;
import com.els.modules.companystore.mapper.DyOrderItemMapper;
import com.els.modules.companystore.service.DyOrderItemService;
import com.els.modules.companystore.service.DyOrderService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.vo.DyOrderDetailVO;
import com.els.modules.companystore.vo.DyOrderVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DyOrderItemServiceImpl
extends BaseServiceImpl<DyOrderItemMapper, DyOrderItem>
implements DyOrderItemService {
    @Autowired
    @Lazy
    private DyShopProductService dyShopProductService;
    @Autowired
    @Lazy
    private DyOrderService dyOrderService;

    @Override
    public void add(DyOrderItem dyOrderItem) {
        ((DyOrderItemMapper)this.baseMapper).insert((Object)dyOrderItem);
    }

    @Override
    public void edit(DyOrderItem dyOrderItem) {
        int count = ((DyOrderItemMapper)this.baseMapper).updateById((Object)dyOrderItem);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((DyOrderItemMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((DyOrderItemMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public IPage<DyOrderVO> listAll(Page<DyOrderVO> page, DyOrderVO dyOrderVO) {
        return ((DyOrderItemMapper)this.baseMapper).listAll(page, dyOrderVO);
    }

    @Override
    public DyOrderDetailVO dyDetail(String orderId) {
        String elsAccount = TenantContext.getTenant();
        DyOrderItem dyOrderItem = (DyOrderItem)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyOrderItem::getOrderId, (Object)orderId)).eq(BaseEntity::getElsAccount, (Object)elsAccount), false));
        DyOrderDetailVO dyOrderDetailVO = (DyOrderDetailVO)((Object)BeanUtil.copyProperties((Object)((Object)dyOrderItem), DyOrderDetailVO.class, (String[])new String[0]));
        if (ObjectUtil.isNotEmpty((Object)dyOrderDetailVO.getOrderAmount())) {
            dyOrderDetailVO.setOrderAmountShow(String.format("%.2f", (double)dyOrderDetailVO.getOrderAmount().longValue() / 100.0));
        }
        if (ObjectUtil.isNotEmpty((Object)dyOrderDetailVO.getSettledGoodsAmount())) {
            dyOrderDetailVO.setSettledGoodsAmountShow(String.format("%.2f", (double)dyOrderDetailVO.getSettledGoodsAmount().longValue() / 100.0));
        }
        if (StrUtil.isNotBlank((CharSequence)dyOrderDetailVO.getMediaType())) {
            HashMap p = Maps.newHashMap();
            p.put("shop_list", "\u6a71\u7a97");
            p.put("video", "\u89c6\u9891");
            p.put("live", "\u76f4\u64ad");
            p.put("others", "\u5176\u4ed6");
            dyOrderDetailVO.setMediaTypeShow((String)p.get(dyOrderDetailVO.getMediaType()));
        }
        if (ObjectUtil.isNotEmpty((Object)((Object)dyOrderDetailVO)) && StrUtil.isNotBlank((CharSequence)dyOrderDetailVO.getProductId())) {
            DyShopProduct dyShopProduct = (DyShopProduct)((Object)this.dyShopProductService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyShopProduct::getProductId, (Object)dyOrderDetailVO.getProductId())).eq(BaseEntity::getElsAccount, (Object)elsAccount), false));
            if (ObjectUtil.isNotEmpty((Object)dyShopProduct.getDiscountPrice())) {
                dyShopProduct.setDiscountPriceShow(String.format("%.2f", (double)dyShopProduct.getDiscountPrice().longValue() / 100.0));
            }
            dyOrderDetailVO.setItems(dyShopProduct);
            DyOrder dyOrder = (DyOrder)((Object)this.dyOrderService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyOrder::getOrderId, (Object)dyOrderDetailVO.getParentOrderId())).eq(BaseEntity::getElsAccount, (Object)elsAccount)));
            dyOrderDetailVO.setBase(dyOrder);
        }
        return dyOrderDetailVO;
    }
}

