/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.enterpriseresource.dto.BlogTopManDTO;
import com.els.modules.enterpriseresource.entity.BlogTopManInformation;
import com.els.modules.enterpriseresource.mapper.EnterpriseBlogTopManMapper;
import com.els.modules.enterpriseresource.service.EnterpriseBlogTopManService;
import com.els.modules.enterpriseresource.utils.HttpRequestUtils;
import com.els.modules.enterpriseresource.utils.spider.properties.McnSpiderBaseProperties;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.weboption.EnterpriseTopManOptionsEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseBlogTopManServiceImpl
extends BaseServiceImpl<EnterpriseBlogTopManMapper, BlogTopManInformation>
implements EnterpriseBlogTopManService {
    @Autowired
    private EnterpriseBlogTopManMapper blogTopManMapper;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private McnSpiderBaseProperties spiderBaseProperties;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public Object getOptions(String type) {
        List<EnterpriseTopManOptionsEntity> categoryList = new ArrayList();
        switch (type) {
            case "allTopMan": {
                String urlCategory = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/category";
                JSONObject allJsonObject = HttpRequestUtils.doPost(urlCategory, "");
                JSONArray allData = allJsonObject.getJSONArray("data");
                categoryList = allData.toJavaList(Object.class);
                break;
            }
            case "myTopMan": {
                String collectCategory = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/category";
                JSONObject collectJsonObject = HttpRequestUtils.doPost(collectCategory, "");
                JSONArray collectData = collectJsonObject.getJSONArray("data");
                categoryList = collectData.toJavaList(Object.class);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        EnterpriseTopManOptionsEntity otherCategory = this.getOtherCategory();
        categoryList.add(otherCategory);
        return categoryList;
    }

    @Override
    public IPage<BlogTopManInformation> listBlogAll(SimplePostRequestParam<BlogTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    @Override
    public IPage<BlogTopManInformation> listBlogPublic(SimplePostRequestParam<BlogTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    @Override
    public IPage<BlogTopManInformation> listBlogMyTopMan(SimplePostRequestParam<BlogTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    private IPage<BlogTopManInformation> selectList(SimplePostRequestParam<BlogTopManDTO> topManDto) {
        BlogTopManDTO filterInfo = (BlogTopManDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        IPage<BlogTopManInformation> pageList = new IPage<BlogTopManInformation>();
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        BlogTopManInformation blogTopManInformation = new BlogTopManInformation();
        this.getQueryWrapper(topManDto, (QueryWrapper<BlogTopManInformation>)queryWrapper, blogTopManInformation);
        List companyList = this.permissionDataRpcService.getCompany("companyResource");
        switch (taskType) {
            case "allTopMan": {
                pageList = this.blogTopManMapper.listBlogAll((Page<BlogTopManInformation>)page, (QueryWrapper<BlogTopManInformation>)queryWrapper, SysUtil.getLoginUser(), blogTopManInformation, companyList, this.subaccountOrgRpcService.getSubaccountOrgCode());
                break;
            }
            case "publicTopMan": {
                queryWrapper.eq((Object)"decideStatus", (Object)"1");
                queryWrapper.isNull((Object)"leader");
                pageList = this.blogTopManMapper.listBlogAll((Page<BlogTopManInformation>)page, (QueryWrapper<BlogTopManInformation>)queryWrapper, SysUtil.getLoginUser(), blogTopManInformation, companyList, this.subaccountOrgRpcService.getSubaccountOrgCode());
                break;
            }
            case "myTopMan": {
                queryWrapper.eq((Object)"leader", (Object)SysUtil.getLoginUser().getSubAccount());
                pageList = this.blogTopManMapper.listBlogAll((Page<BlogTopManInformation>)page, (QueryWrapper<BlogTopManInformation>)queryWrapper, SysUtil.getLoginUser(), blogTopManInformation, companyList, this.subaccountOrgRpcService.getSubaccountOrgCode());
                break;
            }
            default: {
                throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u7c7b\u578b");
            }
        }
        return pageList;
    }

    private void getQueryWrapper(SimplePostRequestParam<BlogTopManDTO> topManDto, QueryWrapper<BlogTopManInformation> queryWrapper, BlogTopManInformation blogTopManInformation) {
        BlogTopManDTO.ScreenItem screenItem;
        BlogTopManDTO filterInfo = (BlogTopManDTO)topManDto.getFilterInfo();
        String keyWord = topManDto.getKeyWord();
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            queryWrapper.lambda().eq(BlogTopManInformation::getTopmanName, (Object)keyWord.trim());
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BlogTopManDTO.ScreenItemField> otherFilter;
            List<BlogTopManDTO.ScreenItemField> putInfo;
            List<BlogTopManDTO.ScreenItemField> talentInfo;
            List<BlogTopManDTO.ScreenItemField> talentType = screenItem.getTalentType();
            if (CollectionUtils.isNotEmpty(talentType)) {
                String value = talentType.get(0).getValue().toString();
                blogTopManInformation.setTopmanType(talentType.get(0).getTitle().trim());
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u7c89\u4e1d\u603b\u6570": {
                            EnterpriseBlogTopManServiceImpl.getFanParam(a.getValue().toString(), queryWrapper);
                            break;
                        }
                        case "\u5fae\u535a\u8ba4\u8bc1": {
                            String blogAuthentication = a.getValue().toString();
                            queryWrapper.lambda().eq(BlogTopManInformation::getBlogAuthentication, (Object)blogAuthentication);
                            break;
                        }
                        case "\u5fae\u535a\u5f71\u54cd\u529b": {
                            String blogInfluence = a.getValue().toString();
                            queryWrapper.lambda().eq(BlogTopManInformation::getBlogInfluence, (Object)blogInfluence);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u539f\u53d1\u62a5\u4ef7": {
                            EnterpriseBlogTopManServiceImpl.getPutParam(a.getValue().toString(), title, queryWrapper);
                            break;
                        }
                        case "\u8f6c\u53d1\u62a5\u4ef7": {
                            EnterpriseBlogTopManServiceImpl.getPutParam(a.getValue().toString(), title, queryWrapper);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherFilter = screenItem.getOtherFilter())) {
                otherFilter.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u786e\u8ba4\u72b6\u6001": {
                            queryWrapper.lambda().eq(BlogTopManInformation::getDecideStatus, (Object)a.getValue().toString());
                            break;
                        }
                        case "\u8d1f\u8d23\u4eba": {
                            queryWrapper.lambda().eq(BlogTopManInformation::getLeader, (Object)a.getValue().toString());
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
        }
        EnterpriseBlogTopManServiceImpl.sort(topManDto, queryWrapper);
    }

    public static void getFanParam(Object str, QueryWrapper<BlogTopManInformation> queryWrapper) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.lambda().le(BlogTopManInformation::getFanTotal, (Object)split[1]);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.lambda().ge(BlogTopManInformation::getFanTotal, (Object)split[0]);
        } else {
            String[] split = value.split("-");
            queryWrapper.lambda().between(BlogTopManInformation::getFanTotal, (Object)split[0], (Object)split[1]);
        }
    }

    public static void getPutParam(Object str, String type, QueryWrapper<BlogTopManInformation> queryWrapper) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.le((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[1]);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.ge((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0]);
        } else {
            String[] split = value.split("-");
            queryWrapper.between((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0], (Object)split[1]);
        }
    }

    public static void sort(SimplePostRequestParam<BlogTopManDTO> topManDto, QueryWrapper<BlogTopManInformation> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn()) && !"default".equals(topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            queryWrapper.orderBy(true, order, (Object[])new String[]{EnterpriseBlogTopManServiceImpl.camelToUnderline(column)});
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    private EnterpriseTopManOptionsEntity getOtherCategory() {
        EnterpriseTopManOptionsEntity entity = new EnterpriseTopManOptionsEntity();
        ArrayList<EnterpriseTopManOptionsEntity.Tag> childrenList = new ArrayList<EnterpriseTopManOptionsEntity.Tag>();
        EnterpriseTopManOptionsEntity.Tag confirmChildren = new EnterpriseTopManOptionsEntity.Tag();
        confirmChildren.setComponent("RSelect");
        confirmChildren.setStarTagName("\u786e\u8ba4\u72b6\u6001");
        confirmChildren.setStarTagId("1");
        List<Object> subTags = Arrays.asList(new EnterpriseTopManOptionsEntity.Tag("0", "\u5168\u90e8", "0"), new EnterpriseTopManOptionsEntity.Tag("1", "\u5df2\u786e\u8ba4", "1"), new EnterpriseTopManOptionsEntity.Tag("2", "\u5f85\u786e\u8ba4", "2"));
        confirmChildren.setSubTags(subTags);
        EnterpriseTopManOptionsEntity.Tag leaderChildren = new EnterpriseTopManOptionsEntity.Tag();
        leaderChildren.setComponent("RSelect");
        leaderChildren.setStarTagName("\u8d1f\u8d23\u4eba");
        leaderChildren.setStarTagId("2");
        leaderChildren.setSubTags(this.transferAllTopManLeader());
        childrenList.add(confirmChildren);
        childrenList.add(leaderChildren);
        entity.setFieldName("otherFilter");
        entity.setSort(4);
        entity.setTitle("\u5176\u4ed6\u7b5b\u9009");
        entity.setChildren(childrenList);
        return entity;
    }

    private List<Object> transferAllTopManLeader() {
        List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        ArrayList<Object> tags = new ArrayList<Object>(allByAccount.size() + 1);
        EnterpriseTopManOptionsEntity.Tag tag = new EnterpriseTopManOptionsEntity.Tag();
        tag.setStarTagId("0");
        tag.setStarTagName("\u5168\u90e8");
        tag.setStarTagValue("0");
        tags.add(tag);
        allByAccount.forEach(a -> {
            EnterpriseTopManOptionsEntity.Tag subTag = new EnterpriseTopManOptionsEntity.Tag();
            subTag.setStarTagId(a.getSubAccount());
            subTag.setStarTagValue(a.getSubAccount());
            subTag.setStarTagName(a.getRealname());
            tags.add(subTag);
        });
        return tags;
    }
}

