/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.adapter;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.api.buyin_queryShopAllianceOrder.BuyinQueryShopAllianceOrderRequest;
import com.doudian.open.api.buyin_queryShopAllianceOrder.BuyinQueryShopAllianceOrderResponse;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.ColonelOrderInfo;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.Data;
import com.doudian.open.api.buyin_queryShopAllianceOrder.data.OrdersItem;
import com.doudian.open.api.buyin_queryShopAllianceOrder.param.BuyinQueryShopAllianceOrderParam;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailRequest;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailResponse;
import com.doudian.open.api.order_orderDetail.data.OrderOrderDetailData;
import com.doudian.open.api.order_orderDetail.data.ShopOrderDetail;
import com.doudian.open.api.order_orderDetail.data.SkuOrderListItem;
import com.doudian.open.api.order_orderDetail.param.OrderOrderDetailParam;
import com.doudian.open.core.AccessToken;
import com.els.common.adapter.Adapter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.DyOrder;
import com.els.modules.companystore.entity.DyOrderItem;
import com.els.modules.companystore.entity.DyShopProduct;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.DyOrderItemService;
import com.els.modules.companystore.service.DyOrderService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import com.els.modules.message.adapter.DouDianAdapter;
import com.els.modules.message.adapter.DouDianMessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"order"})
public class DouDianOrderMessageAdapter
extends DouDianAdapter {
    private static final Logger log = LoggerFactory.getLogger(DouDianOrderMessageAdapter.class);
    @Autowired
    private DyOrderService dyOrderService;
    @Autowired
    private DyOrderItemService dyOrderItemService;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private DouDianApiUtil douDianApiUtil;
    @Autowired
    private DyShopProductService dyShopProductService;

    @Override
    public void handleBefore(DouDianMessageContext douDianMessageContext) {
        JSONObject json = JSONObject.parseObject((String)douDianMessageContext.getDouDianMessageVO().getData().toString());
        String orderId = json.getString("p_id");
        String shopId = json.getString("shop_id");
        List companyStoreHeads = this.companyStoreHeadService.list((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getShopId, (Object)shopId));
        if (CollUtil.isEmpty((Collection)companyStoreHeads)) {
            return;
        }
        this.saveDbData(companyStoreHeads, orderId, shopId);
    }

    private void saveDbData(List<CompanyStoreHead> companyStoreHeads, String orderId, String shopId) {
        AccessToken accessToken = this.douDianApiUtil.getToken(shopId);
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            companyStoreHeads.forEach(companyStoreHead -> companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue()));
            this.companyStoreHeadService.updateBatchById(companyStoreHeads);
        }
        companyStoreHeads.forEach(companyStoreHead -> {
            OrderOrderDetailRequest request = new OrderOrderDetailRequest();
            request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
            OrderOrderDetailParam param = (OrderOrderDetailParam)request.getParam();
            param.setShopOrderId(orderId);
            OrderOrderDetailResponse response = (OrderOrderDetailResponse)request.execute(accessToken);
            if (response.isSuccess() && ObjectUtil.isNotEmpty(response.getData())) {
                ShopOrderDetail shopOrderDetail = ((OrderOrderDetailData)response.getData()).getShopOrderDetail();
                DyOrder dyOrder = new DyOrder();
                dyOrder.setElsAccount(companyStoreHead.getElsAccount());
                BeanUtil.copyProperties((Object)shopOrderDetail, (Object)((Object)dyOrder), (String[])new String[0]);
                dyOrder.setCreateTime(new Date());
                dyOrder.setUpdateTime(new Date());
                if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getCreateTime()) && !shopOrderDetail.getCreateTime().equals(0L)) {
                    dyOrder.setOrderCreateTime(new Date(shopOrderDetail.getCreateTime() * 1000L));
                    if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getOrderExpireTime()) && !shopOrderDetail.getOrderExpireTime().equals(0L)) {
                        dyOrder.setOrderExpireTime(new Date((shopOrderDetail.getCreateTime() + shopOrderDetail.getOrderExpireTime()) * 1000L));
                    } else {
                        dyOrder.setOrderExpireTime(null);
                    }
                } else {
                    dyOrder.setOrderCreateTime(null);
                }
                if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getUpdateTime()) && !shopOrderDetail.getUpdateTime().equals(0L)) {
                    dyOrder.setOrderUpdateTime(new Date(shopOrderDetail.getUpdateTime() * 1000L));
                } else {
                    dyOrder.setOrderUpdateTime(null);
                }
                if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getPayTime()) && !shopOrderDetail.getPayTime().equals(0L)) {
                    dyOrder.setPayTime(new Date(shopOrderDetail.getPayTime() * 1000L));
                } else {
                    dyOrder.setPayTime(null);
                }
                if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getShipTime()) && !shopOrderDetail.getShipTime().equals(0L)) {
                    dyOrder.setShipTime(new Date(shopOrderDetail.getShipTime() * 1000L));
                } else {
                    dyOrder.setShipTime(null);
                }
                if (ObjectUtil.isNotEmpty((Object)shopOrderDetail.getFinishTime()) && !shopOrderDetail.getFinishTime().equals(0L)) {
                    dyOrder.setFinishTime(new Date(shopOrderDetail.getFinishTime() * 1000L));
                } else {
                    dyOrder.setFinishTime(null);
                }
                ArrayList dyOrderItems = Lists.newArrayList();
                this.dyOrderService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyOrder::getOrderId, (Object)orderId)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount()));
                this.dyOrderService.save((Object)dyOrder);
                List<SkuOrderListItem> shopOrderListItems = shopOrderDetail.getSkuOrderList();
                if (CollUtil.isNotEmpty(shopOrderListItems)) {
                    for (SkuOrderListItem skuOrderListItem : shopOrderListItems) {
                        dyOrderItems.add(this.getDyOrderItem(skuOrderListItem, (CompanyStoreHead)((Object)companyStoreHead), accessToken));
                    }
                    this.dyOrderItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).eq(DyOrderItem::getParentOrderId, (Object)dyOrder.getOrderId()));
                    this.dyOrderItemService.saveBatch(dyOrderItems);
                }
            }
        });
    }

    private DyOrderItem getDyOrderItem(SkuOrderListItem skuOrderListItem, CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        DyOrderItem dyOrderItem = (DyOrderItem)((Object)BeanUtil.copyProperties((Object)skuOrderListItem, DyOrderItem.class, (String[])new String[0]));
        dyOrderItem.setElsAccount(companyStoreHead.getElsAccount());
        dyOrderItem.setCreateTime(new Date());
        dyOrderItem.setUpdateTime(new Date());
        if (ObjectUtil.isNotEmpty((Object)skuOrderListItem.getConfirmReceiptTime()) && !skuOrderListItem.getConfirmReceiptTime().equals(0L)) {
            dyOrderItem.setConfirmReceiptTime(new Date(skuOrderListItem.getConfirmReceiptTime() * 1000L));
        } else {
            dyOrderItem.setConfirmReceiptTime(null);
        }
        BuyinQueryShopAllianceOrderRequest request = new BuyinQueryShopAllianceOrderRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        BuyinQueryShopAllianceOrderParam param = (BuyinQueryShopAllianceOrderParam)request.getParam();
        param.setSize(1L);
        param.setCursor("0");
        param.setOrderIds(skuOrderListItem.getOrderId());
        BuyinQueryShopAllianceOrderResponse response = (BuyinQueryShopAllianceOrderResponse)request.execute(accessToken);
        log.debug("BuyinQueryShopAllianceOrderResponse is {}", (Object)JSON.toJSONString((Object)response));
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData()) && CollUtil.isNotEmpty(((Data)response.getData()).getOrders())) {
            ColonelOrderInfo colonelOrderInfo;
            List<OrdersItem> orders = ((Data)response.getData()).getOrders();
            OrdersItem ordersItem = orders.get(0);
            dyOrderItem.setMediaType(ordersItem.getMediaType());
            dyOrderItem.setSettleTime(ordersItem.getSettleTime());
            dyOrderItem.setPayGoodsAmount(ordersItem.getPayGoodsAmount());
            dyOrderItem.setSettledGoodsAmount(ordersItem.getSettledGoodsAmount());
            dyOrderItem.setRealCommission(ordersItem.getRealCommission());
            dyOrderItem.setEstimatedCommission(ordersItem.getEstimatedCommission());
            dyOrderItem.setAuthorAccount(ordersItem.getAuthorAccount());
            dyOrderItem.setAuthorBuyinId(ordersItem.getAuthorBuyinId());
            dyOrderItem.setAuthorShortId(ordersItem.getAuthorShortId());
            dyOrderItem.setFlowPoint(ordersItem.getFlowPoint());
            if (ObjectUtil.isNotEmpty((Object)ordersItem.getCommissionRate())) {
                if (ordersItem.getCommissionRate().equals(0L)) {
                    dyOrderItem.setCommissionRate("0");
                } else {
                    dyOrderItem.setCommissionRate(ordersItem.getCommissionRate() / 10000L + "");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(colonelOrderInfo = ordersItem.getColonelOrderInfo()))) {
                if (ObjectUtil.isNotEmpty((Object)colonelOrderInfo.getActivityId())) {
                    dyOrderItem.setActivityId(colonelOrderInfo.getActivityId() + "");
                }
                if (ObjectUtil.isNotEmpty((Object)colonelOrderInfo.getInstitutionId())) {
                    dyOrderItem.setInstitutionId(colonelOrderInfo.getInstitutionId() + "");
                }
                dyOrderItem.setInstitutionName(colonelOrderInfo.getInstitutionName());
                dyOrderItem.setHeadEstimatedCommission(colonelOrderInfo.getEstimatedCommission());
                dyOrderItem.setHeadRealCommission(colonelOrderInfo.getRealCommission());
                dyOrderItem.setHeadCommissionRate(colonelOrderInfo.getCommissionRate());
            }
            if (ObjectUtil.isNotEmpty((Object)ordersItem.getMediaId())) {
                dyOrderItem.setMediaId(ordersItem.getMediaId() + "");
            }
            log.debug("order is {}", (Object)JSON.toJSONString(orders));
        }
        if (StrUtil.isNotBlank((CharSequence)dyOrderItem.getProductId())) {
            this.handleProduct(dyOrderItem.getProductId(), companyStoreHead, accessToken);
        }
        return dyOrderItem;
    }

    private void handleProduct(String productId, CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        if (this.dyShopProductService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyShopProduct::getProductId, (Object)productId)).eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())) == 0) {
            this.dyShopProductService.pullById(productId, companyStoreHead, accessToken);
        }
    }
}

