/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.els.common.adapter.AdapterFactory;
import com.els.modules.message.adapter.DouDianMessageContext;
import com.els.modules.message.adapter.IDouDianMessageAdapter;
import com.els.modules.message.enumerate.MessageTagTypeEnum;
import com.els.modules.message.service.DouDianMessageService;
import com.els.modules.message.vo.DouDianMessageVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class DouDianMessageServiceImpl
implements DouDianMessageService {
    @Autowired
    private AdapterFactory adapterFactory;

    @Override
    public void handleMessage(List<DouDianMessageVO> req) {
        req.forEach(message -> {
            MessageTagTypeEnum messageTagTypeEnum = MessageTagTypeEnum.getMessageTagTypeByCode(message.getTag());
            if (ObjectUtil.isEmpty((Object)((Object)messageTagTypeEnum))) {
                return;
            }
            String adapterName = messageTagTypeEnum.getType();
            IDouDianMessageAdapter adapter = (IDouDianMessageAdapter)this.adapterFactory.get(adapterName, IDouDianMessageAdapter.class);
            if (ObjectUtil.isEmpty((Object)adapter)) {
                return;
            }
            DouDianMessageContext context = new DouDianMessageContext();
            context.setDouDianMessageVO((DouDianMessageVO)message);
            adapter.handleBefore(context);
        });
    }
}

