/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.popularize.entity.SupplierTopmanOrderCost;
import com.els.modules.popularize.entity.SupplierTopmanOrderHead;
import com.els.modules.popularize.entity.SupplierTopmanOrderItem;
import com.els.modules.popularize.entity.TopmanOrderHead;
import com.els.modules.popularize.entity.TopmanOrderItem;
import com.els.modules.popularize.enumerate.TopmanOrderStatusEnum;
import com.els.modules.popularize.mapper.SupplierTopmanOrderCostMapper;
import com.els.modules.popularize.mapper.SupplierTopmanOrderHeadMapper;
import com.els.modules.popularize.mapper.SupplierTopmanOrderItemMapper;
import com.els.modules.popularize.mapper.TopmanOrderCostMapper;
import com.els.modules.popularize.mapper.TopmanOrderHeadMapper;
import com.els.modules.popularize.mapper.TopmanOrderItemMapper;
import com.els.modules.popularize.service.SupplierTopmanOrderHeadService;
import com.els.modules.popularize.service.SupplierTopmanOrderItemService;
import com.els.modules.popularize.service.TopmanOrderItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierTopmanOrderHeadServiceImpl
extends BaseServiceImpl<SupplierTopmanOrderHeadMapper, SupplierTopmanOrderHead>
implements SupplierTopmanOrderHeadService {
    @Resource
    private SupplierTopmanOrderHeadMapper supplierTopmanOrderHeadMapper;
    @Resource
    private SupplierTopmanOrderItemMapper supplierTopmanOrderItemMapper;
    @Resource
    private SupplierTopmanOrderCostMapper supplierTopmanOrderCostMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TopmanOrderHeadMapper topmanOrderHeadMapper;
    @Resource
    private TopmanOrderItemMapper topmanOrderItemMapper;
    @Resource
    private TopmanOrderCostMapper topmanOrderCostMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierTopmanOrderHead supplierTopmanOrderHead, List<SupplierTopmanOrderItem> supplierTopmanOrderItemList, List<SupplierTopmanOrderCost> supplierTopmanOrderCostList) {
        supplierTopmanOrderHead.setReceiptsNum(this.invokeBaseRpcService.getNextCode("topmanOrderReceiptsNum", (Object)supplierTopmanOrderHead));
        this.supplierTopmanOrderHeadMapper.insert((Object)supplierTopmanOrderHead);
        super.setHeadDefaultValue((BaseEntity)supplierTopmanOrderHead);
        this.insertData(supplierTopmanOrderHead, supplierTopmanOrderItemList, supplierTopmanOrderCostList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierTopmanOrderHead supplierTopmanOrderHead, List<SupplierTopmanOrderItem> supplierTopmanOrderItemList, List<SupplierTopmanOrderCost> supplierTopmanOrderCostList) {
        this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        this.supplierTopmanOrderItemMapper.deleteByMainId(supplierTopmanOrderHead.getId());
        this.supplierTopmanOrderCostMapper.deleteByMainId(supplierTopmanOrderHead.getId());
        this.insertData(supplierTopmanOrderHead, supplierTopmanOrderItemList, supplierTopmanOrderCostList);
    }

    private void insertData(SupplierTopmanOrderHead supplierTopmanOrderHead, List<SupplierTopmanOrderItem> supplierTopmanOrderItemList, List<SupplierTopmanOrderCost> supplierTopmanOrderCostList) {
        if (!CollectionUtils.isEmpty(supplierTopmanOrderItemList)) {
            for (SupplierTopmanOrderItem supplierTopmanOrderItem : supplierTopmanOrderItemList) {
                supplierTopmanOrderItem.setHeadId(supplierTopmanOrderHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierTopmanOrderItem, (BaseEntity)supplierTopmanOrderHead);
                supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CONTRACT_NEW.getValue());
            }
            if (!supplierTopmanOrderItemList.isEmpty()) {
                this.supplierTopmanOrderItemMapper.insertBatchSomeColumn(supplierTopmanOrderItemList);
            }
        }
        if (!CollectionUtils.isEmpty(supplierTopmanOrderCostList)) {
            for (SupplierTopmanOrderCost supplierTopmanOrderCost : supplierTopmanOrderCostList) {
                supplierTopmanOrderCost.setHeadId(supplierTopmanOrderHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierTopmanOrderCost, (BaseEntity)supplierTopmanOrderHead);
            }
            if (!supplierTopmanOrderCostList.isEmpty()) {
                this.supplierTopmanOrderCostMapper.insertBatchSomeColumn(supplierTopmanOrderCostList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierTopmanOrderItemMapper.deleteByMainId(id);
        this.supplierTopmanOrderCostMapper.deleteByMainId(id);
        this.supplierTopmanOrderHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierTopmanOrderItemMapper.deleteByMainId(serializable.toString());
            this.supplierTopmanOrderCostMapper.deleteByMainId(serializable.toString());
            this.supplierTopmanOrderHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirm(String id) {
        SupplierTopmanOrderItem supplierTopmanOrderItem = (SupplierTopmanOrderItem)((Object)this.supplierTopmanOrderItemMapper.selectById((Serializable)((Object)id)));
        this.checkRow(supplierTopmanOrderItem);
        supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        TopmanOrderItem topmanOrderItem = new TopmanOrderItem();
        topmanOrderItem.setId(id);
        topmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        this.supplierTopmanOrderItemMapper.updateById((Object)supplierTopmanOrderItem);
        this.topmanOrderItemMapper.updateById((Object)topmanOrderItem);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reject(String id) {
        SupplierTopmanOrderItem supplierTopmanOrderItem = (SupplierTopmanOrderItem)((Object)this.supplierTopmanOrderItemMapper.selectById((Serializable)((Object)id)));
        this.checkRow(supplierTopmanOrderItem);
        supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.REFUND.getValue());
        TopmanOrderItem topmanOrderItem = new TopmanOrderItem();
        topmanOrderItem.setId(id);
        topmanOrderItem.setItemStatus(TopmanOrderStatusEnum.REFUND.getValue());
        this.supplierTopmanOrderItemMapper.updateById((Object)supplierTopmanOrderItem);
        this.topmanOrderItemMapper.updateById((Object)topmanOrderItem);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(String headId) {
        List<SupplierTopmanOrderItem> items = this.supplierTopmanOrderItemMapper.selectByMainId(headId);
        this.checkSubmit(items);
        SupplierTopmanOrderHead supplierTopmanOrderHead = new SupplierTopmanOrderHead();
        TopmanOrderHead topmanOrderHead = new TopmanOrderHead();
        long refundCount = items.stream().filter(h -> TopmanOrderStatusEnum.REFUND.getValue().equals(h.getItemStatus())).count();
        if (refundCount == (long)items.size()) {
            supplierTopmanOrderHead.setId(headId);
            supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.REFUND.getValue());
            topmanOrderHead.setId(supplierTopmanOrderHead.getId());
            topmanOrderHead.setStatus(TopmanOrderStatusEnum.REFUND.getValue());
        } else {
            supplierTopmanOrderHead.setId(headId);
            supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
            topmanOrderHead.setId(supplierTopmanOrderHead.getId());
            topmanOrderHead.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        }
        this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        this.topmanOrderHeadMapper.updateById((Object)topmanOrderHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmAll(String id) {
        SupplierTopmanOrderHead supplierTopmanOrderHead = (SupplierTopmanOrderHead)((Object)this.getById((Serializable)((Object)id)));
        this.check(supplierTopmanOrderHead);
        supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        TopmanOrderHead topmanOrderHead = new TopmanOrderHead();
        topmanOrderHead.setId(supplierTopmanOrderHead.getId());
        topmanOrderHead.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        ArrayList<SupplierTopmanOrderItem> supplierTopmanOrderItems = new ArrayList<SupplierTopmanOrderItem>();
        ArrayList<TopmanOrderItem> topmanOrderItems = new ArrayList<TopmanOrderItem>();
        List<SupplierTopmanOrderItem> items = this.supplierTopmanOrderItemMapper.selectByMainId(id);
        for (SupplierTopmanOrderItem item : items) {
            Assert.isTrue((boolean)TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue().equals(item.getItemStatus()), (String)I18nUtil.translate((String)"", (String)("\u8ba2\u5355\u884c\u53f7[" + item.getId() + "]\u5f53\u524d\u72b6\u6001\u975e\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u72b6\u6001\uff0c\u6682\u65f6\u4e0d\u80fd\u8fdb\u884c\u6574\u5355\u786e\u8ba4!")));
            SupplierTopmanOrderItem supplierTopmanOrderItem = new SupplierTopmanOrderItem();
            TopmanOrderItem topmanOrderItem = new TopmanOrderItem();
            supplierTopmanOrderItem.setId(item.getId());
            supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
            topmanOrderItem.setId(item.getId());
            topmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
            supplierTopmanOrderItems.add(supplierTopmanOrderItem);
            topmanOrderItems.add(topmanOrderItem);
        }
        if (CollectionUtil.isNotEmpty(supplierTopmanOrderItems)) {
            ((SupplierTopmanOrderItemService)SpringContextUtils.getBean(SupplierTopmanOrderItemService.class)).updateBatchById(supplierTopmanOrderItems);
        }
        if (CollectionUtil.isNotEmpty(topmanOrderItems)) {
            ((TopmanOrderItemService)SpringContextUtils.getBean(TopmanOrderItemService.class)).updateBatchById(topmanOrderItems);
        }
        this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        this.topmanOrderHeadMapper.updateById((Object)topmanOrderHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void rejectAll(String id) {
        SupplierTopmanOrderHead supplierTopmanOrderHead = (SupplierTopmanOrderHead)((Object)this.getById((Serializable)((Object)id)));
        this.check(supplierTopmanOrderHead);
        supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.REFUND.getValue());
        TopmanOrderHead topmanOrderHead = new TopmanOrderHead();
        topmanOrderHead.setId(supplierTopmanOrderHead.getId());
        topmanOrderHead.setStatus(TopmanOrderStatusEnum.REFUND.getValue());
        ArrayList<SupplierTopmanOrderItem> supplierTopmanOrderItems = new ArrayList<SupplierTopmanOrderItem>();
        ArrayList<TopmanOrderItem> topmanOrderItems = new ArrayList<TopmanOrderItem>();
        List<SupplierTopmanOrderItem> items = this.supplierTopmanOrderItemMapper.selectByMainId(id);
        for (SupplierTopmanOrderItem item : items) {
            Assert.isTrue((boolean)TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue().equals(item.getItemStatus()), (String)I18nUtil.translate((String)"", (String)("\u8ba2\u5355\u884c\u53f7[" + item.getId() + "]\u5f53\u524d\u72b6\u6001\u975e\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u72b6\u6001\uff0c\u6682\u65f6\u4e0d\u80fd\u8fdb\u884c\u6574\u5355\u62d2\u7edd!")));
            SupplierTopmanOrderItem supplierTopmanOrderItem = new SupplierTopmanOrderItem();
            TopmanOrderItem topmanOrderItem = new TopmanOrderItem();
            supplierTopmanOrderItem.setId(item.getId());
            supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.REFUND.getValue());
            topmanOrderItem.setId(item.getId());
            topmanOrderItem.setItemStatus(TopmanOrderStatusEnum.REFUND.getValue());
            supplierTopmanOrderItems.add(supplierTopmanOrderItem);
            topmanOrderItems.add(topmanOrderItem);
        }
        if (CollectionUtil.isNotEmpty(supplierTopmanOrderItems)) {
            ((SupplierTopmanOrderItemService)SpringContextUtils.getBean(SupplierTopmanOrderItemService.class)).updateBatchById(supplierTopmanOrderItems);
        }
        if (CollectionUtil.isNotEmpty(topmanOrderItems)) {
            ((TopmanOrderItemService)SpringContextUtils.getBean(TopmanOrderItemService.class)).updateBatchById(topmanOrderItems);
        }
        this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        this.topmanOrderHeadMapper.updateById((Object)topmanOrderHead);
    }

    private void checkSubmit(List<SupplierTopmanOrderItem> items) {
        if (CollectionUtil.isEmpty(items)) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        String status = TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue();
        long count = items.stream().filter(h -> status.equals(h.getItemStatus())).count();
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u660e\u7ec6\u672a\u5168\u90e8\u786e\u8ba4"));
        for (SupplierTopmanOrderItem item : items) {
            if (TenantContext.getTenant().equals(item.getElsAccount())) continue;
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8ba2\u5355\u884cID" + item.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void checkRow(SupplierTopmanOrderItem orderItem) {
        if (orderItem == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        String status = TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue();
        Assert.isTrue((boolean)status.equals(orderItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u72b6\u6001\u4e3a\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        if (!TenantContext.getTenant().equals(orderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8ba2\u5355\u884cID" + orderItem.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void check(SupplierTopmanOrderHead orderHead) {
        if (orderHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        String status = TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue();
        Assert.isTrue((boolean)status.equals(orderHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u72b6\u6001\u4e3a\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        if (!TenantContext.getTenant().equals(orderHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8ba2\u5355\u5934ID" + orderHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }
}

