/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.promotional.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.promotional.dto.CountDTO;
import com.els.modules.promotional.dto.OrgCountDTO;
import com.els.modules.promotional.dto.PromotionalDataItemDto;
import com.els.modules.promotional.dto.SampleDeliveryCountDTO;
import com.els.modules.promotional.dto.TopManCountDTO;
import com.els.modules.promotional.entity.PromotionalDataHead;
import com.els.modules.promotional.entity.PromotionalDataItem;
import com.els.modules.promotional.mapper.PromotionalDataHeadMapper;
import com.els.modules.promotional.service.PromotionalDataHeadService;
import com.els.modules.promotional.service.PromotionalDataItemService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PromotionalDataHeadServiceImpl
extends BaseServiceImpl<PromotionalDataHeadMapper, PromotionalDataHead>
implements PromotionalDataHeadService {
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public void add(PromotionalDataHead promotionalDataHead) {
        ((PromotionalDataHeadMapper)this.baseMapper).insert((Object)promotionalDataHead);
    }

    @Override
    public void edit(PromotionalDataHead promotionalDataHead) {
        int count = ((PromotionalDataHeadMapper)this.baseMapper).updateById((Object)promotionalDataHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PromotionalDataHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PromotionalDataHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PromotionalDataHead selectOneByOnlyParam(String subAccount, int countYear, int countMonth, String elsAccount) {
        return (PromotionalDataHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataHead::getSubAccount, (Object)subAccount)).eq(PromotionalDataHead::getCountYear, (Object)countYear)).eq(PromotionalDataHead::getCountMonth, (Object)countMonth)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PromotionalDataHead::getDeleted, (Object)"0")));
    }

    @Override
    public List<PromotionalDataHead> findByTimes(String startTime, String endTime) {
        return ((PromotionalDataHeadMapper)this.baseMapper).findByTimes(startTime, endTime, TenantContext.getTenant());
    }

    private Map<String, Map<Pair<Integer, Integer>, List<PromotionalDataItemDto>>> getOrderData(String startTime, String endTime) {
        List<PromotionalDataItemDto> promotionalDataItems = this.promotionalDataItemService.findOrder(startTime, endTime, TenantContext.getTenant());
        Map<String, List<PromotionalDataItemDto>> subMap = promotionalDataItems.stream().collect(Collectors.groupingBy(PromotionalDataItem::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthData((List<PromotionalDataItemDto>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<PromotionalDataItemDto>> yearMonthData = this.getYearMonthData((List<PromotionalDataItemDto>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<TopManCountDTO>>> getTopmanCountData(List<TopManCountDTO> dataItems) {
        Map<String, List<TopManCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthTopmanCountData((List<TopManCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<TopManCountDTO>> yearMonthData = this.getYearMonthTopmanCountData((List<TopManCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>>> getSampleDeliveryCountData(List<SampleDeliveryCountDTO> dataItems) {
        Map<String, List<SampleDeliveryCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getSampleDeliveryCountCountData((List<SampleDeliveryCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>> yearMonthData = this.getSampleDeliveryCountCountData((List<SampleDeliveryCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<OrgCountDTO>>> getOrgCountData(List<OrgCountDTO> dataItems) {
        Map<String, List<OrgCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthOrgCountData((List<OrgCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<OrgCountDTO>> yearMonthData = this.getYearMonthOrgCountData((List<OrgCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    @Override
    public void async(String startTime, String endTime) {
        List<TopManCountDTO> topManCountDTOS = ((PromotionalDataHeadMapper)this.baseMapper).findTopManNum(startTime, endTime, TenantContext.getTenant());
        List<OrgCountDTO> orgCountDtos = ((PromotionalDataHeadMapper)this.baseMapper).findOrgNum(startTime, endTime, TenantContext.getTenant());
        List<SampleDeliveryCountDTO> sampleDeliveryCountDTOs = ((PromotionalDataHeadMapper)this.baseMapper).findSampleDeliveryNum(startTime, endTime, TenantContext.getTenant());
        Map<String, Map<Pair<Integer, Integer>, List<PromotionalDataItemDto>>> orderMap = this.getOrderData(startTime, endTime);
        Map<String, Map<Pair<Integer, Integer>, List<TopManCountDTO>>> subTopmanCountMap = this.getTopmanCountData(topManCountDTOS);
        Map<String, Map<Pair<Integer, Integer>, List<OrgCountDTO>>> subOrgCountMap = this.getOrgCountData(orgCountDtos);
        Map<String, Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>>> sampleDeliveryCountMap = this.getSampleDeliveryCountData(sampleDeliveryCountDTOs);
    }

    private Map<Pair<Integer, Integer>, List<PromotionalDataItemDto>> getYearMonthData(List<PromotionalDataItemDto> data) {
        HashMap var = Maps.newHashMap();
        for (PromotionalDataItemDto datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<TopManCountDTO>> getYearMonthTopmanCountData(List<TopManCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (TopManCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<OrgCountDTO>> getYearMonthOrgCountData(List<OrgCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (OrgCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>> getSampleDeliveryCountCountData(List<SampleDeliveryCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (SampleDeliveryCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }
}

