/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.dto.H5DTO;
import com.els.modules.alliance.dto.MyGoodsTopmanItemDTO;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTop;
import com.els.modules.alliance.entity.MyGoodsTopmanItem;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.entity.MyPromotionalTopmanItem;
import com.els.modules.alliance.enumerate.MyGoodsStatusEnum;
import com.els.modules.alliance.mapper.MyPromotionalHeadMapper;
import com.els.modules.alliance.service.MyGoodsSpreaderItemService;
import com.els.modules.alliance.service.MyGoodsTopService;
import com.els.modules.alliance.service.MyGoodsTopmanItemService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.alliance.service.MyPromotionalTopmanItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MyPromotionalHeadServiceImpl
extends BaseServiceImpl<MyPromotionalHeadMapper, MyPromotionalHead>
implements MyPromotionalHeadService {
    @Autowired
    private MyPromotionalTopmanItemService myPromotionalTopmanItemService;
    @Autowired
    private MyGoodsTopService myGoodsTopService;
    @Autowired
    private MyGoodsSpreaderItemService myGoodsSpreaderItemService;
    @Autowired
    private MyGoodsTopmanItemService myGoodsTopmanItemService;

    @Override
    public IPage<MyPromotionalHead> queryPage(MyPromotionalHead head, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.put("column", new String[]{"flag,update_time"});
        parameterMap.put("order", new String[]{"desc"});
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String tab = "";
        String[] tabs = (String[])parameterMap.get("tab");
        if (tabs != null && tabs.length > 0) {
            tab = tabs[0];
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)tab)) {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        } else {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        }
        return ((MyPromotionalHeadMapper)this.baseMapper).queryPage((Page<MyPromotionalHead>)page, (QueryWrapper<MyPromotionalHead>)queryWrapper, loginUser.getElsAccount(), loginUser.getSubAccount());
    }

    @Override
    public List<CountVO> queryTabsCount(MyPromotionalHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        LoginUser loginUser = SysUtil.getLoginUser();
        List<MyPromotionalHead> list = this.listByElsAccount(head, req, loginUser.getElsAccount());
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "tab", "", Integer.valueOf(list.size())));
        int total = 0;
        if (CollectionUtil.isNotEmpty(list)) {
            total = (int)list.stream().filter(h -> loginUser.getSubAccount().equals(h.getSubAccount())).count();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_my_promotional", (String)"\u6211\u7684\u63a8\u5e7f"), "tab", "2", Integer.valueOf(total)));
        return result;
    }

    private List<MyPromotionalHead> listByElsAccount(MyPromotionalHead head, HttpServletRequest req, String elsAccount) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        return ((MyPromotionalHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMyPromotional(String id) {
        MyPromotionalHead head = this.deleteCheck(id);
        ((MyPromotionalHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.myGoodsSpreaderItemService.softDelete(head.getRelationId(), head.getElsAccount(), head.getSubAccount());
    }

    @Override
    public void topOrCancel(String id, Boolean flag) {
        MyPromotionalHead promotional = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (promotional == null) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (flag.booleanValue()) {
            MyGoodsTop top = new MyGoodsTop();
            top.setElsAccount(loginUser.getElsAccount());
            top.setSubAccount(loginUser.getSubAccount());
            top.setHeadId(promotional.getId());
            top.setPlatform(promotional.getPlatform());
            this.myGoodsTopService.save((Object)top);
        } else {
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            this.myGoodsTopService.deleteTop(id, elsAccount, subAccount, promotional.getPlatform());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addTopman(MyGoodsTopmanItemDTO dto) {
        this.addTopmanCheck(dto.getId(), dto.getTopmanItems());
        MyPromotionalHead promotionalHead = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)dto.getId())));
        MyGoodsSpreaderItem spreaderItem = this.myGoodsSpreaderItemService.getMyGoodsSpreaderItem(promotionalHead.getRelationId(), promotionalHead.getElsAccount(), promotionalHead.getSubAccount());
        List<MyPromotionalTopmanItem> promotionalTopmans = dto.getTopmanItems();
        ArrayList<MyGoodsTopmanItem> goodsTopmans = new ArrayList<MyGoodsTopmanItem>();
        for (MyPromotionalTopmanItem promotionalTopman : promotionalTopmans) {
            promotionalTopman.setElsAccount(promotionalHead.getElsAccount());
            promotionalTopman.setToElsAccount(spreaderItem.getElsAccount());
            promotionalTopman.setHeadId(promotionalHead.getId());
            MyGoodsTopmanItem goodsTopman = new MyGoodsTopmanItem();
            goodsTopman.setElsAccount(spreaderItem.getElsAccount());
            goodsTopman.setToElsAccount(promotionalHead.getElsAccount());
            goodsTopman.setHeadId(spreaderItem.getId());
            goodsTopman.setTopmanElsAccount(promotionalTopman.getTopmanElsAccount());
            goodsTopman.setCompanyName(promotionalTopman.getCompanyName());
            goodsTopman.setTopmanSubAccount(promotionalTopman.getTopmanSubAccount());
            goodsTopman.setTopmanId(promotionalTopman.getTopmanId());
            goodsTopman.setTopmanName(promotionalTopman.getTopmanName());
            goodsTopmans.add(goodsTopman);
        }
        promotionalHead.setUpdateTime(new Date());
        this.updateById((Object)promotionalHead);
        this.myPromotionalTopmanItemService.saveBatch(promotionalTopmans);
        this.myGoodsTopmanItemService.saveBatch(goodsTopmans);
    }

    @Override
    public void deleteTopman(List<String> idList) {
        this.deleteTopmanCheck(idList);
        this.myPromotionalTopmanItemService.deleteTopman(idList);
    }

    @Override
    public MyPromotionalHead getByRelationId(String relationId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MyPromotionalHead::getRelationId, (Object)relationId);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        return (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public void soldOutByRelationId(String relationId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(MyPromotionalHead::getGoodsStatus, (Object)MyGoodsStatusEnum.UNLOADING.getValue());
        updateWrapper.eq(MyPromotionalHead::getRelationId, (Object)relationId);
        ((MyPromotionalHeadMapper)this.baseMapper).update((Object)new MyPromotionalHead(), (Wrapper)updateWrapper);
    }

    @Override
    public IPage<MyPromotionalHead> queryH5Page(MyPromotionalHead head, String elsAccount, String openId, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.put("column", new String[]{"flag,create_time"});
        parameterMap.put("order", new String[]{"desc"});
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        return ((MyPromotionalHeadMapper)this.baseMapper).queryH5Page((Page<MyPromotionalHead>)page, (QueryWrapper<MyPromotionalHead>)queryWrapper, openId);
    }

    @Override
    public void h5TopOrCancel(H5DTO.TopDto topDto) {
        String id = topDto.getId();
        Boolean flag = topDto.getFlag();
        String openId = topDto.getOpenId();
        MyPromotionalHead promotional = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (promotional == null) {
            return;
        }
        if (flag.booleanValue()) {
            MyGoodsTop db = (MyGoodsTop)((Object)this.myGoodsTopService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsTop::getOpenId, (Object)openId)).eq(MyGoodsTop::getHeadId, (Object)promotional.getId())).eq(MyGoodsTop::getPlatform, (Object)promotional.getPlatform())));
            if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
                return;
            }
            MyGoodsTop top = new MyGoodsTop();
            top.setOpenId(openId);
            top.setHeadId(promotional.getId());
            top.setPlatform(promotional.getPlatform());
            this.myGoodsTopService.save((Object)top);
        } else {
            this.myGoodsTopService.removeByOpenId(id, openId, promotional.getPlatform());
        }
    }

    @Override
    public void delH5MyPromotional(H5DTO.TopDto topDto) {
        String id = topDto.getId();
        String openId = topDto.getOpenId();
        MyPromotionalHead head = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isNotNull((Object)((Object)head), (String)"\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u5df2\u88ab\u5220\u9664");
        ((MyPromotionalHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.myGoodsSpreaderItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsSpreaderItem::getHeadId, (Object)head.getRelationId())).eq(MyGoodsSpreaderItem::getOpenId, (Object)openId));
    }

    private MyPromotionalHead deleteCheck(String id) {
        MyPromotionalHead head = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u63a8\u5e7f\u4fe1\u606fID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u63a8\u5e7f\u4fe1\u606fID" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
        return head;
    }

    private void addTopmanCheck(String id, List<MyPromotionalTopmanItem> topmanItems) {
        MyGoodsSpreaderItem spreaderItem;
        MyPromotionalHead promotionalHead = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (promotionalHead == null) {
            throw new ELSBootException("\u63a8\u5e7f\u5934ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!TenantContext.getTenant().equals(promotionalHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u63a8\u5e7f\u5934ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
        if (MyGoodsStatusEnum.UNLOADING.getValue().equals(promotionalHead.getGoodsStatus())) {
            throw new ELSBootException("\u5546\u54c1\u72b6\u6001\u4e3a\u5df2\u4e0b\u67b6\uff0c\u4e0d\u53ef\u7f16\u8f91\u8fbe\u4eba\u4fe1\u606f");
        }
        if (ObjectUtil.isNotEmpty((Object)promotionalHead.getEndTime()) && promotionalHead.getEndTime().getTime() < System.currentTimeMillis()) {
            throw new ELSBootException("\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u8be5\u5546\u54c1\u7684\u63a8\u5e7f\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u53ef\u7f16\u8f91\u8fbe\u4eba\u4fe1\u606f");
        }
        if (CollectionUtil.isNotEmpty(topmanItems)) {
            List<String> topmanIds = topmanItems.stream().map(MyPromotionalTopmanItem::getTopmanId).distinct().collect(Collectors.toList());
            List<MyPromotionalTopmanItem> items = this.myPromotionalTopmanItemService.listByTopmanIds(promotionalHead.getId(), topmanIds);
            if (CollectionUtil.isNotEmpty(items)) {
                throw new ELSBootException("\u8be5\u8fbe\u4eba\u6dfb\u52a0\u91cd\u590d");
            }
        }
        if ((spreaderItem = this.myGoodsSpreaderItemService.getMyGoodsSpreaderItem(promotionalHead.getRelationId(), promotionalHead.getElsAccount(), promotionalHead.getSubAccount())) == null) {
            throw new ELSBootException("\u63a8\u5e7f\u8005\u4fe1\u606f\u884c\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
    }

    private void deleteTopmanCheck(List<String> idList) {
        ArrayList headsIds = Lists.newArrayList();
        for (String id : idList) {
            MyPromotionalTopmanItem item = (MyPromotionalTopmanItem)((Object)this.myPromotionalTopmanItemService.getById((Serializable)((Object)id)));
            if (item == null) {
                throw new ELSBootException("\u8fbe\u4eba\u4fe1\u606fID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
            }
            if (!TenantContext.getTenant().equals(item.getElsAccount())) {
                throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8fbe\u4eba\u4fe1\u606fID" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
            }
            headsIds.add(item.getHeadId());
        }
        MyPromotionalHead promotionalHead = (MyPromotionalHead)((Object)((MyPromotionalHeadMapper)this.baseMapper).selectById((Serializable)headsIds.get(0)));
        if (promotionalHead == null) {
            throw new ELSBootException("\u63a8\u5e7f\u5934\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (MyGoodsStatusEnum.UNLOADING.getValue().equals(promotionalHead.getGoodsStatus())) {
            throw new ELSBootException("\u5546\u54c1\u72b6\u6001\u4e3a\u5df2\u4e0b\u67b6\uff0c\u4e0d\u53ef\u7f16\u8f91\u8fbe\u4eba\u4fe1\u606f");
        }
        if (ObjectUtil.isNotEmpty((Object)promotionalHead.getEndTime()) && promotionalHead.getEndTime().getTime() < System.currentTimeMillis()) {
            throw new ELSBootException("\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u8be5\u5546\u54c1\u7684\u63a8\u5e7f\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u53ef\u7f16\u8f91\u8fbe\u4eba\u4fe1\u606f");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BaseEntity::getUpdateTime, (Object)new Date())).in(BaseEntity::getId, (Collection)headsIds));
    }
}

