/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.amateur.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.amateur.entity.PurchaseAmateurHead;
import com.els.modules.amateur.entity.PurchaseAmateurItem;
import com.els.modules.amateur.service.PurchaseAmateurHeadService;
import com.els.modules.amateur.service.PurchaseAmateurItemService;
import com.els.modules.amateur.vo.PurchaseAmateurHeadVO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/amateur/purchaseAmateurHead"})
@Api(tags={"\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406"})
public class PurchaseAmateurHeadController
extends BaseController<PurchaseAmateurHead, PurchaseAmateurHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAmateurHeadController.class);
    @Autowired
    private PurchaseAmateurHeadService purchaseAmateurHeadService;
    @Autowired
    private PurchaseAmateurItemService purchaseAmateurItemService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseAmateurHead purchaseAmateurHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        LoginUser loginUser = SysUtil.getLoginUser();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAmateurHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)loginUser.getElsAccount());
        IPage<PurchaseAmateurHead> pageList = this.purchaseAmateurHeadService.pageLeftEnterpriseInfo((Page<PurchaseAmateurHead>)page, (QueryWrapper<PurchaseAmateurHead>)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseAmateurHeadVO purchaseAmateurHeadPage) {
        PurchaseAmateurHead purchaseAmateurHead = new PurchaseAmateurHead();
        BeanUtils.copyProperties((Object)((Object)purchaseAmateurHeadPage), (Object)((Object)purchaseAmateurHead));
        this.purchaseAmateurHeadService.saveMain(purchaseAmateurHead, purchaseAmateurHeadPage.getPurchaseAmateurItemList());
        return Result.ok((Object)((Object)purchaseAmateurHead));
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody PurchaseAmateurHeadVO purchaseAmateurHeadPage) {
        PurchaseAmateurHead purchaseAmateurHead = new PurchaseAmateurHead();
        BeanUtils.copyProperties((Object)((Object)purchaseAmateurHeadPage), (Object)((Object)purchaseAmateurHead));
        this.purchaseAmateurHeadService.submit(purchaseAmateurHead, purchaseAmateurHeadPage.getPurchaseAmateurItemList());
        return Result.ok((Object)((Object)purchaseAmateurHead));
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseAmateurHeadVO purchaseAmateurHeadPage) {
        PurchaseAmateurHead purchaseAmateurHead = new PurchaseAmateurHead();
        BeanUtils.copyProperties((Object)((Object)purchaseAmateurHeadPage), (Object)((Object)purchaseAmateurHead));
        this.purchaseAmateurHeadService.updateMain(purchaseAmateurHead, purchaseAmateurHeadPage.getPurchaseAmateurItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseAmateurHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseAmateurHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseAmateurHead purchaseAmateurHead = (PurchaseAmateurHead)((Object)this.purchaseAmateurHeadService.getById((Serializable)((Object)id)));
        ElsEnterpriseInfoDTO info = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant());
        purchaseAmateurHead.setCompanyOrgType(info.getCompanyOrgType());
        purchaseAmateurHead.setCreditCode(info.getCreditCode());
        purchaseAmateurHead.setLegalPersonName(info.getLegalPersonName());
        purchaseAmateurHead.setEstablishTime(info.getEstablishTime());
        purchaseAmateurHead.setAddress(info.getRegLocation());
        purchaseAmateurHead.setPhoneNumber(info.getPhoneNumber());
        purchaseAmateurHead.setEmail(info.getEmail());
        PurchaseAmateurHeadVO purchaseAmateurHeadVO = new PurchaseAmateurHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseAmateurHead), (Object)((Object)purchaseAmateurHeadVO));
        List<PurchaseAmateurItem> purchaseAmateurItemList = this.purchaseAmateurItemService.selectByMainId(id);
        purchaseAmateurHeadVO.setPurchaseAmateurItemList(purchaseAmateurItemList);
        List<ElsEnterpriseInfoDTO> elsEnterpriseInfoDTOList = this.purchaseAmateurItemService.selectPurchaseEnterpriseInfoList(purchaseAmateurHead.getToElsAccount());
        purchaseAmateurHeadVO.setElsEnterpriseInfoDTOList(elsEnterpriseInfoDTOList);
        return Result.ok((Object)((Object)purchaseAmateurHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406id\u67e5\u8be2 \u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", notes="\u901a\u8fc7\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406id\u67e5\u8be2 \u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406")
    @GetMapping(value={"/queryPurchaseAmateurItemByMainId"})
    public Result<?> queryPurchaseAmateurItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseAmateurItem> purchaseAmateurItemList = this.purchaseAmateurItemService.selectByMainId(id);
        return Result.ok(purchaseAmateurItemList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7d20\u4eba\u8d26\u53f7", notes="\u83b7\u53d6\u7d20\u4eba\u8d26\u53f7")
    @GetMapping(value={"/getAmateurAccount"})
    public Result<?> getAmateurAccount() {
        List<PurchaseAmateurHead> purchaseAmateurHeadList = this.purchaseAmateurHeadService.getAmateurAccount();
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7ID\u51bb\u7ed3\u89e3\u51bb\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406\u5355\u636e", notes="\u901a\u8fc7ID\u51bb\u7ed3\u89e3\u51bb\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406\u5355\u636e")
    @GetMapping(value={"/freezenAmateurById"})
    public Result<?> freezenAmateurById(@RequestParam(name="id") String id) {
        this.purchaseAmateurHeadService.freezenOrUnFreezenById(id);
        return Result.ok();
    }

    @AutoLog(busModule="\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406", value="\u7ed1\u5b9a\u8fbe\u4eba\u4fe1\u606f")
    @ApiOperation(value="\u7ed1\u5b9a\u8fbe\u4eba\u4fe1\u606f", notes="\u7ed1\u5b9a\u8fbe\u4eba\u4fe1\u606f")
    @PostMapping(value={"/bindTopMan"})
    public Result<?> bindTopMan(@RequestBody PurchaseAmateurItem purchaseAmateurItem) {
        Object code = this.redisUtil.get(purchaseAmateurItem.getPhone());
        if (!purchaseAmateurItem.getNoteCode().equals(code)) {
            // empty if block
        }
        this.purchaseAmateurHeadService.bindTopMan(purchaseAmateurItem);
        return Result.ok();
    }
}

