/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.job;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token_refresh.TokenRefreshRequest;
import com.doudian.open.api.token_refresh.TokenRefreshResponse;
import com.doudian.open.api.token_refresh.data.TokenRefreshData;
import com.doudian.open.api.token_refresh.param.TokenRefreshParam;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.entity.CompanyStoreAuthorize;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.CompanyStoreAuthorizeMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DyTokenRefreshApiJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(DyTokenRefreshApiJob.class);
    @Resource
    private CompanyStoreAuthorizeMapper companyStoreAuthorizeMapper;
    @Resource
    private DouDianApiUtil douDianApiUtil;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private CompanyStoreHeadService companyStoreHeadService;

    public void execute(String parameter) {
        log.info("==============\u5237\u65b0\u6296\u5e97token\u5f00\u59cb================");
        List companyStoreHeadList = this.companyStoreAuthorizeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().isNotNull(CompanyStoreAuthorize::getRefreshToken)).isNotNull(CompanyStoreAuthorize::getAccessToken)).gt(CompanyStoreAuthorize::getValidityPeriod, (Object)new Date()));
        if (CollUtil.isNotEmpty((Collection)companyStoreHeadList)) {
            companyStoreHeadList.forEach(companyStoreAuthorize -> {
                TokenRefreshRequest request = new TokenRefreshRequest();
                request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
                TokenRefreshParam param = (TokenRefreshParam)request.getParam();
                param.setRefreshToken(companyStoreAuthorize.getRefreshToken());
                param.setGrantType("refresh_token");
                String shopId = companyStoreAuthorize.getShopId();
                TokenRefreshResponse response = (TokenRefreshResponse)request.execute(this.douDianApiUtil.getToken(shopId));
                log.debug("response is {}", (Object)JSON.toJSONString((Object)response));
                String dyShopAccessToken = "dy_shop_access_token:" + shopId;
                if (response.isSuccess()) {
                    TokenRefreshData tokenRefreshData = (TokenRefreshData)response.getData();
                    AccessTokenData data = new AccessTokenData();
                    BeanUtil.copyProperties((Object)tokenRefreshData, (Object)data, (String[])new String[0]);
                    this.redisUtil.set(dyShopAccessToken, (Object)data, tokenRefreshData.getExpiresIn().longValue());
                    companyStoreAuthorize.setAccessToken(tokenRefreshData.getAccessToken());
                    companyStoreAuthorize.setRefreshToken(tokenRefreshData.getRefreshToken());
                    companyStoreAuthorize.setLastRefreshTime(new Date());
                    this.companyStoreAuthorizeMapper.updateById(companyStoreAuthorize);
                    this.companyStoreHeadService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(CompanyStoreHead::getAuthState, (Object)CompanyStoreAuthStatusEnum.APPROVED.getValue())).eq(CompanyStoreHead::getShopId, (Object)shopId)).eq(CompanyStoreHead::getPlatform, (Object)"1"));
                }
            });
        }
        log.info("==============\u5237\u65b0\u6296\u5e97token\u7ed3\u675f================");
    }
}

