/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.entity.KsItemsCategory;
import com.els.modules.companystore.mapper.KsItemsCategoryMapper;
import com.els.modules.companystore.service.KsItemsCategoryService;
import com.els.modules.companystore.service.KsItemsService;
import com.els.modules.companystore.vo.GoodsCategoryVo;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class KsItemsCategoryServiceImpl
extends BaseServiceImpl<KsItemsCategoryMapper, KsItemsCategory>
implements KsItemsCategoryService {
    @Autowired
    private KsItemsService ksItemsService;

    @Override
    public void add(KsItemsCategory ksItemsCategory) {
        ((KsItemsCategoryMapper)this.baseMapper).insert((Object)ksItemsCategory);
    }

    @Override
    public void edit(KsItemsCategory ksItemsCategory) {
        int count = ((KsItemsCategoryMapper)this.baseMapper).updateById((Object)ksItemsCategory);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((KsItemsCategoryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((KsItemsCategoryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private void handleItemsPid(List<Tree<Integer>> treeNodes, Set<String> categoryIds) {
        HashSet p = Sets.newHashSet();
        categoryIds.forEach(id -> {
            Tree<Integer> treeNode = this.getNode(treeNodes, (String)id);
            this.getParent(treeNode, p);
        });
        categoryIds.addAll(p);
    }

    private void getParent(Tree<Integer> treeNode, Set<String> pids) {
        if (ObjectUtil.isNotEmpty((Object)treeNode.getParent())) {
            pids.add(treeNode.getParent().getId() + "");
            this.getParent((Tree<Integer>)treeNode.getParent(), pids);
        }
    }

    private Tree<Integer> getNode(List<Tree<Integer>> treeNodes, String id) {
        for (Tree<Integer> treeNode : treeNodes) {
            Tree node = treeNode.getNode((Object)Integer.valueOf(id));
            if (ObjectUtil.isNotEmpty((Object)node)) {
                System.out.println("node:" + JSON.toJSON((Object)node));
                return node;
            }
            List children = treeNode.getChildren();
            if (!CollUtil.isNotEmpty((Collection)children)) continue;
            this.getNode(children, id);
        }
        return null;
    }

    @Override
    public List<Tree<Integer>> ksCategory() {
        List ksItems = this.ksItemsService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{KsItems::getCategoryId}).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(KsItems::getCategoryId)).groupBy(KsItems::getCategoryId));
        if (CollUtil.isEmpty((Collection)ksItems)) {
            return Lists.newArrayList();
        }
        Set<String> categoryIds = ksItems.stream().map(x -> x.getCategoryId()).collect(Collectors.toSet());
        List<KsItemsCategory> dbs = this.list();
        this.handleItemsPid(this.treeNodes(dbs), categoryIds);
        dbs = dbs.stream().filter(x -> categoryIds.contains(x.getCategoryId() + "")).collect(Collectors.toList());
        return this.treeNodes(dbs);
    }

    private List<Tree<Integer>> treeNodes(List<KsItemsCategory> dbs) {
        List goodsCategoryVos = dbs.stream().map(x -> {
            GoodsCategoryVo vo = new GoodsCategoryVo();
            vo.setCategoryId(x.getCategoryId());
            vo.setParentId(x.getCategoryPid());
            vo.setTitle(x.getCategoryName());
            return vo;
        }).collect(Collectors.toList());
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setIdKey("categoryId");
        treeNodeConfig.setNameKey("title");
        treeNodeConfig.setParentIdKey("parentId");
        treeNodeConfig.setChildrenKey("children");
        List treeNodes = TreeUtil.build(goodsCategoryVos, (Object)0, (TreeNodeConfig)treeNodeConfig, (treeNode, tree) -> {
            tree.setId((Object)treeNode.getCategoryId());
            tree.setParentId((Object)treeNode.getParentId());
            tree.setName((CharSequence)treeNode.getTitle());
            tree.putExtra("id", (Object)treeNode.getCategoryId());
            tree.putExtra("description", (Object)"cascader");
            tree.putExtra("value", (Object)treeNode.getCategoryId());
        });
        return treeNodes;
    }
}

