/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.util.RedisUtil;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.entity.CompanyStoreAuthorize;
import com.els.modules.companystore.mapper.CompanyStoreAuthorizeMapper;
import java.security.Key;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;

@Component
public class DouDianApiUtil {
    private static final Logger log = LoggerFactory.getLogger(DouDianApiUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DouDianProperties douDianProperties;
    @Resource
    private CompanyStoreAuthorizeMapper companyStoreAuthorizeMapper;

    public DoudianOpConfig getDoudianOpConfig() {
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey(this.douDianProperties.getAppKey());
        doudianOpConfig.setAppSecret(this.douDianProperties.getAppSecret());
        return doudianOpConfig;
    }

    public AccessToken getToken(String shopId) {
        String dyShopAccessToken = "dy_shop_access_token:" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(dyShopAccessToken);
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return AccessToken.wrap(data.getAccessToken(), data.getRefreshToken());
        }
        CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)this.companyStoreAuthorizeMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreAuthorize::getShopId, (Object)shopId)));
        if (ObjectUtil.isEmpty((Object)((Object)companyStoreAuthorize)) || StrUtil.isBlank((CharSequence)companyStoreAuthorize.getAccessToken()) || StrUtil.isBlank((CharSequence)companyStoreAuthorize.getRefreshToken())) {
            return null;
        }
        return AccessToken.wrap(companyStoreAuthorize.getAccessToken(), companyStoreAuthorize.getRefreshToken());
    }

    public static String decrypt(String sSrc) {
        try {
            String appSecret = "1c216dd8-7cab-40fb-99cd-33d2273f68ce";
            String sKey = appSecret.replaceAll("-", "");
            byte[] raw = sKey.getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int blockSize = cipher.getBlockSize();
            IvParameterSpec iv = new IvParameterSpec(sKey.substring(0, blockSize).getBytes());
            cipher.init(2, (Key)skeySpec, iv);
            byte[] encrypted1 = new BASE64Decoder().decodeBuffer(sSrc);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original, "utf-8");
            return originalString;
        }
        catch (Exception ex) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }
}

