/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.popularize.entity.TopmanOrderCost;
import com.els.modules.popularize.entity.TopmanOrderHead;
import com.els.modules.popularize.entity.TopmanOrderItem;
import com.els.modules.popularize.enumerate.TopmanOrderStatusEnum;
import com.els.modules.popularize.service.TopmanOrderCostService;
import com.els.modules.popularize.service.TopmanOrderHeadService;
import com.els.modules.popularize.service.TopmanOrderItemService;
import com.els.modules.popularize.vo.TopmanOrderHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/popularize/topmanOrderHead"})
@Api(tags={"\u8fbe\u4eba\u8ba2\u5355\u7ba1\u7406\u5934"})
public class TopmanOrderHeadController
extends BaseController<TopmanOrderHead, TopmanOrderHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TopmanOrderHeadController.class);
    @Autowired
    private TopmanOrderHeadService topmanOrderHeadService;
    @Autowired
    private TopmanOrderItemService topmanOrderItemService;
    @Autowired
    private TopmanOrderCostService topmanOrderCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="cooperativeExtension")
    public Result<?> queryPageList(TopmanOrderHead topmanOrderHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanOrderHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        IPage pageList = this.topmanOrderHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TopmanOrderHeadVO topmanOrderHeadPage) {
        Assert.hasText((String)topmanOrderHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)topmanOrderHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        TopmanOrderHead topmanOrderHead = new TopmanOrderHead();
        BeanUtils.copyProperties((Object)((Object)topmanOrderHeadPage), (Object)((Object)topmanOrderHead));
        String elsAccount = this.getTenantId();
        topmanOrderHead.setElsAccount(elsAccount);
        topmanOrderHead.setBusAccount(elsAccount);
        TopmanOrderHeadVO headVO = this.topmanOrderHeadService.saveMain(topmanOrderHead, topmanOrderHeadPage.getTopmanOrderItemList(), topmanOrderHeadPage.getTopmanOrderCostList());
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopmanOrderHeadVO topmanOrderHeadPage) {
        this.topmanOrderHeadService.updateMain(topmanOrderHeadPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody TopmanOrderHeadVO topmanOrderHeadPage) {
        Assert.hasText((String)topmanOrderHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)topmanOrderHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.topmanOrderHeadService.validated(topmanOrderHeadPage);
        String elsAccount = this.getTenantId();
        topmanOrderHeadPage.setElsAccount(elsAccount);
        topmanOrderHeadPage.setBusAccount(elsAccount);
        this.topmanOrderHeadService.submit(topmanOrderHeadPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u4ea4\u4ed8\u5b8c\u6210-\u8ba2\u5355\u884c")
    @ApiOperation(value="\u4ea4\u4ed8\u5b8c\u6210-\u8ba2\u5355\u884c", notes="\u4ea4\u4ed8\u5b8c\u6210-\u8ba2\u5355\u884c")
    @GetMapping(value={"/finish"})
    public Result<?> finish(@RequestParam(name="ids") String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            TopmanOrderItem orderItem = (TopmanOrderItem)((Object)this.topmanOrderItemService.getById((Serializable)((Object)id)));
            ((TopmanOrderHeadService)this.service).checkRow(orderItem);
            String status = TopmanOrderStatusEnum.CONFIRMED.getValue();
            Assert.isTrue((boolean)status.equals(orderItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u8ba2\u5355\u884c\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
            ((TopmanOrderHeadService)this.service).finish(orderItem);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u5173\u95ed-\u8ba2\u5355\u884c")
    @ApiOperation(value="\u5173\u95ed-\u8ba2\u5355\u884c", notes="\u5173\u95ed-\u8ba2\u5355\u884c")
    @GetMapping(value={"/close"})
    public Result<?> close(@RequestParam(name="ids") String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            TopmanOrderItem orderItem = (TopmanOrderItem)((Object)this.topmanOrderItemService.getById((Serializable)((Object)id)));
            ((TopmanOrderHeadService)this.service).checkRow(orderItem);
            String status = TopmanOrderStatusEnum.CONFIRMED.getValue();
            Assert.isTrue((boolean)status.equals(orderItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u8ba2\u5355\u884c\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
            ((TopmanOrderHeadService)this.service).close(orderItem);
        }
        return this.commonSuccessResult(8);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u5173\u95ed-\u8ba2\u5355\u5934")
    @ApiOperation(value="\u5173\u95ed-\u8ba2\u5355\u5934", notes="\u5173\u95ed-\u8ba2\u5355\u5934")
    @GetMapping(value={"/closeAll"})
    public Result<?> closeAll(@RequestParam(name="id") String id) {
        TopmanOrderHead orderHead = (TopmanOrderHead)((Object)((TopmanOrderHeadService)this.service).getById((Serializable)((Object)id)));
        ((TopmanOrderHeadService)this.service).checkHead(orderHead);
        String status = TopmanOrderStatusEnum.PARTIAL_DELIVERY.getValue();
        Assert.isTrue((boolean)status.equals(orderHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u72b6\u6001\u4e3a\u90e8\u5206\u4ea4\u4ed8\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        ((TopmanOrderHeadService)this.service).closeAll(orderHead);
        return this.commonSuccessResult(8);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u4f5c\u5e9f-\u8ba2\u5355\u5934")
    @ApiOperation(value="\u4f5c\u5e9f-\u8ba2\u5355\u5934", notes="\u4f5c\u5e9f-\u8ba2\u5355\u5934")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        TopmanOrderHead orderHead = (TopmanOrderHead)((Object)((TopmanOrderHeadService)this.service).getById((Serializable)((Object)id)));
        ((TopmanOrderHeadService)this.service).checkHead(orderHead);
        List<String> status = Arrays.asList(TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue(), TopmanOrderStatusEnum.CONFIRMED.getValue(), TopmanOrderStatusEnum.REFUND.getValue());
        Assert.isTrue((boolean)status.contains(orderHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u72b6\u6001\u4e3a\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u3001\u5df2\u786e\u8ba4\u3001\u5df2\u62d2\u7edd\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
        ((TopmanOrderHeadService)this.service).cancel(orderHead);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topmanOrderHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u8fbe\u4eba\u8ba2\u5355", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.topmanOrderHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopmanOrderHead topmanOrderHead = (TopmanOrderHead)((Object)this.topmanOrderHeadService.getById((Serializable)((Object)id)));
        TopmanOrderHeadVO topmanOrderHeadVO = new TopmanOrderHeadVO();
        BeanUtils.copyProperties((Object)((Object)topmanOrderHead), (Object)((Object)topmanOrderHeadVO));
        List<TopmanOrderItem> topmanOrderItemList = this.topmanOrderItemService.selectByMainId(id);
        topmanOrderHeadVO.setTopmanOrderItemList(topmanOrderItemList);
        List<TopmanOrderCost> topmanOrderCostList = this.topmanOrderCostService.selectByMainId(id);
        topmanOrderHeadVO.setTopmanOrderCostList(topmanOrderCostList);
        return Result.ok((Object)((Object)topmanOrderHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u8fbe\u4eba\u8ba2\u5355\u5934id\u67e5\u8be2\u8fbe\u4eba\u8ba2\u5355\u884c", notes="\u901a\u8fc7\u8fbe\u4eba\u8ba2\u5355\u5934id\u67e5\u8be2\u8fbe\u4eba\u8ba2\u5355\u884c")
    @GetMapping(value={"/queryTopmanOrderItemByMainId"})
    public Result<?> queryTopmanOrderItemListByMainId(@RequestParam(name="id") String id) {
        List<TopmanOrderItem> topmanOrderItemList = this.topmanOrderItemService.selectByMainId(id);
        return Result.ok(topmanOrderItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u8fbe\u4eba\u8ba2\u5355\u5934id\u67e5\u8be2\u8fbe\u4eba\u8ba2\u5355\u8d39\u7528", notes="\u901a\u8fc7\u8fbe\u4eba\u8ba2\u5355\u7ba1\u7406\u5934id\u67e5\u8be2\u8fbe\u4eba\u8ba2\u5355\u8d39\u7528")
    @GetMapping(value={"/queryTopmanOrderCostByMainId"})
    public Result<?> queryTopmanOrderCostListByMainId(@RequestParam(name="id") String id) {
        List<TopmanOrderCost> topmanOrderCostList = this.topmanOrderCostService.selectByMainId(id);
        return Result.ok(topmanOrderCostList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="cooperativeExtension")
    public Result<?> queryTabsCount(TopmanOrderHead topmanOrderHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanOrderHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        queryWrapper.select(new String[]{"status", "count(0) as quantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((TopmanOrderHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(TopmanOrderHead::getStatus, TopmanOrderHead::getQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("status", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

