/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.promotional.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.companystore.entity.DyOrderItem;
import com.els.modules.companystore.entity.KsOrderBaseInfo;
import com.els.modules.companystore.service.DyOrderItemService;
import com.els.modules.companystore.service.KsOrderBaseInfoService;
import com.els.modules.promotional.entity.CommRewardRuleHead;
import com.els.modules.promotional.entity.ProCommissionHead;
import com.els.modules.promotional.entity.ProCommissionItem;
import com.els.modules.promotional.entity.PromotionalDataHead;
import com.els.modules.promotional.entity.PromotionalDataItem;
import com.els.modules.promotional.enumerate.PromoteTypeEnum;
import com.els.modules.promotional.mapper.ProCommissionHeadMapper;
import com.els.modules.promotional.service.CommRewardRuleHeadService;
import com.els.modules.promotional.service.ProCommissionHeadService;
import com.els.modules.promotional.service.ProCommissionItemService;
import com.els.modules.promotional.service.PromotionalDataHeadService;
import com.els.modules.promotional.service.PromotionalDataItemService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProCommissionHeadServiceImpl
extends BaseServiceImpl<ProCommissionHeadMapper, ProCommissionHead>
implements ProCommissionHeadService {
    @Autowired
    private CommRewardRuleHeadService commRewardRuleHeadService;
    @Autowired
    private PromotionalDataHeadService promotionalDataHeadService;
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;
    @Autowired
    private ProCommissionItemService proCommissionItemService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private DyOrderItemService dyOrderItemService;
    @Autowired
    private KsOrderBaseInfoService ksOrderBaseInfoService;

    @Override
    public void add(ProCommissionHead proCommissionHead) {
        ((ProCommissionHeadMapper)this.baseMapper).insert((Object)proCommissionHead);
    }

    @Override
    public void edit(ProCommissionHead proCommissionHead) {
        int count = ((ProCommissionHeadMapper)this.baseMapper).updateById((Object)proCommissionHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ProCommissionHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ProCommissionHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void statistics(String startTime, String endTime) {
        String elsAccount = TenantContext.getTenant();
        List<CommRewardRuleHead> commRewardRuleHeads = this.commRewardRuleHeadService.getRuleByElsAccount(elsAccount);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(commRewardRuleHeads), (String)"\u6ca1\u6709\u5df2\u53d1\u5e03\u7684\u63d0\u6210\u89c4\u5219");
        Map<String, BigDecimal> ruleMap = commRewardRuleHeads.stream().collect(Collectors.toMap(x -> x.getPromotionType(), y -> y.getCommRatio().divide(BigDecimal.valueOf(100L))));
        List<PromotionalDataHead> data = this.promotionalDataHeadService.findByTimes(startTime, endTime);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(data), (String)"\u6ca1\u6709\u53ef\u7edf\u8ba1\u7684\u63d0\u6210\u6570\u636e");
        String subaccountOrgCode = this.subaccountOrgRpcService.getSubaccountOrgCode();
        ArrayList dbHeads = Lists.newArrayList();
        for (PromotionalDataHead row : data) {
            BigDecimal mechanismRate;
            BigDecimal starMapRate;
            ProCommissionHead proCommissionHead = new ProCommissionHead();
            BeanUtil.copyProperties((Object)((Object)row), (Object)((Object)proCommissionHead), (String[])new String[0]);
            this.handleRemoveParams(proCommissionHead);
            proCommissionHead.setId(null);
            BigDecimal commRate = ruleMap.get(PromoteTypeEnum.COMMISSION.getCode());
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalVol = BigDecimal.ZERO;
            BigDecimal totalSales = BigDecimal.ZERO;
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getCommissionSales())) {
                totalSales = totalSales.add(proCommissionHead.getCommissionSales());
            }
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getCommissionSalesVol())) {
                totalVol = totalVol.add(proCommissionHead.getCommissionSalesVol());
            }
            if (ObjectUtil.isNotEmpty((Object)commRate)) {
                proCommissionHead.setCommissionRate(commRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setCommissionAmount(proCommissionHead.getCommissionSalesVol().multiply(commRate));
                totalAmount = totalAmount.add(proCommissionHead.getCommissionAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getStarMapSales())) {
                totalSales = totalSales.add(proCommissionHead.getStarMapSales());
            }
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getStarMapSalesVol())) {
                totalVol = totalVol.add(proCommissionHead.getStarMapSalesVol());
            }
            if (ObjectUtil.isNotEmpty((Object)(starMapRate = ruleMap.get(PromoteTypeEnum.STAR_MAP.getCode()))) && ObjectUtil.isNotEmpty((Object)proCommissionHead.getStarMapSalesVol())) {
                proCommissionHead.setStarMapRate(starMapRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setStarMapAmount(proCommissionHead.getStarMapSalesVol().multiply(starMapRate));
                totalAmount = totalAmount.add(proCommissionHead.getStarMapAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getOrgSales())) {
                totalSales = totalSales.add(proCommissionHead.getOrgSales());
            }
            if (ObjectUtil.isNotEmpty((Object)proCommissionHead.getOrgSalesVol())) {
                totalVol = totalVol.add(proCommissionHead.getOrgSalesVol());
            }
            if (ObjectUtil.isNotEmpty((Object)(mechanismRate = ruleMap.get(PromoteTypeEnum.MECHANISM.getCode()))) && ObjectUtil.isNotEmpty((Object)proCommissionHead.getOrgSalesVol())) {
                proCommissionHead.setOrgRate(mechanismRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setOrgAmount(proCommissionHead.getOrgSalesVol().multiply(mechanismRate));
                totalAmount = totalAmount.add(proCommissionHead.getOrgAmount());
            }
            totalSales = totalSales.add(Optional.ofNullable(proCommissionHead.getProAllianceSales()).orElse(BigDecimal.ZERO));
            totalVol = totalVol.add(Optional.ofNullable(proCommissionHead.getProAllianceSalesVol()).orElse(BigDecimal.ZERO));
            BigDecimal proAllianceRate = ruleMap.get(PromoteTypeEnum.PRO_ALLIANCE.getCode());
            if (ObjectUtil.isNotEmpty((Object)proAllianceRate) && ObjectUtil.isNotEmpty((Object)proCommissionHead.getProAllianceSalesVol())) {
                proCommissionHead.setProAllianceRate(proAllianceRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setProAllianceAmount(Optional.ofNullable(proCommissionHead.getProAllianceSalesVol()).orElse(BigDecimal.ZERO).multiply(proAllianceRate));
                totalAmount = totalAmount.add(proCommissionHead.getProAllianceAmount());
            }
            proCommissionHead.setTotalSales(totalSales);
            proCommissionHead.setTotalAmount(totalAmount);
            proCommissionHead.setTotalVol(totalVol);
            proCommissionHead.setId(IdWorker.getIdStr());
            proCommissionHead.setCompany(subaccountOrgCode);
            dbHeads.add(proCommissionHead);
            this.handleItemData(row, ruleMap, proCommissionHead.getId());
        }
        if (CollUtil.isNotEmpty((Collection)dbHeads)) {
            this.saveBatch(dbHeads);
        }
    }

    private void handleItemData(PromotionalDataHead headDb, Map<String, BigDecimal> ruleMap, String headId) {
        ArrayList adds = Lists.newArrayList();
        List<PromotionalDataItem> itemDatas = this.promotionalDataItemService.listByHeadId(headDb.getId());
        if (CollUtil.isEmpty(itemDatas)) {
            return;
        }
        for (PromotionalDataItem itemData : itemDatas) {
            ProCommissionItem proCommissionItem = new ProCommissionItem();
            BeanUtil.copyProperties((Object)((Object)itemData), (Object)((Object)proCommissionItem), (String[])new String[0]);
            proCommissionItem.setId(null);
            proCommissionItem.setHeadId(headId);
            PromoteTypeEnum promoteType = PromoteTypeEnum.getPromoteTypeEnumByCode(proCommissionItem.getPromotionType());
            BigDecimal rate = ruleMap.get(promoteType.getCode());
            if (ObjectUtil.isNotNull((Object)rate)) {
                proCommissionItem.setOrderRate(rate.multiply(BigDecimal.valueOf(100L)));
                proCommissionItem.setOrderAmount(proCommissionItem.getOrderVal().multiply(rate));
                this.handleThirdOrder(proCommissionItem, headDb.getSubAccount());
            }
            adds.add(proCommissionItem);
        }
        this.proCommissionItemService.saveBatch(adds);
    }

    private void handleThirdOrder(ProCommissionItem proCommissionItem, String admin) {
        List baseInfos;
        List dyOrderItems;
        if ("1".equals(proCommissionItem.getPlatform()) && CollUtil.isNotEmpty((Collection)(dyOrderItems = this.dyOrderItemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DyOrderItem::getOrderId, (Object)proCommissionItem.getOrderNo())).eq(BaseEntity::getElsAccount, (Object)proCommissionItem.getElsAccount()))))) {
            for (DyOrderItem dyOrderItem : dyOrderItems) {
                dyOrderItem.setAdmin(admin);
                dyOrderItem.setCommAmount(proCommissionItem.getOrderAmount());
                dyOrderItem.setCommRate(proCommissionItem.getOrderAmount());
                dyOrderItem.setCountTime(new Date());
            }
            this.dyOrderItemService.updateBatchById(dyOrderItems);
        }
        if ("2".equals(proCommissionItem.getPlatform()) && CollUtil.isNotEmpty((Collection)(baseInfos = this.ksOrderBaseInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(KsOrderBaseInfo::getOid, (Object)proCommissionItem.getOrderNo())).eq(BaseEntity::getElsAccount, (Object)proCommissionItem.getElsAccount()))))) {
            for (KsOrderBaseInfo baseInfo : baseInfos) {
                baseInfo.setAdmin(admin);
                baseInfo.setCommAmount(proCommissionItem.getOrderAmount());
                baseInfo.setCommRate(proCommissionItem.getOrderAmount());
                baseInfo.setCountTime(new Date());
            }
            this.ksOrderBaseInfoService.updateBatchById(baseInfos);
        }
    }

    private void handleRemoveParams(ProCommissionHead proCommissionHead) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_account", (Object)proCommissionHead.getSubAccount());
        queryWrapper.eq((Object)"count_year", (Object)proCommissionHead.getCountYear());
        queryWrapper.eq((Object)"count_month", (Object)proCommissionHead.getCountMonth());
        queryWrapper.select(new String[]{"id"});
        List dbs = this.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dbs)) {
            return;
        }
        List headIds = dbs.stream().map(x -> x.getId()).collect(Collectors.toList());
        this.removeByIds(headIds);
        this.proCommissionItemService.remove((Wrapper)Wrappers.lambdaQuery().in(ProCommissionItem::getHeadId, headIds));
    }
}

