/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.DoudianOpSpiBizHandler;
import com.doudian.open.core.DoudianOpSpiContext;
import com.doudian.open.core.DoudianOpSpiParam;
import com.doudian.open.core.DoudianOpSpiResponse;
import com.doudian.open.core.GlobalConfig;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.CommonUtil;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.utils.ReflectUtil;
import com.doudian.open.utils.SignUtil;
import com.doudian.open.utils.StringUtil;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public abstract class DoudianOpSpiRequest<P> {
    private DoudianOpSpiParam spiParam = DoudianOpSpiParam.build();
    private DoudianOpConfig config = GlobalConfig.getGlobalConfig();
    private DoudianOpSpiBizHandler bizHandler;

    public void registerHandler(DoudianOpSpiBizHandler bizHandler) {
        this.bizHandler = bizHandler;
    }

    public <T> T execute() {
        return this.execute(this.bizHandler);
    }

    public String responseJson() {
        return JsonUtil.toJson(this.execute());
    }

    protected void initWithConfig(Object config) {
        if (config == null) {
            return;
        }
        if (config instanceof HttpServletRequest) {
            this.initWithHttpServletRequest((HttpServletRequest)config);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initWithHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.spiParam.setSign(httpServletRequest.getParameter("sign"));
        this.spiParam.setSignV2(httpServletRequest.getParameter("sign_v2"));
        this.spiParam.setAppKey(httpServletRequest.getParameter("app_key"));
        this.spiParam.setTimestamp(httpServletRequest.getParameter("timestamp"));
        this.spiParam.setSignMethod(httpServletRequest.getParameter("sign_method"));
        String httpMethod = httpServletRequest.getMethod();
        String paramJson = null;
        if ("GET".equals(httpMethod)) {
            paramJson = httpServletRequest.getParameter("param_json");
        } else {
            if (!"POST".equals(httpMethod)) throw new DoudianOpException(DoudianOpException.Code.UNSUPPORTED_HTTP_METHOD, httpMethod);
            try {
                ServletInputStream inputStream = httpServletRequest.getInputStream();
                if (inputStream != null) {
                    paramJson = CommonUtil.readAllFromInputStream((InputStream)inputStream);
                }
            }
            catch (Exception e) {
                throw new DoudianOpException(e);
            }
        }
        this.spiParam.setParamJson(paramJson);
    }

    public <T> T execute(DoudianOpSpiBizHandler spiBizHandler) {
        if (StringUtil.isEmpty(this.config.getAppKey()) || StringUtil.isEmpty(this.config.getAppSecret())) {
            throw new DoudianOpException(DoudianOpException.Code.PARAMETER_CHECK_ERROR, "\u672a\u521d\u59cb\u5316app_key\u6216app_secret, \u8bf7\u4ed4\u7ec6\u68c0\u67e5\u4f7f\u7528demo");
        }
        if (!this.config.getAppKey().equals(this.spiParam.getAppKey())) {
            throw new DoudianOpException(DoudianOpException.Code.PARAMETER_CHECK_ERROR, "\u76ee\u6807app_key\u548c\u672c\u5730app_key\u4e0d\u5339\u914d");
        }
        DoudianOpSpiContext context = new DoudianOpSpiContext();
        DoudianOpSpiResponse<?> response = ReflectUtil.newObject(this.getResponseClass());
        Class<?> dataClass = this.getSuperClassParameterClasses(response.getClass());
        Object dataObject = ReflectUtil.newObject(dataClass);
        context.setRequest(this);
        response.setData(dataObject);
        context.setResponse(response);
        String appKey = this.config.getAppKey();
        String appSecret = this.config.getAppSecret();
        String timestamp = CommonUtil.getOrDefault(this.spiParam.getTimestamp(), "");
        String paramJson = CommonUtil.getOrDefault(this.spiParam.getParamJson(), "");
        Integer signMethod = this.spiParam.getSignMethod() != null && this.spiParam.getSignMethod().equals("hmac-sha256") ? 2 : 1;
        String calsSign = SignUtil.spiSign(appKey, appSecret, timestamp, paramJson, signMethod);
        if (calsSign == null || !calsSign.equals(this.spiParam.getSign()) && !calsSign.equals(this.spiParam.getSignV2())) {
            response.setCode(100001L);
            return (T)response;
        }
        Object paramObject = JsonUtil.fromJson(this.spiParam.getParamJson(), this.getSuperClassParameterClasses(this.getClass()));
        context.setParam(paramObject);
        spiBizHandler.handle(context);
        return (T)response;
    }

    public abstract Class<? extends DoudianOpSpiResponse<?>> getResponseClass();

    public void setSpiParam(DoudianOpSpiParam spiParam) {
        this.spiParam = spiParam;
    }

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public DoudianOpSpiParam getParam() {
        return this.spiParam;
    }

    private Class<?> getSuperClassParameterClasses(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }
}

