/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.alliance.entity.MyExpenditureDataItem;
import com.els.modules.alliance.entity.MyExpenditureHead;
import com.els.modules.alliance.enumerate.MyExpenditurePayStatusEnum;
import com.els.modules.alliance.enumerate.MyPromotionTypeEnum;
import com.els.modules.alliance.mapper.MyExpenditureHeadMapper;
import com.els.modules.alliance.service.MyExpenditureHeadService;
import com.els.modules.alliance.vo.MyExpenditureHeadVO;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyExpenditureHeadServiceImpl
extends BaseServiceImpl<MyExpenditureHeadMapper, MyExpenditureHead>
implements MyExpenditureHeadService {
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public List<CountVO> queryTabsCount(MyExpenditureHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        LoginUser loginUser = SysUtil.getLoginUser();
        List<MyExpenditureHead> list = this.listByElsAccount(head, req, loginUser.getElsAccount());
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "tab", "", Integer.valueOf(list.size())));
        int total = 0;
        if (CollectionUtil.isNotEmpty(list)) {
            total = (int)list.stream().filter(h -> loginUser.getSubAccount().equals(h.getSubAccount())).count();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_my_expenditure", (String)"\u6211\u7684\u652f\u51fa"), "tab", "3", Integer.valueOf(total)));
        return result;
    }

    private List<MyExpenditureHead> listByElsAccount(MyExpenditureHead head, HttpServletRequest req, String elsAccount) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        return ((MyExpenditureHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void updateExpenditure() {
        ArrayList<MyExpenditureHead> headList = new ArrayList<MyExpenditureHead>();
        LoginUser loginUser = SysUtil.getLoginUser();
        List<MyExpenditureDataItem> itemList = ((MyExpenditureHeadMapper)this.baseMapper).getPromotionalDataItem(loginUser.getElsAccount(), loginUser.getSubAccount(), null);
        if (CollectionUtil.isEmpty(itemList)) {
            return;
        }
        Map<String, List<MyExpenditureDataItem>> map = itemList.stream().collect(Collectors.groupingBy(MyExpenditureDataItem::getSpreaderElsAccount));
        if (map.isEmpty()) {
            return;
        }
        String subaccountOrgCode = this.subaccountOrgRpcService.getSubaccountOrgCode();
        for (Map.Entry<String, List<MyExpenditureDataItem>> entry : map.entrySet()) {
            List<MyExpenditureDataItem> value = entry.getValue();
            MyExpenditureDataItem item = value.get(0);
            MyExpenditureHead head = this.selectMyExpenditureHead(loginUser.getElsAccount(), item.getSpreaderElsAccount(), item.getGoodsId());
            if (head == null) {
                head = new MyExpenditureHead();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)item.getElsAccount());
                queryWrapper.eq((Object)"business_type", (Object)"myExpenditure");
                queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
                List list = this.templateHeadService.list((Wrapper)queryWrapper);
                if (list.isEmpty()) {
                    queryWrapper.clear();
                    queryWrapper.eq((Object)"els_account", (Object)"100000");
                    queryWrapper.eq((Object)"business_type", (Object)"myExpenditure");
                    queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
                    list = this.templateHeadService.list((Wrapper)queryWrapper);
                }
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    TemplateHead templateHead = (TemplateHead)list.get(0);
                    head.setTemplateNumber(templateHead.getTemplateNumber());
                    head.setTemplateName(templateHead.getTemplateName());
                    head.setTemplateVersion(templateHead.getTemplateVersion());
                    head.setTemplateAccount(templateHead.getElsAccount());
                }
            }
            head.setElsAccount(loginUser.getElsAccount());
            head.setSubAccount(loginUser.getSubAccount());
            head.setSpreaderElsAccount(item.getSpreaderElsAccount());
            head.setCompanyName(item.getCompanyName());
            head.setSpreaderSubAccount(item.getSpreaderSubAccount());
            head.setSpreaderName(item.getSpreaderName());
            head.setFbk1(item.getGoodsId());
            head.setCompany(subaccountOrgCode);
            value.forEach(h -> {
                if (MyPromotionTypeEnum.COMMISSION.getValue().equals(h.getPromotionType())) {
                    h.setServerRate(h.getCommissionServerRate());
                } else if (MyPromotionTypeEnum.STAR_MAP.getValue().equals(h.getPromotionType())) {
                    h.setServerRate(h.getXingtuServerRate());
                } else if (MyPromotionTypeEnum.MECHANISM.getValue().equals(h.getPromotionType())) {
                    h.setServerRate(h.getOrganizationServerRate());
                } else {
                    h.setServerRate(BigDecimal.ZERO);
                }
                BigDecimal serverRate = h.getServerRate().divide(new BigDecimal(100), 2, 4);
                h.setServiceCharge(h.getPromotionPrice().multiply(h.getOrderQty() != null ? new BigDecimal(h.getOrderQty()) : BigDecimal.ZERO).multiply(serverRate));
            });
            BigDecimal orderAmount = value.stream().filter(h -> h.getServiceCharge() != null && h.getServiceCharge().compareTo(BigDecimal.ZERO) > 0).map(MyExpenditureDataItem::getServiceCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal unpaidServiceCharge = value.stream().filter(h -> MyExpenditurePayStatusEnum.UNPAID.getValue().equals(h.getProAlliancePayStatus()) && h.getServiceCharge() != null && h.getServiceCharge().compareTo(BigDecimal.ZERO) > 0).map(MyExpenditureDataItem::getServiceCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (unpaidServiceCharge.compareTo(BigDecimal.ZERO) > 0) {
                head.setOrderAmount(orderAmount);
                head.setPaidServiceCharge(orderAmount.subtract(unpaidServiceCharge));
                head.setUnpaidServiceCharge(unpaidServiceCharge);
                head.setPayStatus(MyExpenditurePayStatusEnum.UNPAID.getValue());
            } else {
                head.setOrderAmount(orderAmount);
                head.setPaidServiceCharge(orderAmount.subtract(unpaidServiceCharge));
                head.setUnpaidServiceCharge(unpaidServiceCharge);
                head.setPayStatus(MyExpenditurePayStatusEnum.PAID.getValue());
            }
            headList.add(head);
        }
        this.saveOrUpdateBatch(headList);
    }

    private MyExpenditureHead selectMyExpenditureHead(String elsAccount, String spreaderElsAccount, String goodsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.eq(MyExpenditureHead::getSpreaderElsAccount, (Object)spreaderElsAccount);
        queryWrapper.eq(MyExpenditureHead::getFbk1, (Object)goodsId);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        return (MyExpenditureHead)((Object)((MyExpenditureHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public void confirmExpenditure(String id) {
        this.confirmCheck(id);
        MyExpenditureHead myExpenditureHead = (MyExpenditureHead)((Object)((MyExpenditureHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        myExpenditureHead.setPaidServiceCharge(myExpenditureHead.getPaidServiceCharge().add(myExpenditureHead.getUnpaidServiceCharge()));
        myExpenditureHead.setUnpaidServiceCharge(BigDecimal.ZERO);
        myExpenditureHead.setPayStatus(MyExpenditurePayStatusEnum.PAID.getValue());
        ((MyExpenditureHeadMapper)this.baseMapper).updateById((Object)myExpenditureHead);
        List<MyExpenditureDataItem> list = ((MyExpenditureHeadMapper)this.baseMapper).getPromotionalDataItem(myExpenditureHead.getElsAccount(), myExpenditureHead.getSubAccount(), myExpenditureHead.getSpreaderElsAccount());
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> ids = list.stream().filter(h -> MyExpenditurePayStatusEnum.UNPAID.getValue().equals(h.getProAlliancePayStatus())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
            ((MyExpenditureHeadMapper)this.baseMapper).updateMyExpenditureDataItemByIds(ids);
        }
    }

    @Override
    public MyExpenditureHeadVO getDetails(String id) {
        MyExpenditureHead myExpenditureHead = (MyExpenditureHead)((Object)((MyExpenditureHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        MyExpenditureHeadVO vo = new MyExpenditureHeadVO();
        if (myExpenditureHead == null) {
            return vo;
        }
        BeanUtils.copyProperties((Object)((Object)myExpenditureHead), (Object)((Object)vo));
        List<MyExpenditureDataItem> promotionalDataItemList = ((MyExpenditureHeadMapper)this.baseMapper).getPromotionalDataItem(myExpenditureHead.getElsAccount(), myExpenditureHead.getSubAccount(), myExpenditureHead.getSpreaderElsAccount());
        promotionalDataItemList.forEach(h -> {
            if (MyPromotionTypeEnum.COMMISSION.getValue().equals(h.getPromotionType())) {
                h.setServerRate(h.getCommissionServerRate());
            } else if (MyPromotionTypeEnum.STAR_MAP.getValue().equals(h.getPromotionType())) {
                h.setServerRate(h.getXingtuServerRate());
            } else if (MyPromotionTypeEnum.MECHANISM.getValue().equals(h.getPromotionType())) {
                h.setServerRate(h.getOrganizationServerRate());
            } else {
                h.setServerRate(BigDecimal.ZERO);
            }
            BigDecimal serverRate = h.getServerRate().divide(new BigDecimal(100), 2, 4);
            h.setServiceCharge(h.getPromotionPrice().multiply(h.getOrderQty() != null ? new BigDecimal(h.getOrderQty()) : BigDecimal.ZERO).multiply(serverRate));
        });
        List<MyExpenditureDataItem> finalPromotionalDataItemList = promotionalDataItemList.stream().filter(h -> MyExpenditurePayStatusEnum.PAID.getValue().equals(h.getProAlliancePayStatus())).collect(Collectors.toList());
        vo.setPromotionalDataItemList(finalPromotionalDataItemList);
        List<MyExpenditureDataItem> unpaidPromotionalDataItemList = promotionalDataItemList.stream().filter(h -> MyExpenditurePayStatusEnum.UNPAID.getValue().equals(h.getProAlliancePayStatus())).collect(Collectors.toList());
        vo.setUnpaidPromotionalDataItemList(unpaidPromotionalDataItemList);
        return vo;
    }

    private void confirmCheck(String id) {
        MyExpenditureHead head = (MyExpenditureHead)((Object)((MyExpenditureHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u5934\u6570\u636eID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (head.getUnpaidServiceCharge().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException("\u672a\u652f\u4ed8\u91d1\u989d\u5927\u4e8e0\u65f6\u624d\u53ef\u64cd\u4f5c");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u6570\u636eID" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }
}

