/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.adapter.msg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.modules.companystore.adapter.msg.IKsMessageAdapter;
import com.els.modules.companystore.entity.KsItems;
import com.els.modules.companystore.service.KsItemsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"kwaishop_item_priceChange"})
public class ItemsFeeChangeAdapter
implements IKsMessageAdapter {
    private static final Logger log = LoggerFactory.getLogger(ItemsFeeChangeAdapter.class);
    @Autowired
    private KsItemsService ksItemsService;

    @Override
    public void accept(String info, String shopId) {
        log.info("\u5904\u7406\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1:{}", (Object)info);
        JSONObject jsonObject = JSON.parseObject((String)info);
        float price = jsonObject.getFloat("price").floatValue();
        float beforePrice = jsonObject.getFloat("beforePrice").floatValue();
        double priceF = Math.floor(price * 100.0f);
        double beforePriceF = Math.floor(beforePrice * 100.0f);
        String itemId = jsonObject.getString("itemId");
        this.ksItemsService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(KsItems::getPrice, (Object)priceF)).eq(KsItems::getPrice, (Object)beforePriceF)).eq(KsItems::getKwaiItemId, (Object)itemId));
    }
}

