/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.popularize.entity.PopularizeProjectHead;
import com.els.modules.popularize.enumerate.PopularizeStatusEnum;
import com.els.modules.popularize.mapper.PopularizeProjectItemMapper;
import com.els.modules.popularize.service.PopularizeProjectHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PopularizeProjectManagerCallBackImpl
implements AuditOptCallBackService {
    @Autowired
    private PopularizeProjectHeadService popularizeProjectHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PopularizeProjectItemMapper popularizeProjectItemMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PopularizeProjectHead head = new PopularizeProjectHead();
        String businessId = inputParamVO.getBusinessId();
        head.setId(businessId);
        String auditStatus = outputParamVO.getAuditStatus();
        head.setAuditStatus(auditStatus);
        head.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            head.setPopularizeStatus(PopularizeStatusEnum.DOING.getValue());
            this.popularizeProjectItemMapper.updateBase(businessId);
        }
        this.popularizeProjectHeadService.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PopularizeProjectHead head = (PopularizeProjectHead)((Object)this.popularizeProjectHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

