/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.alliance.dto.H5DTO;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsImg;
import com.els.modules.alliance.service.GoodsLabelitemService;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsImgService;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.assertj.core.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9009\u54c1\u5e7f\u573a"})
@RestController
@RequestMapping(value={"/alliance/goodsSquare"})
public class GoodsSquareController
extends BaseController<GoodsSquare, GoodsSquareService> {
    private static final Logger log = LoggerFactory.getLogger(GoodsSquareController.class);
    @Autowired
    private GoodsSquareService goodsSquareService;
    @Autowired
    private MyGoodsImgService imgService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private DictService dictService;
    @Autowired
    private GoodsLabelitemService goodsLabelitemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="promotionAlliance")
    public Result<?> queryPageList(GoodsSquare goodsSquare, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        IPage<GoodsSquare> pageList = this.goodsSquareService.queryPage(goodsSquare, pageNo, pageSize, req);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/h5/list"})
    public Result<?> h5List(GoodsSquare goodsSquare, @RequestParam(value="elsAccount") String elsAccount, @RequestParam(required=false, value="openId") String openId, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List relationIds;
        IPage<GoodsSquare> pageList = this.goodsSquareService.queryh5Page(goodsSquare, elsAccount, openId, pageNo, pageSize, req);
        if (ObjectUtil.isNotEmpty(pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords()) && CollUtil.isNotEmpty(relationIds = pageList.getRecords().stream().map(x -> x.getRelationId()).collect(Collectors.toList()))) {
            List myGoodsImgs = this.imgService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getDeleted, (Object)"0")).in(MyGoodsImg::getHeadId, relationIds));
            Map<String, MyGoodsImg> imgMap = myGoodsImgs.stream().collect(Collectors.toMap(x -> x.getHeadId(), y -> y));
            for (GoodsSquare row : pageList.getRecords()) {
                if (ObjectUtil.isNotEmpty((Object)row.getCommissionRate()) && ObjectUtil.isNotEmpty((Object)row.getGoodsPrice())) {
                    try {
                        BigDecimal goodsPrice = new BigDecimal(row.getGoodsPrice());
                        row.setPreCommission(goodsPrice.multiply(this.converCommissionRate(row.getCommissionRate()).divide(new BigDecimal(100))).setScale(2, 4));
                    }
                    catch (Exception e) {
                        log.error("\u4f63\u91d1\u6bd4\u4f8b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (!ObjectUtil.isNotEmpty((Object)row.getRelationId()) || !ObjectUtil.isNotEmpty((Object)((Object)imgMap.get(row.getRelationId())))) continue;
                MyGoodsImg img = imgMap.get(row.getRelationId());
                if (ObjectUtil.isNotEmpty((Object)img.getGoodsMainImg())) {
                    row.setGoodsMainImg(java.util.Arrays.asList(img.getGoodsMainImg().split(",")));
                }
                if (!ObjectUtil.isNotEmpty((Object)img.getGoodsImg())) continue;
                row.setGoodsImg(java.util.Arrays.asList(img.getGoodsImg().split(",")));
            }
        }
        return Result.ok(pageList);
    }

    private BigDecimal converCommissionRate(String str) {
        str = str.replaceAll("%", "");
        BigDecimal de = BigDecimal.ZERO;
        try {
            de = new BigDecimal(str);
        }
        catch (Exception e) {
            log.error("converCommissionRate error", (Throwable)e);
        }
        return de;
    }

    @GetMapping(value={"/h5/queryById"})
    public Result<?> h5QueryById(@RequestParam(value="id") String id) {
        String[] ids;
        List goodsLabelitems;
        MyGoodsImg myGoodsImgs;
        GoodsSquare goodsSquare = (GoodsSquare)((Object)this.goodsSquareService.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)goodsSquare)), (String)"\u6b64\u5546\u54c1\u5df2\u4e0b\u67b6");
        if (ObjectUtil.isNotEmpty((Object)goodsSquare.getCommissionRate()) && ObjectUtil.isNotEmpty((Object)goodsSquare.getGoodsPrice())) {
            try {
                if (ObjectUtil.isNotEmpty((Object)goodsSquare.getCommissionRate()) && ObjectUtil.isNotEmpty((Object)goodsSquare.getGoodsPrice())) {
                    BigDecimal goodsPrice = new BigDecimal(goodsSquare.getGoodsPrice());
                    goodsSquare.setPreCommission(goodsPrice.multiply(this.converCommissionRate(goodsSquare.getCommissionRate()).divide(new BigDecimal(100))).setScale(2, 4));
                }
            }
            catch (Exception e) {
                log.error("\u4f63\u91d1\u6bd4\u4f8b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)goodsSquare.getRelationId()) && ObjectUtil.isNotEmpty((Object)((Object)(myGoodsImgs = (MyGoodsImg)((Object)this.imgService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getDeleted, (Object)"0")).eq(MyGoodsImg::getHeadId, (Object)goodsSquare.getRelationId()), false)))))) {
            if (ObjectUtil.isNotEmpty((Object)myGoodsImgs.getGoodsMainImg())) {
                goodsSquare.setGoodsMainImg(java.util.Arrays.asList(myGoodsImgs.getGoodsMainImg().split(",")));
            }
            if (ObjectUtil.isNotEmpty((Object)myGoodsImgs.getGoodsImg())) {
                goodsSquare.setGoodsImg(java.util.Arrays.asList(myGoodsImgs.getGoodsImg().split(",")));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)goodsSquare.getLabelId()) && CollUtil.isNotEmpty((Collection)(goodsLabelitems = this.goodsLabelitemService.listByIds(new ArrayList(Arrays.asList((Object)(ids = goodsSquare.getLabelId().split(",")))))))) {
            goodsSquare.setLabel(goodsLabelitems.stream().map(x -> x.getLabel()).collect(Collectors.joining(",")));
        }
        return Result.ok((Object)((Object)goodsSquare));
    }

    @AutoLog(value="\u9009\u54c1\u5e7f\u573a-\u6dfb\u52a0\u6211\u7684\u63a8\u5e7f")
    @ApiOperation(value="\u6dfb\u52a0\u6211\u7684\u63a8\u5e7f", notes="\u6dfb\u52a0\u6211\u7684\u63a8\u5e7f")
    @GetMapping(value={"/addSpreader"})
    public Result<?> add(@RequestParam(name="id") String id) {
        this.goodsSquareService.addSpreader(id);
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/h5/addSpreader"})
    public Result<?> h5Add(@RequestBody H5DTO.GoodsSquareDto h5DTO) {
        this.goodsSquareService.h5AddSpreader(h5DTO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876", notes="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @PostMapping(value={"/h5/topOrCancel"})
    public Result<?> h5TopOrCancel(@RequestBody H5DTO.TopDto topDto) {
        this.goodsSquareService.h5TopOrCancel(topDto);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9009\u54c1\u5e7f\u573a", value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @ApiOperation(value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876", notes="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @GetMapping(value={"/topOrCancel"})
    public Result<?> topOrCancel(@RequestParam(name="id") String id, @RequestParam(name="flag") Boolean flag) {
        this.goodsSquareService.topOrCancel(id, flag);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        String[] ids;
        List goodsLabelitems;
        GoodsSquare goodsSquare = (GoodsSquare)((Object)this.goodsSquareService.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)goodsSquare.getLabelId()) && CollUtil.isNotEmpty((Collection)(goodsLabelitems = this.goodsLabelitemService.listByIds(new ArrayList(Arrays.asList((Object)(ids = goodsSquare.getLabelId().split(",")))))))) {
            goodsSquare.setLabel(goodsLabelitems.stream().map(x -> x.getLabel()).collect(Collectors.joining(",")));
        }
        return Result.ok((Object)((Object)goodsSquare));
    }
}

