/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.entity.GoodsLabelGroup;
import com.els.modules.alliance.entity.GoodsLabelitem;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsHead;
import com.els.modules.alliance.mapper.GoodsLabelGroupMapper;
import com.els.modules.alliance.service.GoodsLabelGroupService;
import com.els.modules.alliance.service.GoodsLabelitemService;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.alliance.vo.GoodsLabelVo;
import com.els.modules.alliance.vo.GoodsQueryLabelVo;
import com.els.modules.alliance.vo.GoodsQueryVo;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GoodsLabelGroupServiceImpl
extends BaseServiceImpl<GoodsLabelGroupMapper, GoodsLabelGroup>
implements GoodsLabelGroupService {
    @Autowired
    private GoodsLabelitemService goodsLabelitemService;
    @Autowired
    private GoodsSquareService goodsSquareService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private DictService dictService;
    @Autowired
    private MyGoodsHeadService myGoodsHeadService;

    @Override
    public void add(GoodsLabelGroup goodsLabelGroup) {
        ((GoodsLabelGroupMapper)this.baseMapper).insert((Object)goodsLabelGroup);
    }

    @Override
    public void edit(GoodsLabelGroup goodsLabelGroup) {
        int count = ((GoodsLabelGroupMapper)this.baseMapper).updateById((Object)goodsLabelGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((GoodsLabelGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((GoodsLabelGroupMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveMain(GoodsLabelVo goodsLabelVo) {
        String elsAccount = TenantContext.getTenant();
        List<GoodsLabelGroup> groups = goodsLabelVo.getGroups();
        List<GoodsLabelitem> items = goodsLabelVo.getItems();
        Map<String, List<GoodsLabelitem>> itemsMap = items.stream().collect(Collectors.groupingBy(x -> x.getGroupCode()));
        Map<String, GoodsLabelGroup> groupMap = groups.stream().collect(Collectors.toMap(x -> x.getCode(), y -> y));
        LoginUser loginUser = SysUtil.getLoginUser();
        List ids = groups.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getId())).map(x -> x.getId()).collect(Collectors.toList());
        List oldGroup = Lists.newArrayList();
        if (CollUtil.isNotEmpty(ids)) {
            oldGroup = this.listByIds(ids);
        }
        Map<String, String> oldLabels = oldGroup.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getLabel()));
        List itemsIds = items.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getId())).map(x -> x.getId()).collect(Collectors.toList());
        List oldItems = Lists.newArrayList();
        List<Object> delItemsIds = Lists.newArrayList();
        if (CollUtil.isNotEmpty(itemsIds)) {
            List delGoodsLabelitem = this.goodsLabelitemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).notIn(BaseEntity::getId, itemsIds));
            if (CollUtil.isNotEmpty((Collection)delGoodsLabelitem)) {
                delItemsIds = delGoodsLabelitem.stream().map(x -> x.getId()).collect(Collectors.toList());
            }
            oldItems = this.goodsLabelitemService.listByIds(itemsIds);
        }
        Map<String, GoodsLabelitem> oldItemLabels = oldItems.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        this.goodsLabelitemService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        for (Map.Entry<String, GoodsLabelGroup> entry : groupMap.entrySet()) {
            List<GoodsLabelitem> dbItems;
            String groupCode = entry.getKey();
            GoodsLabelGroup group = entry.getValue();
            boolean updateFlag = false;
            if (StrUtil.isNotBlank((CharSequence)group.getId()) && ObjectUtil.isNotEmpty((Object)oldGroup) && ObjectUtil.isNotEmpty((Object)oldLabels.get(group.getId())) && !oldLabels.get(group.getId()).equals(group.getLabel())) {
                group.setUpdateTime(new Date());
                group.setUpdateBy(loginUser.getSubAccount());
                group.setUpdateById(loginUser.getId());
                updateFlag = true;
            }
            String headId = group.getId();
            if (StrUtil.isBlank((CharSequence)group.getId())) {
                headId = IdWorker.getIdStr();
                group.setId(headId);
            }
            if (CollUtil.isNotEmpty(dbItems = itemsMap.get(groupCode))) {
                for (GoodsLabelitem goodsLabelitem : dbItems) {
                    boolean flag;
                    goodsLabelitem.setGroupId(headId);
                    boolean bl = flag = StrUtil.isNotBlank((CharSequence)goodsLabelitem.getId()) && ObjectUtil.isNotEmpty(oldItemLabels) && ObjectUtil.isNotEmpty((Object)((Object)oldItemLabels.get(goodsLabelitem.getId()))) && !oldItemLabels.get(goodsLabelitem.getId()).getGroupId().equals(goodsLabelitem.getGroupId());
                    if (!flag && !updateFlag && (!StrUtil.isNotBlank((CharSequence)goodsLabelitem.getId()) || !ObjectUtil.isNotEmpty(oldItemLabels) || !ObjectUtil.isNotEmpty((Object)((Object)oldItemLabels.get(goodsLabelitem.getId()))) || oldItemLabels.get(goodsLabelitem.getId()).getLabel().equals(goodsLabelitem.getLabel()))) continue;
                    goodsLabelitem.setUpdateTime(new Date());
                    goodsLabelitem.setUpdateBy(loginUser.getSubAccount());
                    goodsLabelitem.setUpdateById(loginUser.getId());
                }
                this.goodsLabelitemService.saveBatch(dbItems);
                if (CollUtil.isNotEmpty((Collection)delItemsIds)) {
                    for (String string : delItemsIds) {
                        List myGoodsHeads;
                        List goodsSquares = this.goodsSquareService.list((Wrapper)Wrappers.lambdaQuery().apply("FIND_IN_SET(" + string + ",label_id)", new Object[0]));
                        if (CollUtil.isNotEmpty((Collection)goodsSquares)) {
                            for (GoodsSquare goodsSquare : goodsSquares) {
                                String labelIds = goodsSquare.getLabelId();
                                ArrayList<String> la = new ArrayList<String>(Arrays.asList(labelIds.split(",")));
                                la.remove(string);
                                if (la.size() > 0) {
                                    goodsSquare.setLabelId(la.stream().collect(Collectors.joining(",")));
                                } else {
                                    goodsSquare.setLabelId(null);
                                    goodsSquare.setLabel(null);
                                }
                                this.goodsSquareService.updateById((Object)goodsSquare);
                            }
                        }
                        if (!CollUtil.isNotEmpty((Collection)(myGoodsHeads = this.myGoodsHeadService.list((Wrapper)Wrappers.lambdaQuery().apply("FIND_IN_SET(" + string + ",label_id)", new Object[0]))))) continue;
                        for (MyGoodsHead myGoodsHead : myGoodsHeads) {
                            String labelIds = myGoodsHead.getLabelId();
                            ArrayList<String> la = new ArrayList<String>(Arrays.asList(labelIds.split(",")));
                            la.remove(string);
                            if (la.size() > 0) {
                                myGoodsHead.setLabelId(la.stream().collect(Collectors.joining(",")));
                            } else {
                                myGoodsHead.setLabelId(null);
                            }
                            this.myGoodsHeadService.updateById((Object)myGoodsHead);
                        }
                    }
                }
            }
            this.save((Object)group);
        }
    }

    @Override
    public GoodsLabelVo getByElsAccount() {
        GoodsLabelVo goodsLabelVo = new GoodsLabelVo();
        goodsLabelVo.setGroups(this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).orderByAsc(GoodsLabelGroup::getSortNum)));
        goodsLabelVo.setItems(this.goodsLabelitemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).orderByAsc(GoodsLabelitem::getSortNum)));
        return goodsLabelVo;
    }

    @Override
    public GoodsQueryVo getQueryConfig(String elsAccount) {
        GoodsQueryVo goodsQueryVo = new GoodsQueryVo();
        List goodsSquares = this.goodsSquareService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{GoodsSquare::getLabelId, GoodsSquare::getBrandName}).eq(BaseEntity::getElsAccount, (Object)elsAccount)).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.isNotNull(GoodsSquare::getLabelId);
        })).or(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.isNotNull(GoodsSquare::getLabelId);
        }));
        List<String> labelIds = goodsSquares.stream().map(x -> x.getLabelId()).collect(Collectors.toList());
        List brandIds = goodsSquares.stream().map(x -> x.getBrandName()).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(brandIds)) {
            Dict dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDictCode, (Object)"brand")).eq(Dict::getElsAccount, (Object)elsAccount), false);
            if (ObjectUtil.isEmpty((Object)dict)) {
                dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDictCode, (Object)"brand")).eq(Dict::getElsAccount, (Object)"100000"), false);
            }
            if (ObjectUtil.isNotEmpty((Object)dict)) {
                List dictItems = this.dictItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictItem::getDictId, (Object)dict.getId())).in(DictItem::getItemValue, brandIds)).orderByAsc(DictItem::getSortOrder));
                goodsQueryVo.setBrand(dictItems.stream().map(m -> {
                    Pair pair = new Pair((Object)m.getItemValue(), (Object)m.getItemText());
                    return pair;
                }).collect(Collectors.toList()));
            }
        }
        if (CollUtil.isNotEmpty(labelIds)) {
            HashSet li = Sets.newHashSet();
            labelIds.forEach(id -> {
                String[] i;
                for (String s : i = id.split(",")) {
                    li.add(s);
                }
            });
            List groupItems = this.goodsLabelitemService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, (Collection)li));
            ArrayList label = Lists.newArrayList();
            List groupIds = groupItems.stream().map(x -> x.getGroupId()).distinct().collect(Collectors.toList());
            List groups = this.listByIds(groupIds);
            groups = groups.stream().sorted(Comparator.comparing(GoodsLabelGroup::getSortNum)).collect(Collectors.toList());
            Map<String, List<GoodsLabelitem>> itemMap = groupItems.stream().collect(Collectors.groupingBy(x -> x.getGroupId()));
            for (GoodsLabelGroup group : groups) {
                GoodsQueryLabelVo goodsQueryLabelVo = new GoodsQueryLabelVo();
                goodsQueryLabelVo.setKey(group.getId());
                goodsQueryLabelVo.setValue(group.getLabel());
                if (CollUtil.isNotEmpty((Collection)itemMap.get(group.getId()))) {
                    goodsQueryLabelVo.setItems(itemMap.get(group.getId()).stream().map(x -> new Pair((Object)x.getId(), (Object)x.getLabel())).collect(Collectors.toList()));
                }
                label.add(goodsQueryLabelVo);
            }
            goodsQueryVo.setLabel(label);
        }
        return goodsQueryVo;
    }
}

