/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsHead;
import com.els.modules.alliance.entity.MyGoodsImg;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTop;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.enumerate.MyGoodsSpreaderItemStatusEnum;
import com.els.modules.alliance.enumerate.MyGoodsStatusEnum;
import com.els.modules.alliance.mapper.MyGoodsHeadMapper;
import com.els.modules.alliance.mapper.MyGoodsSpreaderItemMapper;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.alliance.service.MyGoodsImgService;
import com.els.modules.alliance.service.MyGoodsTopService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.alliance.vo.ContactsVo;
import com.els.modules.alliance.vo.MyGoodsHeadVO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.GoodsContactConfig;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.DyItemsService;
import com.els.modules.companystore.service.GoodsContactConfigService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MyGoodsHeadServiceImpl
extends BaseServiceImpl<MyGoodsHeadMapper, MyGoodsHead>
implements MyGoodsHeadService {
    @Autowired
    private MyGoodsHeadMapper myGoodsHeadMapper;
    @Autowired
    private MyGoodsSpreaderItemMapper myGoodsSpreaderItemMapper;
    @Autowired
    private GoodsSquareService goodsSquareService;
    @Autowired
    private MyGoodsTopService myGoodsTopService;
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private MyGoodsImgService imgService;
    @Autowired
    @Lazy
    private DyItemsService dyItemsService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private GoodsContactConfigService goodsContactConfigService;

    @Override
    public IPage<MyGoodsHead> queryPage(MyGoodsHead myGoodsHead, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.remove("column");
        parameterMap.remove("order");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)myGoodsHead), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String tab = "";
        String[] tabs = (String[])parameterMap.get("tab");
        if (tabs != null && tabs.length > 0) {
            tab = tabs[0];
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)tab)) {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        } else {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        }
        queryWrapper.orderByDesc((Object)"flag");
        queryWrapper.orderByAsc((Object)"ISNULL(sort_num)");
        queryWrapper.orderByAsc((Object)"sort_num");
        queryWrapper.orderByDesc((Object)"update_time");
        return ((MyGoodsHeadMapper)this.baseMapper).queryPage((Page<MyGoodsHead>)page, (QueryWrapper<MyGoodsHead>)queryWrapper, loginUser.getElsAccount(), loginUser.getSubAccount());
    }

    @Override
    public List<CountVO> queryTabsCount(MyGoodsHead myGoodsHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        LoginUser loginUser = SysUtil.getLoginUser();
        List<MyGoodsHead> list = this.listByElsAccount(myGoodsHead, req, loginUser.getElsAccount());
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "tab", "", Integer.valueOf(list.size())));
        int total = 0;
        if (CollectionUtil.isNotEmpty(list)) {
            total = (int)list.stream().filter(h -> loginUser.getSubAccount().equals(h.getSubAccount())).count();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_my_goods", (String)"\u6211\u7684\u5546\u54c1"), "tab", "1", Integer.valueOf(total)));
        return result;
    }

    private List<MyGoodsHead> listByElsAccount(MyGoodsHead myGoodsHead, HttpServletRequest req, String elsAccount) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)myGoodsHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        return ((MyGoodsHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public MyGoodsHead saveMain(MyGoodsHeadVO headVO) {
        this.saveCheck(headVO);
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        LoginUser loginUser = SysUtil.getLoginUser();
        goodsHead.setSubAccount(loginUser.getSubAccount());
        goodsHead.setMerchantName(loginUser.getEnterpriseName());
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.NEW.getValue());
        this.goodsData(goodsHead, headVO.getGoodsId());
        this.myGoodsHeadMapper.insert((Object)goodsHead);
        if (ObjectUtil.isNotEmpty((Object)((Object)headVO.getMyGoodsImg()))) {
            MyGoodsImg img = headVO.getMyGoodsImg();
            img.setHeadId(goodsHead.getId());
            this.imgService.save((Object)img);
        }
        return goodsHead;
    }

    @Override
    public MyGoodsHead saveAndSubmit(MyGoodsHeadVO headVO) {
        long check = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MyGoodsHead::getGoodsId, (Object)headVO.getGoodsId())).eq(BaseEntity::getDeleted, (Object)"0")).eq(MyGoodsHead::getGoodsStatus, (Object)MyGoodsStatusEnum.LOADING.getValue()));
        Assert.isTrue((check == 0L ? 1 : 0) != 0, (String)(headVO.getGoodsName() + "\u5df2\u6709\u4e0a\u67b6\u6570\u636e"));
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        LoginUser loginUser = SysUtil.getLoginUser();
        goodsHead.setSubAccount(loginUser.getSubAccount());
        goodsHead.setMerchantName(loginUser.getEnterpriseName());
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.NEW.getValue());
        this.goodsData(goodsHead, headVO.getGoodsId());
        this.myGoodsHeadMapper.insert((Object)goodsHead);
        if (ObjectUtil.isNotEmpty((Object)((Object)headVO.getMyGoodsImg()))) {
            MyGoodsImg img = headVO.getMyGoodsImg();
            img.setHeadId(goodsHead.getId());
            this.imgService.save((Object)img);
        }
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.LOADING.getValue());
        ((MyGoodsHeadMapper)this.baseMapper).updateById((Object)goodsHead);
        GoodsSquare goodsSquare = new GoodsSquare();
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsSquare));
        goodsSquare.setRelationId(goodsHead.getId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)goodsSquare.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            goodsSquare.setTemplateNumber(templateHead.getTemplateNumber());
            goodsSquare.setTemplateName(templateHead.getTemplateName());
            goodsSquare.setTemplateVersion(templateHead.getTemplateVersion());
            goodsSquare.setTemplateAccount(templateHead.getElsAccount());
        }
        goodsSquare.setId("");
        goodsSquare.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
        this.goodsSquareService.save((Object)goodsSquare);
        return goodsHead;
    }

    @Override
    public MyGoodsHead copyMain(MyGoodsHeadVO headVO) {
        this.copyCheck(headVO);
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        LoginUser loginUser = SysUtil.getLoginUser();
        head.setGoodsStatus(MyGoodsStatusEnum.NEW.getValue());
        head.setSubAccount(loginUser.getSubAccount());
        head.setStartTime(null);
        head.setEndTime(null);
        head.setElsAccount(loginUser.getElsAccount()).setCreateBy(loginUser.getSubAccount()).setCreateTime(new Date()).setUpdateBy(loginUser.getSubAccount()).setUpdateTime(new Date()).setId(IdWorker.getIdStr());
        this.myGoodsHeadMapper.insert((Object)head);
        MyGoodsImg img = this.imgService.getByHeadId(headVO.getId());
        if (ObjectUtil.isNotEmpty((Object)((Object)img))) {
            img.setElsAccount(loginUser.getElsAccount()).setCreateBy(loginUser.getSubAccount()).setCreateTime(new Date()).setUpdateBy(loginUser.getSubAccount()).setUpdateTime(new Date()).setId(IdWorker.getIdStr());
            img.setHeadId(head.getId());
            this.imgService.save((Object)img);
        }
        return head;
    }

    @Override
    public MyGoodsHead updateMain(MyGoodsHeadVO headVO) {
        this.updateCheck(headVO);
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        this.goodsData(goodsHead, headVO.getGoodsId());
        this.updateById((Object)goodsHead);
        this.imgService.remove((Wrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getHeadId, (Object)headVO.getId()));
        if (ObjectUtil.isNotEmpty((Object)((Object)headVO.getMyGoodsImg()))) {
            MyGoodsImg img = headVO.getMyGoodsImg();
            img.setHeadId(goodsHead.getId());
            this.imgService.save((Object)img);
        }
        return goodsHead;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public MyGoodsHead putEdit(MyGoodsHeadVO headVO) {
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        if (StrUtil.isBlank((CharSequence)goodsHead.getLabel()) || StrUtil.isBlank((CharSequence)goodsHead.getLabelId())) {
            goodsHead.setLabel(null);
            goodsHead.setLabelId(null);
        }
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)goodsHead.getId())));
        Assert.isTrue((boolean)MyGoodsStatusEnum.LOADING.getValue().equals(head.getGoodsStatus()), (String)"\u53ea\u80fd\u7f16\u8f91\u5df2\u4e0a\u67b6\u5546\u54c1");
        this.updateById((Object)goodsHead);
        this.imgService.remove((Wrapper)Wrappers.lambdaQuery().eq(MyGoodsImg::getHeadId, (Object)headVO.getId()));
        if (ObjectUtil.isNotEmpty((Object)((Object)headVO.getMyGoodsImg()))) {
            MyGoodsImg img = headVO.getMyGoodsImg();
            img.setHeadId(goodsHead.getId());
            this.imgService.save((Object)img);
        }
        GoodsSquare goodsSquare = (GoodsSquare)((Object)this.goodsSquareService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(GoodsSquare::getRelationId, (Object)head.getId())).eq(BaseEntity::getDeleted, (Object)"0"), false));
        Assert.notNull((Object)((Object)goodsSquare), (String)"\u9009\u54c1\u5e7f\u573a\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsSquare), (String[])new String[]{"id", "templateNumber", "templateName", "relationId", "templateVersion", "templateAccount"});
        this.goodsSquareService.updateById((Object)goodsSquare);
        return goodsHead;
    }

    private void goodsData(MyGoodsHead goodsHead, String goodsId) {
        CompanyGoodsHead companyGoodsHead = this.companyGoodsHeadService.selectByGoodsId(goodsId);
        if (companyGoodsHead != null) {
            goodsHead.setTopmanNum(companyGoodsHead.getTopmanNum() != null ? companyGoodsHead.getTopmanNum() : "0");
            goodsHead.setVideosNum(companyGoodsHead.getVideosNum() != null ? companyGoodsHead.getVideosNum() : "0");
            goodsHead.setLivesNum(companyGoodsHead.getLivesNum() != null ? companyGoodsHead.getLivesNum() : "0");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(MyGoodsHeadVO headVO) {
        this.submitCheck(headVO.getId());
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.LOADING.getValue());
        ((MyGoodsHeadMapper)this.baseMapper).updateById((Object)goodsHead);
        GoodsSquare goodsSquare = new GoodsSquare();
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsSquare));
        goodsSquare.setRelationId(goodsHead.getId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)goodsSquare.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            goodsSquare.setTemplateNumber(templateHead.getTemplateNumber());
            goodsSquare.setTemplateName(templateHead.getTemplateName());
            goodsSquare.setTemplateVersion(templateHead.getTemplateVersion());
            goodsSquare.setTemplateAccount(templateHead.getElsAccount());
        }
        goodsSquare.setId("");
        this.goodsSquareService.save((Object)goodsSquare);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void soldOut(String id) {
        this.soldOutCheck(id);
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.UNLOADING.getValue());
        ((MyGoodsHeadMapper)this.baseMapper).updateById((Object)goodsHead);
        this.goodsSquareService.delMain(id);
        this.myPromotionalHeadService.soldOutByRelationId(goodsHead.getId());
        if ("1".equals(goodsHead.getPlatform())) {
            this.dyItemsService.resetAddStatus(goodsHead.getGoodsId(), goodsHead.getElsAccount());
        }
    }

    @Override
    public void topOrCancel(String id, Boolean flag) {
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsHead == null) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (flag.booleanValue()) {
            MyGoodsTop goodsTop = new MyGoodsTop();
            goodsTop.setElsAccount(loginUser.getElsAccount());
            goodsTop.setSubAccount(loginUser.getSubAccount());
            goodsTop.setHeadId(goodsHead.getId());
            goodsTop.setPlatform(goodsHead.getPlatform());
            this.myGoodsTopService.save((Object)goodsTop);
        } else {
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            this.myGoodsTopService.deleteTop(id, elsAccount, subAccount, goodsHead.getPlatform());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.deleteCheck(id);
        this.myGoodsSpreaderItemMapper.deleteByMainId(id);
        this.myGoodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmOrRefund(String id, Boolean flag) {
        this.confirmCheck(id);
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if (flag.booleanValue()) {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue());
            updateWrapper.set(MyPromotionalHead::getItemStatus, (Object)MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue());
        } else {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.REFUND.getValue());
            updateWrapper.set(MyPromotionalHead::getItemStatus, (Object)MyGoodsSpreaderItemStatusEnum.REFUND.getValue());
        }
        updateWrapper.eq(MyPromotionalHead::getRelationId, (Object)spreaderItem.getHeadId());
        this.myGoodsSpreaderItemMapper.updateById((Object)spreaderItem);
        this.myPromotionalHeadService.update((Wrapper)updateWrapper);
    }

    private List<MyGoodsHead> listByGoodsId(String goodsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MyGoodsHead::getGoodsId, (Object)goodsId);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        return ((MyGoodsHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    private void saveCheck(MyGoodsHead goodsHead) {
        List<MyGoodsHead> list = this.listByGoodsId(goodsHead.getGoodsId());
        if (CollectionUtil.isNotEmpty(list)) {
            throw new ELSBootException("\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u6570\u636e");
        }
    }

    private void copyCheck(MyGoodsHead goodsHead) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)goodsHead.getId())));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.UNLOADING.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u4e0b\u67b6\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void updateCheck(MyGoodsHead goodsHead) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)goodsHead.getId())));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void submitCheck(String id) {
        List list;
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
        Assert.hasText((String)head.getGoodsType(), (String)I18nUtil.translate((String)"i18n_alert_empty_notGoodsType", (String)"\u9009\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)head.getPlatform(), (String)I18nUtil.translate((String)"i18n_alert_empty_notPlatform", (String)"\u7535\u5546\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)head.getGoodsId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notGoodsId", (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((head.getCommissionRate() != null ? 1 : 0) != 0, (String)"\u4f63\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtil.isNotEmpty((Object)head.getStartTime()) && ObjectUtil.isNotEmpty((Object)head.getEndTime())) {
            if (head.getStartTime().getTime() < DateUtil.parse((CharSequence)new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getTime()) {
                throw new ELSBootException("\u63a8\u5e7f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
            }
            if (head.getEndTime().getTime() < head.getStartTime().getTime()) {
                throw new ELSBootException("\u63a8\u5e7f\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u63a8\u5e7f\u5f00\u59cb\u65e5\u671f");
            }
        }
        if (CollectionUtil.isNotEmpty(list = this.listByGoodsId(head.getGoodsId()).stream().filter(h -> !id.equals(h.getId()) && MyGoodsStatusEnum.LOADING.getValue().equals(h.getGoodsStatus())).collect(Collectors.toList()))) {
            for (MyGoodsHead h2 : list) {
                boolean flag = false;
                if ((head.getStartTime().after(h2.getStartTime()) || head.getStartTime().equals(h2.getStartTime())) && (head.getStartTime().before(h2.getEndTime()) || head.getStartTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if ((head.getEndTime().after(h2.getStartTime()) || head.getEndTime().equals(h2.getStartTime())) && (head.getEndTime().before(h2.getEndTime()) || head.getEndTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if ((head.getStartTime().before(h2.getStartTime()) || head.getStartTime().equals(h2.getStartTime())) && (head.getEndTime().after(h2.getEndTime()) || head.getEndTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if (!flag) continue;
                throw new ELSBootException("\u63a8\u5e7f\u65e5\u671f\u5b58\u5728\u91cd\u590d");
            }
        }
    }

    private void soldOutCheck(String id) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.LOADING.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u4e0a\u67b6\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void deleteCheck(String id) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void confirmCheck(String id) {
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        if (spreaderItem == null) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue())) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u7684\u884c\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(spreaderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u884c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void addSampleCheck(String id) {
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        if (spreaderItem == null) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue()) && !spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue())) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u6216\u4e0d\u9700\u786e\u8ba4\u7684\u884c\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(spreaderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u884c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void updateContacts(ContactsVo contacts) {
        List<String> ids = contacts.getIds();
        LoginUser user = SysUtil.getLoginUser();
        String code = this.subaccountOrgRpcService.getSubaccountOrgCode();
        GoodsContactConfig goodsContactConfig = (GoodsContactConfig)((Object)this.goodsContactConfigService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(GoodsContactConfig::getCompany, (Object)code)).eq(GoodsContactConfig::getPlatform, (Object)"1"), false));
        if (StrUtil.isNotBlank((CharSequence)code) && ObjectUtil.isEmpty((Object)((Object)goodsContactConfig))) {
            goodsContactConfig = (GoodsContactConfig)((Object)this.goodsContactConfigService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(GoodsContactConfig::getPlatform, (Object)"1"), false));
        }
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)goodsContactConfig)), (String)"\u8bf7\u5148\u5230[\u8054\u7cfb\u4eba\u7ef4\u62a4]\u914d\u7f6e\u8054\u7cfb\u4eba\u4fe1\u606f");
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(MyGoodsHead::getContactCategory, (Object)goodsContactConfig.getContactCategory())).set(MyGoodsHead::getContact, (Object)goodsContactConfig.getContact())).in(BaseEntity::getId, ids));
        this.goodsSquareService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(GoodsSquare::getContactCategory, (Object)goodsContactConfig.getContactCategory())).set(GoodsSquare::getContact, (Object)goodsContactConfig.getContact())).in(GoodsSquare::getRelationId, ids));
    }

    @Override
    public void updateSortNum(MyGoodsHead myGoodsHead) {
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(MyGoodsHead::getSortNum, (Object)myGoodsHead.getSortNum())).eq(BaseEntity::getId, (Object)myGoodsHead.getId()));
        this.goodsSquareService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(GoodsSquare::getSortNum, (Object)myGoodsHead.getSortNum())).eq(GoodsSquare::getRelationId, (Object)myGoodsHead.getId()));
    }
}

