/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="companyStoreHeadExportServiceImpl")
public class CompanyStoreHeadExportServiceImpl
extends BaseExportService<CompanyStoreHead, CompanyStoreHead, CompanyStoreHead> {
    @Autowired
    private CompanyStoreHeadService storeHeadService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;

    public List<CompanyStoreHead> queryExportData(QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHead param, Map<String, String[]> paramMap) {
        String[] KsAuthStatus;
        String[] var;
        String[] KsItemsNum;
        String[] var2;
        String[] KsSales;
        String[] var3;
        String[] KsTopManNum;
        String[] params = paramMap.get("param");
        String[] storeExperienceNums = paramMap.get("storeExperienceNum");
        String[] KsShopType = paramMap.get("KsShopType");
        String[] storeTopmanNums = paramMap.get("storeTopmanNum");
        String[] storeVideosNums = paramMap.get("storeVideosNum");
        String[] storeSalesAmounts = paramMap.get("storeSalesAmount");
        String[] goodsLives = paramMap.get("goodsLive");
        String[] goodsVideos = paramMap.get("goodsVideo");
        String[] timeSelects = paramMap.get("timeSelect");
        CompanyStoreHeadQueryDTO queryDTO = new CompanyStoreHeadQueryDTO();
        queryDTO.setDataType(param.getDataType());
        queryDTO.setPlatform(param.getPlatform());
        if (storeExperienceNums != null && storeExperienceNums.length > 0) {
            String storeExperienceNum = storeExperienceNums[0];
            queryDTO.setStoreExperienceNum(storeExperienceNum);
        }
        if (storeTopmanNums != null && storeTopmanNums.length > 0) {
            String storeTopmanNum = storeTopmanNums[0];
            queryDTO.setStoreTopmanNum(storeTopmanNum);
        }
        if (storeVideosNums != null && storeVideosNums.length > 0) {
            String storeVideosNum = storeVideosNums[0];
            queryDTO.setStoreVideosNum(storeVideosNum);
        }
        if (storeSalesAmounts != null && storeSalesAmounts.length > 0) {
            String storeSalesAmount = storeSalesAmounts[0];
            queryDTO.setStoreSalesAmount(storeSalesAmount);
        }
        if (goodsLives != null && goodsLives.length > 0) {
            String goodsLive = goodsLives[0];
            queryDTO.setGoodsLive(Boolean.valueOf(goodsLive));
        }
        if (goodsVideos != null && goodsVideos.length > 0) {
            String goodsVideo = goodsVideos[0];
            queryDTO.setGoodsVideo(Boolean.valueOf(goodsVideo));
        }
        if (timeSelects != null && timeSelects.length > 0) {
            String timeSelect = timeSelects[0];
            queryDTO.setTimeSelect(timeSelect);
        }
        if (params != null && params.length > 0) {
            List<String> ids = Arrays.asList(params[0].split(","));
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        }
        queryDTO.setCompanyList(this.permissionDataRpcService.getCompanyOnly("companyStore"));
        String platform = queryDTO.getPlatform();
        if (ObjectUtil.isNotEmpty((Object)KsShopType)) {
            queryWrapper.eq((Object)"type", (Object)KsShopType[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)(KsTopManNum = paramMap.get("KsTopManNum"))) && ObjectUtil.isNotEmpty((Object)(var3 = KsTopManNum[0].split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var3[0])) {
                queryWrapper.ge((Object)"topmanNum", (Object)var3[0]);
            }
            if (var3.length == 2 && ObjectUtil.isNotEmpty((Object)var3[1])) {
                queryWrapper.le((Object)"topmanNum", (Object)var3[1]);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(KsSales = paramMap.get("KsSales"))) && ObjectUtil.isNotEmpty((Object)(var2 = KsSales[0].split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var2[0])) {
                queryWrapper.ge((Object)"salesAmountMax", (Object)var2[0]);
            }
            if (var2.length == 2 && ObjectUtil.isNotEmpty((Object)var2[1])) {
                queryWrapper.le((Object)"salesAmountMax", (Object)var2[1]);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(KsItemsNum = paramMap.get("KsItemsNum"))) && ObjectUtil.isNotEmpty((Object)(var = KsItemsNum[0].split("-")))) {
            if (ObjectUtil.isNotEmpty((Object)var[0])) {
                queryWrapper.ge((Object)"goodsNum", (Object)var[0]);
            }
            if (var.length == 2 && ObjectUtil.isNotEmpty((Object)var[1])) {
                queryWrapper.le((Object)"goodsNum", (Object)var[1]);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(KsAuthStatus = paramMap.get("KsAuthStatus")))) {
            queryWrapper.eq((Object)"auth_state", (Object)KsAuthStatus[0]);
        }
        if ("2".equals(platform)) {
            queryWrapper.eq((Object)"is_page_add", (Object)"1");
        }
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        List<CompanyStoreHead> list = this.storeHeadService.queryList(queryWrapper, queryDTO);
        list.forEach(row -> {
            if (ObjectUtil.isNotEmpty((Object)row.getExpireTime()) && System.currentTimeMillis() > row.getExpireTime().getTime()) {
                row.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue());
            }
        });
        return list;
    }

    public String getBeanName() {
        return null;
    }

    public String getBusinessType() {
        return null;
    }

    public long queryExportDataCount(QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHead map, Map<String, String[]> paramMap) {
        List list = this.permissionDataRpcService.getCompanyOnly("companyStore");
        if (CollUtil.isNotEmpty((Collection)list)) {
            queryWrapper.and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper1.in((Object)"company", (Collection)list)).or(wrapper2 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper2.isNull((Object)"company");
                });
            });
        }
        return this.storeHeadService.count((Wrapper)queryWrapper);
    }
}

