/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.vo;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.industryInfo.api.enumerate.StatisticsDateType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CompanyStoreOrderItemVO
implements Serializable {
    private static final long serialVersionUID = 21589665413145L;
    private String platformType;
    private ScreenItem screenItem;
    private String timeSelect;
    private String[] ids;

    public void initQueryWrapper(QueryWrapper<CompanyStoreOrderItem> queryWrapper) throws IllegalAccessException {
        if (this.ids != null) {
            queryWrapper.lambda().in(BaseEntity::getId, (Object[])this.ids);
        }
        if (this.platformType != null && this.platformType.trim().length() > 0) {
            queryWrapper.lambda().eq(CompanyStoreOrderItem::getPlatform, (Object)this.platformType);
        }
        if (this.timeSelect != null && this.timeSelect.trim().length() > 0) {
            StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)this.timeSelect, null);
            if (typeWhitDicCode == null) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u533a\u95f4\u6807\u8bb0\u9519\u8bef\uff0c\u6628\u5929\uff081d\uff09\u3001\u8fd17\u5929\uff087d\uff09\u3001\u8fd130\u5929\uff0830d\uff09\u3001\u8fd190\u5929\uff0890d\uff09"));
            }
            StatisticsDateType.GetDateTimeScopeService getDateTimeScopeService = typeWhitDicCode.getGetDateTimeScopeService();
            StatisticsDateType.DateTimeScope dateTimeScope = getDateTimeScopeService.getDateTimeScope();
            queryWrapper.lambda().ge(CompanyStoreOrderItem::getPayTime, (Object)dateTimeScope.getBeginTime());
            queryWrapper.lambda().lt(CompanyStoreOrderItem::getPayTime, (Object)dateTimeScope.getEndTime());
        }
        if (this.screenItem != null) {
            this.screenItem.initQueryWrapper(queryWrapper);
        }
    }

    public String getPlatformType() {
        return this.platformType;
    }

    public ScreenItem getScreenItem() {
        return this.screenItem;
    }

    public String getTimeSelect() {
        return this.timeSelect;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public void setScreenItem(ScreenItem screenItem) {
        this.screenItem = screenItem;
    }

    public void setTimeSelect(String timeSelect) {
        this.timeSelect = timeSelect;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompanyStoreOrderItemVO)) {
            return false;
        }
        CompanyStoreOrderItemVO other = (CompanyStoreOrderItemVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$platformType = this.getPlatformType();
        String other$platformType = other.getPlatformType();
        if (this$platformType == null ? other$platformType != null : !this$platformType.equals(other$platformType)) {
            return false;
        }
        ScreenItem this$screenItem = this.getScreenItem();
        ScreenItem other$screenItem = other.getScreenItem();
        if (this$screenItem == null ? other$screenItem != null : !((Object)this$screenItem).equals(other$screenItem)) {
            return false;
        }
        String this$timeSelect = this.getTimeSelect();
        String other$timeSelect = other.getTimeSelect();
        if (this$timeSelect == null ? other$timeSelect != null : !this$timeSelect.equals(other$timeSelect)) {
            return false;
        }
        return Arrays.deepEquals(this.getIds(), other.getIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompanyStoreOrderItemVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $platformType = this.getPlatformType();
        result = result * 59 + ($platformType == null ? 43 : $platformType.hashCode());
        ScreenItem $screenItem = this.getScreenItem();
        result = result * 59 + ($screenItem == null ? 43 : ((Object)$screenItem).hashCode());
        String $timeSelect = this.getTimeSelect();
        result = result * 59 + ($timeSelect == null ? 43 : $timeSelect.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIds());
        return result;
    }

    public String toString() {
        return "CompanyStoreOrderItemVO(platformType=" + this.getPlatformType() + ", screenItem=" + this.getScreenItem() + ", timeSelect=" + this.getTimeSelect() + ", ids=" + Arrays.deepToString(this.getIds()) + ")";
    }

    public static class ParamDic
    extends DictModel {
        private List<DictModel> option;
        private String fatherType;
        private String active;
        private String start;
        private String end;
        private boolean isDropDownList;
        private String selectedTitle;

        public List<DictModel> getOption() {
            return this.option;
        }

        public String getFatherType() {
            return this.fatherType;
        }

        public String getActive() {
            return this.active;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public boolean isDropDownList() {
            return this.isDropDownList;
        }

        public String getSelectedTitle() {
            return this.selectedTitle;
        }

        public void setOption(List<DictModel> option) {
            this.option = option;
        }

        public void setFatherType(String fatherType) {
            this.fatherType = fatherType;
        }

        public void setActive(String active) {
            this.active = active;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public void setDropDownList(boolean isDropDownList) {
            this.isDropDownList = isDropDownList;
        }

        public void setSelectedTitle(String selectedTitle) {
            this.selectedTitle = selectedTitle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamDic)) {
                return false;
            }
            ParamDic other = (ParamDic)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isDropDownList() != other.isDropDownList()) {
                return false;
            }
            List<DictModel> this$option = this.getOption();
            List<DictModel> other$option = other.getOption();
            if (this$option == null ? other$option != null : !((Object)this$option).equals(other$option)) {
                return false;
            }
            String this$fatherType = this.getFatherType();
            String other$fatherType = other.getFatherType();
            if (this$fatherType == null ? other$fatherType != null : !this$fatherType.equals(other$fatherType)) {
                return false;
            }
            String this$active = this.getActive();
            String other$active = other.getActive();
            if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
                return false;
            }
            String this$start = this.getStart();
            String other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            String this$end = this.getEnd();
            String other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            String this$selectedTitle = this.getSelectedTitle();
            String other$selectedTitle = other.getSelectedTitle();
            return !(this$selectedTitle == null ? other$selectedTitle != null : !this$selectedTitle.equals(other$selectedTitle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParamDic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDropDownList() ? 79 : 97);
            List<DictModel> $option = this.getOption();
            result = result * 59 + ($option == null ? 43 : ((Object)$option).hashCode());
            String $fatherType = this.getFatherType();
            result = result * 59 + ($fatherType == null ? 43 : $fatherType.hashCode());
            String $active = this.getActive();
            result = result * 59 + ($active == null ? 43 : $active.hashCode());
            String $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            String $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            String $selectedTitle = this.getSelectedTitle();
            result = result * 59 + ($selectedTitle == null ? 43 : $selectedTitle.hashCode());
            return result;
        }

        public String toString() {
            return "CompanyStoreOrderItemVO.ParamDic(option=" + this.getOption() + ", fatherType=" + this.getFatherType() + ", active=" + this.getActive() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", isDropDownList=" + this.isDropDownList() + ", selectedTitle=" + this.getSelectedTitle() + ")";
        }
    }

    public static interface InitMethod<T> {
        public void initQueryWrapper(QueryWrapper<T> var1, ParamDic var2);

        public static void scopeHandle(QueryWrapper<CompanyStoreOrderItem> queryWrapper, ParamDic bean, SFunction<CompanyStoreOrderItem, ?> sFunction) {
            String splitMark = "-";
            String value = bean.getActive();
            if (splitMark.equals(value)) {
                return;
            }
            if (value.startsWith(splitMark)) {
                queryWrapper.lambda().le(sFunction, (Object)value.substring(1));
                return;
            }
            if (value.endsWith(splitMark)) {
                queryWrapper.lambda().ge(sFunction, (Object)value.substring(0, value.length() - 1));
                return;
            }
            String[] split = value.split(splitMark);
            if (split.length != 2) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
            queryWrapper.lambda().between(sFunction, (Object)split[0], (Object)split[1]);
        }
    }

    static enum OtherOrderInformationEnum {
        promotionChannels("\u63a8\u5e7f\u6e20\u9053", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(CompanyStoreOrderItem::getOrderSource, (Object)b.active);
        }),
        promotionMethod("\u63a8\u5e7f\u65b9\u5f0f", (a, b) -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"popularizeType", (Object)b.active);
        }),
        leader("\u8d1f\u8d23\u4eba", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(CompanyStoreOrderItem::getLeader, (Object)b.active);
        });

        private final InitMethod<CompanyStoreOrderItem> initMethod;
        private final String title;

        private OtherOrderInformationEnum(String title, InitMethod<CompanyStoreOrderItem> initMethod) {
            this.title = title;
            this.initMethod = initMethod;
        }

        public InitMethod<CompanyStoreOrderItem> getInitMethod() {
            return this.initMethod;
        }

        public String getTitle() {
            return this.title;
        }

        public static OtherOrderInformationEnum getEnum(String title) {
            for (OtherOrderInformationEnum informationEnum : OtherOrderInformationEnum.values()) {
                if (!informationEnum.getTitle().equals(title)) continue;
                return informationEnum;
            }
            return null;
        }
    }

    static enum OrderConditionFilterEnum {
        store("\u6240\u5c5e\u5e97\u94fa", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(CompanyStoreOrderItem::getShopId, (Object)b.active);
        }),
        orderCommodityPrice("\u5546\u54c1\u4ef7\u683c", (a, b) -> InitMethod.scopeHandle((QueryWrapper<CompanyStoreOrderItem>)a, b, CompanyStoreOrderItem::getGoodsPrice)),
        orderCommissionRatio("\u4f63\u91d1\u6bd4\u4f8b", (a, b) -> InitMethod.scopeHandle((QueryWrapper<CompanyStoreOrderItem>)a, b, CompanyStoreOrderItem::getGoodsCommissionRatio)),
        orderQuantity("\u8ba2\u5355\u6570\u91cf", (a, b) -> InitMethod.scopeHandle((QueryWrapper<CompanyStoreOrderItem>)a, b, CompanyStoreOrderItem::getGoodsQuantity)),
        orderAmount("\u8ba2\u5355\u91d1\u989d", (a, b) -> InitMethod.scopeHandle((QueryWrapper<CompanyStoreOrderItem>)a, b, CompanyStoreOrderItem::getOrderAmount)),
        orderStatus("\u8ba2\u5355\u72b6\u6001", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(CompanyStoreOrderItem::getOrderStatus, (Object)b.active);
        });

        private final InitMethod<CompanyStoreOrderItem> initMethod;
        private final String title;

        private OrderConditionFilterEnum(String title, InitMethod<CompanyStoreOrderItem> initMethod) {
            this.title = title;
            this.initMethod = initMethod;
        }

        public InitMethod<CompanyStoreOrderItem> getInitMethod() {
            return this.initMethod;
        }

        public String getTitle() {
            return this.title;
        }

        public static OrderConditionFilterEnum getEnum(String title) {
            for (OrderConditionFilterEnum informationEnum : OrderConditionFilterEnum.values()) {
                if (!informationEnum.getTitle().equals(title)) continue;
                return informationEnum;
            }
            return null;
        }
    }

    public static class ScreenItem {
        @ApiModelProperty(value="\u5e26\u8d27\u5206\u7c7b")
        private List<ParamDic> category;
        @ApiModelProperty(value="\u6761\u4ef6\u7b5b\u9009")
        @JsonProperty(value="OrderConditionFilter")
        private List<ParamDic> orderConditionFilter;
        @ApiModelProperty(value="\u5176\u4ed6\u4fe1\u606f")
        @JsonProperty(value="OtherOrderInformation")
        private List<ParamDic> otherOrderInformation;

        public void initQueryWrapper(QueryWrapper<CompanyStoreOrderItem> queryWrapper) throws IllegalAccessException {
            Enum anEnum;
            String text;
            if (this.category != null && this.category.size() > 0) {
                List cargoClassificationValues = this.category.stream().map(DictModel::getValue).collect(Collectors.toList());
                queryWrapper.lambda().in(CompanyStoreOrderItem::getGoodsCategoryLv1, cargoClassificationValues);
            }
            if (this.orderConditionFilter != null && this.orderConditionFilter.size() > 0) {
                for (ParamDic oDic : this.orderConditionFilter) {
                    text = oDic.getText();
                    anEnum = OrderConditionFilterEnum.getEnum(text);
                    if (anEnum == null) continue;
                    ((OrderConditionFilterEnum)anEnum).getInitMethod().initQueryWrapper(queryWrapper, oDic);
                }
            }
            if (this.otherOrderInformation != null) {
                for (ParamDic oDic : this.otherOrderInformation) {
                    text = oDic.getText();
                    anEnum = OtherOrderInformationEnum.getEnum(text);
                    if (anEnum == null) continue;
                    ((OtherOrderInformationEnum)anEnum).getInitMethod().initQueryWrapper(queryWrapper, oDic);
                }
            }
        }

        public List<ParamDic> getCategory() {
            return this.category;
        }

        public List<ParamDic> getOrderConditionFilter() {
            return this.orderConditionFilter;
        }

        public List<ParamDic> getOtherOrderInformation() {
            return this.otherOrderInformation;
        }

        public void setCategory(List<ParamDic> category) {
            this.category = category;
        }

        @JsonProperty(value="OrderConditionFilter")
        public void setOrderConditionFilter(List<ParamDic> orderConditionFilter) {
            this.orderConditionFilter = orderConditionFilter;
        }

        @JsonProperty(value="OtherOrderInformation")
        public void setOtherOrderInformation(List<ParamDic> otherOrderInformation) {
            this.otherOrderInformation = otherOrderInformation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenItem)) {
                return false;
            }
            ScreenItem other = (ScreenItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ParamDic> this$category = this.getCategory();
            List<ParamDic> other$category = other.getCategory();
            if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
                return false;
            }
            List<ParamDic> this$orderConditionFilter = this.getOrderConditionFilter();
            List<ParamDic> other$orderConditionFilter = other.getOrderConditionFilter();
            if (this$orderConditionFilter == null ? other$orderConditionFilter != null : !((Object)this$orderConditionFilter).equals(other$orderConditionFilter)) {
                return false;
            }
            List<ParamDic> this$otherOrderInformation = this.getOtherOrderInformation();
            List<ParamDic> other$otherOrderInformation = other.getOtherOrderInformation();
            return !(this$otherOrderInformation == null ? other$otherOrderInformation != null : !((Object)this$otherOrderInformation).equals(other$otherOrderInformation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScreenItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ParamDic> $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
            List<ParamDic> $orderConditionFilter = this.getOrderConditionFilter();
            result = result * 59 + ($orderConditionFilter == null ? 43 : ((Object)$orderConditionFilter).hashCode());
            List<ParamDic> $otherOrderInformation = this.getOtherOrderInformation();
            result = result * 59 + ($otherOrderInformation == null ? 43 : ((Object)$otherOrderInformation).hashCode());
            return result;
        }

        public String toString() {
            return "CompanyStoreOrderItemVO.ScreenItem(category=" + this.getCategory() + ", orderConditionFilter=" + this.getOrderConditionFilter() + ", otherOrderInformation=" + this.getOtherOrderInformation() + ")";
        }
    }
}

