/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.monitor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.account.api.service.ApiCallCountRpcService;
import com.els.modules.common.spider.properties.MonitorMethodProperties;
import com.els.modules.common.spider.properties.SpiderBaseProperties;
import com.els.modules.common.utils.HttpRequestUtils;
import com.els.modules.monitor.entity.LiveMonitorEntity;
import com.els.modules.monitor.entity.LiveMonitorMessage;
import com.els.modules.monitor.entity.TopmanEntity;
import com.els.modules.monitor.mapper.LivesMonitorMapper;
import com.els.modules.monitor.service.LivesMonitorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class LivesMonitorServiceImpl
extends BaseServiceImpl<LivesMonitorMapper, LiveMonitorEntity>
implements LivesMonitorService {
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private MonitorMethodProperties monitorMethodProperties;
    @Autowired
    private ApiCallCountRpcService apiCallcountRpcService;
    private static final String SUCCESS_CODE = "1000";
    private static final String LIVE_MONITOR_COUNT_LIMIT = "live_monitor_count_limit";
    @Value(value="${els.env}")
    private String env;

    @Override
    public LiveMonitorMessage<List<TopmanEntity>> searchTopmanMonitor(String keyWord) throws Exception {
        String url = this.spiderBaseProperties.getMonitor();
        String liveSearchMethod = this.monitorMethodProperties.getLiveSearch();
        LiveMonitorMessage<List<TopmanEntity>> live = new LiveMonitorMessage<List<TopmanEntity>>();
        String param = LivesMonitorServiceImpl.apiGetList(keyWord);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + liveSearchMethod, param);
        String code = jsonObject.getString("code");
        live.setCode(code);
        live.setMessage(jsonObject.getString("message"));
        if (SUCCESS_CODE.equals(code)) {
            JSONArray dataArray = jsonObject.getJSONArray("data");
            ArrayList<TopmanEntity> list = new ArrayList<TopmanEntity>();
            for (Object obj : dataArray) {
                JSONObject dataJson = (JSONObject)obj;
                TopmanEntity data = (TopmanEntity)dataJson.toJavaObject(TopmanEntity.class);
                data.setLogo(dataJson.getString("user_head_logo"));
                data.setNikeName(dataJson.getString("user_name"));
                data.setAccount(dataJson.getString("aweme_id"));
                data.setUid(dataJson.getString("sec_uid"));
                list.add(data);
            }
            live.setReleaseTime(this.apiCallcountRpcService.getCount(LIVE_MONITOR_COUNT_LIMIT));
            live.setData(list);
        }
        return live;
    }

    private static String apiGetList(String keyWord) throws Exception {
        HashMap<String, String> apiParam = new HashMap<String, String>();
        apiParam.put("keyWord", keyWord);
        String json = JSON.toJSONString(apiParam);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    @Override
    public int startMonitor(LiveMonitorEntity entity) {
        int allcount = this.apiCallcountRpcService.getCount(LIVE_MONITOR_COUNT_LIMIT);
        double times = Math.ceil((entity.getMonitorEndDate().getTime() - entity.getMonitorStartDate().getTime()) / 21600000L);
        if (times > (double)allcount) {
            return 0;
        }
        entity.setEnv(this.env);
        entity.setTimes((int)times);
        ((LivesMonitorMapper)this.baseMapper).insert((Object)entity);
        this.mongoTemplate.insert((Object)entity);
        this.apiCallcountRpcService.deductionCount(LIVE_MONITOR_COUNT_LIMIT, (int)times, null);
        return 1;
    }
}

