/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.productpricing.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.productpricing.entity.InventoryItem;
import com.els.modules.productpricing.entity.InventoryTopmanItem;
import com.els.modules.productpricing.entity.ProductPricingHead;
import com.els.modules.productpricing.enumerate.ProductPricingStatusEmun;
import com.els.modules.productpricing.mapper.ProductPricingHeadMapper;
import com.els.modules.productpricing.service.InventoryItemService;
import com.els.modules.productpricing.service.InventoryTopmanItemService;
import com.els.modules.productpricing.service.ProductPricingHeadService;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ProductPricingHeadServiceImpl
extends BaseServiceImpl<ProductPricingHeadMapper, ProductPricingHead>
implements ProductPricingHeadService {
    @Resource
    private InventoryItemService inventoryItemService;
    @Resource
    private InventoryTopmanItemService inventoryTopmanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Resource
    private WorkflowAuditRpcService workflowAuditRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ProductPricingHead productPricingHead, List<InventoryItem> inventoryItemList, List<InventoryTopmanItem> inventoryTopmanItemList) {
        productPricingHead.setBusStatus(ProductPricingStatusEmun.NEWLY_BUILD.getValue());
        this.handleBefore(productPricingHead, ProductPricingStatusEmun.NEWLY_BUILD);
        ((ProductPricingHeadMapper)this.baseMapper).insert((Object)productPricingHead);
        super.setHeadDefaultValue((BaseEntity)productPricingHead);
        this.insertData(productPricingHead, inventoryItemList, inventoryTopmanItemList);
    }

    private void handleBefore(ProductPricingHead productPricingHead, ProductPricingStatusEmun step) {
        productPricingHead.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
        if (StrUtil.isBlank((CharSequence)productPricingHead.getBusNumber())) {
            productPricingHead.setBusNumber(this.invokeBaseRpcService.getNextCode("productPrcingNumber", (Object)productPricingHead));
        }
        if ("1".equals(productPricingHead.getResultAudit())) {
            productPricingHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            productPricingHead.setResultAudit("0");
            productPricingHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (step.equals((Object)ProductPricingStatusEmun.APPROVED)) {
            if ("1".equals(productPricingHead.getResultAudit())) {
                productPricingHead.setBusStatus(ProductPricingStatusEmun.APPROVED.getValue());
                productPricingHead.setResultAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
                this.saveOrUpdate((Object)productPricingHead);
                this.submitAudit(productPricingHead);
            } else {
                productPricingHead.setBusStatus(ProductPricingStatusEmun.APPROVAL.getValue());
            }
        }
    }

    public void submitAudit(ProductPricingHead productPricingHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(productPricingHead.getId());
        if (StringUtils.isNotBlank((CharSequence)productPricingHead.getResultFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(productPricingHead.getResultFlowId())));
        }
        auditInputParamVO.setBusinessType("productPricingApprove");
        auditInputParamVO.setAuditSubject("\u4ea7\u54c1\u6838\u4ef7\u5ba1\u6279\u5355\u636e:" + productPricingHead.getBusNumber());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)productPricingHead)));
        this.workflowAuditRpcService.submit(auditInputParamVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ProductPricingHead productPricingHead, List<InventoryItem> inventoryItemList, List<InventoryTopmanItem> inventoryTopmanItemList, ProductPricingStatusEmun step) {
        this.handleBefore(productPricingHead, step);
        int count = ((ProductPricingHeadMapper)this.baseMapper).updateById((Object)productPricingHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.inventoryItemService.deleteByMainId(productPricingHead.getId());
        this.inventoryTopmanItemService.deleteByMainId(productPricingHead.getId());
        this.insertData(productPricingHead, inventoryItemList, inventoryTopmanItemList);
    }

    private void insertData(ProductPricingHead productPricingHead, List<InventoryItem> inventoryItemList, List<InventoryTopmanItem> inventoryTopmanItemList) {
        if (!CollectionUtils.isEmpty(inventoryItemList)) {
            for (InventoryItem inventoryItem : inventoryItemList) {
                inventoryItem.setHeadId(productPricingHead.getId());
                inventoryItem.setItemStatus(productPricingHead.getBusStatus());
                SysUtil.setSysParam((BaseEntity)inventoryItem, (BaseEntity)productPricingHead);
            }
            this.inventoryItemService.saveBatch(inventoryItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(inventoryTopmanItemList)) {
            for (InventoryTopmanItem inventoryTopmanItem : inventoryTopmanItemList) {
                inventoryTopmanItem.setHeadId(productPricingHead.getId());
                SysUtil.setSysParam((BaseEntity)inventoryTopmanItem, (BaseEntity)productPricingHead);
            }
            this.inventoryTopmanItemService.saveBatch(inventoryTopmanItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.inventoryItemService.deleteByMainId(id);
        this.inventoryTopmanItemService.deleteByMainId(id);
        ((ProductPricingHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.inventoryItemService.deleteByMainId(serializable.toString());
            this.inventoryTopmanItemService.deleteByMainId(serializable.toString());
            ((ProductPricingHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

