/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.purchasercooperation.common.utils.BeanEntityUtils;
import com.els.modules.purchasercooperation.common.utils.PurchaseTalentStatusEnum;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHead;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHeadVo;
import com.els.modules.purchasercooperation.entity.PurchaserTalentPotencyItem;
import com.els.modules.purchasercooperation.entity.PurchaserTalentSampleItem;
import com.els.modules.purchasercooperation.entity.PurchaserTalentScheduleItem;
import com.els.modules.purchasercooperation.entity.PurchaserTalentWorksItem;
import com.els.modules.purchasercooperation.exception.PurchaseTalentDataCheckException;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentManageHeadMapper;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentPotencyItemMapper;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentSampleItemMapper;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentScheduleItemMapper;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentWorksItemMapper;
import com.els.modules.purchasercooperation.service.PurchaserTalentManageHeadService;
import com.els.modules.samplesend.entity.MerchandiseInventoryHead;
import com.els.modules.samplesend.entity.SampleTopMainHead;
import com.els.modules.samplesend.entity.SampleTopMainItem;
import com.els.modules.samplesend.mapper.MerchandiseInventoryHeadMapper;
import com.els.modules.samplesend.service.SampleTopMainHeadService;
import com.els.modules.suppliercooperation.entity.SupplierTalentManageHead;
import com.els.modules.suppliercooperation.entity.SupplierTalentPotencyItem;
import com.els.modules.suppliercooperation.entity.SupplierTalentSampleItem;
import com.els.modules.suppliercooperation.entity.SupplierTalentScheduleItem;
import com.els.modules.suppliercooperation.entity.SupplierTalentWorksItem;
import com.els.modules.suppliercooperation.mapper.SupplierTalentManageHeadMapper;
import com.els.modules.suppliercooperation.mapper.SupplierTalentPotencyItemMapper;
import com.els.modules.suppliercooperation.mapper.SupplierTalentSampleItemMapper;
import com.els.modules.suppliercooperation.mapper.SupplierTalentScheduleItemMapper;
import com.els.modules.suppliercooperation.mapper.SupplierTalentWorksItemMapper;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaserTalentManageHeadServiceImpl
extends BaseServiceImpl<PurchaserTalentManageHeadMapper, PurchaserTalentManageHead>
implements PurchaserTalentManageHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaserTalentManageHeadServiceImpl.class);
    @Autowired
    private PurchaserTalentManageHeadMapper manageHeadMapper;
    @Autowired
    private PurchaserTalentPotencyItemMapper potencyItemMapper;
    @Autowired
    private PurchaserTalentSampleItemMapper sampleItemMapper;
    @Autowired
    private PurchaserTalentScheduleItemMapper scheduleItemMapper;
    @Autowired
    private PurchaserTalentWorksItemMapper worksItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierTalentManageHeadMapper supplierTalentManageHeadMapper;
    @Autowired
    private SupplierTalentPotencyItemMapper supplierTalentPotencyItemMapper;
    @Autowired
    private SupplierTalentSampleItemMapper supplierTalentSampleItemMapper;
    @Autowired
    private SupplierTalentScheduleItemMapper supplierTalentScheduleItemMapper;
    @Autowired
    private SupplierTalentWorksItemMapper supplierTalentWorksItemMapper;
    @Resource
    private WorkflowAuditRpcService workflowAuditRpcService;
    @Autowired
    private SampleTopMainHeadService sampleTopMainHeadService;
    @Autowired
    private MerchandiseInventoryHeadMapper merchandiseInventoryHeadMapper;

    @Override
    @Transactional
    public void saveMain(PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        this.setDefaultParam(purchaserTalentManageHeadVO);
        int insert = this.manageHeadMapper.insert((Object)purchaserTalentManageHeadVO);
        if (insert > 0) {
            this.setSubclass("0", purchaserTalentManageHeadVO);
        }
    }

    @Override
    @Transactional
    public void editMain(String status, PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        int i;
        String id = purchaserTalentManageHeadVO.getId();
        this.checkPrivilege(id);
        if ("0".equals(status)) {
            this.setDefaultParam(purchaserTalentManageHeadVO);
        }
        if ((i = this.manageHeadMapper.updateById((Object)purchaserTalentManageHeadVO)) > 0) {
            this.setSubclass(status, purchaserTalentManageHeadVO);
        }
    }

    @Override
    public PurchaserTalentManageHead setSubclass(String status, PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        List<PurchaserTalentWorksItem> worksItems;
        List<PurchaserTalentScheduleItem> scheduleItems;
        List<PurchaserTalentSampleItem> sampleItems;
        String id = purchaserTalentManageHeadVO.getId();
        List<PurchaserTalentPotencyItem> potencyItems = purchaserTalentManageHeadVO.getPotencyItems();
        if (CollectionUtils.isNotEmpty(potencyItems)) {
            potencyItems.forEach(potencyItem -> {
                BeanEntityUtils.initSysPram(potencyItem);
                potencyItem.setHeadId(id);
                potencyItem.setToElsAccount(purchaserTalentManageHeadVO.getToElsAccount());
                String s = null;
                s = "2".equals(status) ? (StringUtils.isEmpty((CharSequence)potencyItem.getItemStatus()) || "0".equals(potencyItem.getItemStatus()) ? "0" : potencyItem.getItemStatus()) : ("1".equals(status) ? (StringUtils.isEmpty((CharSequence)potencyItem.getItemStatus()) || "0".equals(potencyItem.getItemStatus()) ? "1" : potencyItem.getItemStatus()) : ("0".equals(status) ? "0" : "1"));
                potencyItem.setItemStatus(s);
            });
            this.potencyItemMapper.deleteByHeadId(id, TenantContext.getTenant());
            this.potencyItemMapper.insertBatchSomeColumn(potencyItems);
        }
        if (CollectionUtils.isNotEmpty(sampleItems = purchaserTalentManageHeadVO.getSampleItems())) {
            HashMap paramMap = new HashMap();
            sampleItems.forEach(sampleItem -> {
                BeanEntityUtils.initSysPram(sampleItem);
                sampleItem.setHeadId(id);
                sampleItem.setToElsAccount(purchaserTalentManageHeadVO.getToElsAccount());
                String s = null;
                if ("2".equals(status)) {
                    s = StringUtils.isEmpty((CharSequence)sampleItem.getItemStatus()) || "0".equals(sampleItem.getItemStatus()) ? "0" : sampleItem.getItemStatus();
                } else if ("1".equals(status)) {
                    if (!"0".equals(sampleItem.getItemStatus()) && StringUtils.isNotEmpty((CharSequence)sampleItem.getId())) {
                        paramMap.put(sampleItem.getId(), sampleItem.getId());
                    }
                    s = StringUtils.isEmpty((CharSequence)sampleItem.getItemStatus()) || "0".equals(sampleItem.getItemStatus()) ? "1" : sampleItem.getItemStatus();
                } else {
                    s = "0".equals(status) ? "0" : "1";
                }
                sampleItem.setItemStatus(s);
            });
            this.sampleItemMapper.deleteByHeadId(id, TenantContext.getTenant());
            this.sampleItemMapper.insertBatchSomeColumn(sampleItems);
            if ("1".equals(status)) {
                log.info("paramMap=" + paramMap);
                if (paramMap != null && paramMap.size() > 0) {
                    ArrayList<PurchaserTalentSampleItem> sampleItemList = new ArrayList<PurchaserTalentSampleItem>();
                    PurchaserTalentManageHead purchaserTalentManageHead = new PurchaserTalentManageHead();
                    BeanUtils.copyProperties((Object)((Object)purchaserTalentManageHeadVO), (Object)((Object)purchaserTalentManageHead));
                    int size = sampleItems.size();
                    for (int i = 0; i < size; ++i) {
                        if (paramMap.containsKey(sampleItems.get(i).getId())) continue;
                        sampleItemList.add(sampleItems.get(i));
                    }
                    if (CollectionUtils.isNotEmpty(sampleItemList)) {
                        purchaserTalentManageHead.setSampleItems(sampleItemList);
                        this.saveSample(purchaserTalentManageHead);
                    }
                } else {
                    this.saveSample(purchaserTalentManageHeadVO);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(scheduleItems = purchaserTalentManageHeadVO.getScheduleItems())) {
            scheduleItems.forEach(scheduleItem -> {
                BeanEntityUtils.initSysPram(scheduleItem);
                scheduleItem.setHeadId(id);
                scheduleItem.setToElsAccount(purchaserTalentManageHeadVO.getToElsAccount());
                String s = null;
                s = "2".equals(status) ? (StringUtils.isEmpty((CharSequence)scheduleItem.getItemStatus()) || "0".equals(scheduleItem.getItemStatus()) ? "0" : scheduleItem.getItemStatus()) : ("1".equals(status) ? (StringUtils.isEmpty((CharSequence)scheduleItem.getItemStatus()) || "0".equals(scheduleItem.getItemStatus()) ? "1" : scheduleItem.getItemStatus()) : ("0".equals(status) ? "0" : "1"));
                scheduleItem.setItemStatus(s);
            });
            this.scheduleItemMapper.deleteByHeadId(id, TenantContext.getTenant());
            this.scheduleItemMapper.insertBatchSomeColumn(scheduleItems);
        }
        if (CollectionUtils.isNotEmpty(worksItems = purchaserTalentManageHeadVO.getWorksItems())) {
            worksItems.forEach(worksItem -> {
                BeanEntityUtils.initSysPram(worksItem);
                worksItem.setHeadId(id);
                worksItem.setToElsAccount(purchaserTalentManageHeadVO.getToElsAccount());
                String s = null;
                s = "2".equals(status) ? (StringUtils.isEmpty((CharSequence)worksItem.getItemStatus()) || "0".equals(worksItem.getItemStatus()) ? "0" : worksItem.getItemStatus()) : ("1".equals(status) ? (StringUtils.isEmpty((CharSequence)worksItem.getItemStatus()) || "0".equals(worksItem.getItemStatus()) ? "1" : worksItem.getItemStatus()) : ("0".equals(status) ? "0" : "1"));
                worksItem.setItemStatus(s);
            });
            this.worksItemMapper.deleteByHeadId(id, TenantContext.getTenant());
            this.worksItemMapper.insertBatchSomeColumn(worksItems);
        }
        return purchaserTalentManageHeadVO;
    }

    @Override
    public IPage<PurchaserTalentManageHead> findBillNumberByTopManId(String topManId, Page<PurchaserTalentManageHead> page) {
        List<String> statusList = Arrays.asList("1", "2");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaserTalentManageHead::getTopmanId, (Object)topManId)).eq(BaseEntity::getDeleted, (Object)0)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaserTalentManageHead::getCooperateBillStatus, statusList);
        Page pageList = (Page)((PurchaserTalentManageHeadMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        return pageList;
    }

    @Override
    @Transactional
    public void delete(String id) {
        this.checkPrivilege(id);
        int i = this.manageHeadMapper.deleteById((Serializable)((Object)id));
        if (i > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("head_id", id);
            paramMap.put("els_account", TenantContext.getTenant());
            this.potencyItemMapper.deleteByMap(paramMap);
            this.sampleItemMapper.deleteByMap(paramMap);
            this.scheduleItemMapper.deleteByMap(paramMap);
            this.worksItemMapper.deleteByMap(paramMap);
        }
    }

    @Override
    public int cancelById(String id) {
        int update = 0;
        PurchaserTalentManageHead purchaserTalentManageHead = (PurchaserTalentManageHead)((Object)super.getById((Serializable)((Object)id)));
        if (purchaserTalentManageHead == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!StringUtils.isNotEmpty((CharSequence)purchaserTalentManageHead.getCooperateBillStatus()) || !purchaserTalentManageHead.getCooperateBillStatus().equals("1")) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u7684\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u4fe1\u606f");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)purchaserTalentManageHead.getId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(PurchaserTalentManageHead::getCooperateBillStatus, (Object)"3")).set(BaseEntity::getUpdateBy, (Object)SysUtil.getLoginUser().getSubAccount())).set(BaseEntity::getUpdateTime, (Object)new Date());
        update = ((PurchaserTalentManageHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return update;
    }

    @Override
    public PurchaserTalentManageHead queryById(String id) {
        PurchaserTalentManageHead purchaserTalentManageHead = (PurchaserTalentManageHead)((Object)this.manageHeadMapper.selectById((Serializable)((Object)id)));
        if (purchaserTalentManageHead == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("head_id", id);
        paramMap.put("els_account", TenantContext.getTenant());
        List potencyItemList = this.potencyItemMapper.selectByMap(paramMap);
        List sampleItemList = this.sampleItemMapper.selectByMap(paramMap);
        List scheduleItemList = this.scheduleItemMapper.selectByMap(paramMap);
        List worksItemList = this.worksItemMapper.selectByMap(paramMap);
        purchaserTalentManageHead.setPotencyItems(potencyItemList);
        purchaserTalentManageHead.setSampleItems(sampleItemList);
        purchaserTalentManageHead.setScheduleItems(scheduleItemList);
        purchaserTalentManageHead.setWorksItems(worksItemList);
        return purchaserTalentManageHead;
    }

    @Override
    public void updateSupplierCooperate(boolean isFalse, PurchaserTalentManageHead purchaserTalentManageHead) {
        PurchaserTalentManageHead byId = (PurchaserTalentManageHead)((Object)((PurchaserTalentManageHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaserTalentManageHead.getId())));
        if ("1".equals(byId.getCooperateBillStatus()) || "2".equals(byId.getCooperateBillStatus())) {
            this.changeClassSupplierCooperate(isFalse, purchaserTalentManageHead);
        }
    }

    private void changeClassSupplierCooperate(boolean isFalse, PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        SupplierTalentManageHead supplierTalentManageHead = new SupplierTalentManageHead();
        BeanUtils.copyProperties((Object)((Object)purchaserTalentManageHeadVO), (Object)((Object)supplierTalentManageHead));
        if (isFalse) {
            supplierTalentManageHead.setElsAccount(purchaserTalentManageHeadVO.getToElsAccount());
            supplierTalentManageHead.setToElsAccount(purchaserTalentManageHeadVO.getElsAccount());
            supplierTalentManageHead.setDeleted(0);
            this.supplierTalentManageHeadMapper.deleteById(supplierTalentManageHead.getId());
            this.supplierTalentManageHeadMapper.insert(supplierTalentManageHead);
        }
        String id = supplierTalentManageHead.getId();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("head_id", id);
        List<PurchaserTalentPotencyItem> potencyItems = purchaserTalentManageHeadVO.getPotencyItems();
        ArrayList potencyItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty(potencyItems)) {
            potencyItems.forEach(potencyItem -> {
                SupplierTalentPotencyItem potency = new SupplierTalentPotencyItem();
                BeanUtils.copyProperties((Object)potencyItem, (Object)((Object)potency));
                potency.setElsAccount(potencyItem.getToElsAccount());
                potency.setToElsAccount(potencyItem.getElsAccount());
                potencyItemList.add(potency);
            });
            this.supplierTalentPotencyItemMapper.deleteByHeadId(id, potencyItems.get(0).getToElsAccount());
            this.supplierTalentPotencyItemMapper.insertBatchSomeColumn(potencyItemList);
        }
        List<PurchaserTalentSampleItem> sampleItems = purchaserTalentManageHeadVO.getSampleItems();
        ArrayList sampleItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty(sampleItems)) {
            sampleItems.forEach(sampleItem -> {
                SupplierTalentSampleItem sample = new SupplierTalentSampleItem();
                BeanUtils.copyProperties((Object)sampleItem, (Object)((Object)sample));
                sample.setElsAccount(sampleItem.getToElsAccount());
                sample.setToElsAccount(sampleItem.getElsAccount());
                sampleItemList.add(sample);
            });
            this.supplierTalentSampleItemMapper.deleteByHeadId(id, sampleItems.get(0).getToElsAccount());
            this.supplierTalentSampleItemMapper.insertBatchSomeColumn(sampleItemList);
        }
        List<PurchaserTalentScheduleItem> scheduleItems = purchaserTalentManageHeadVO.getScheduleItems();
        ArrayList scheduleItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty(scheduleItems)) {
            scheduleItems.forEach(scheduleItem -> {
                SupplierTalentScheduleItem schedu = new SupplierTalentScheduleItem();
                BeanUtils.copyProperties((Object)scheduleItem, (Object)((Object)schedu));
                schedu.setElsAccount(scheduleItem.getToElsAccount());
                schedu.setToElsAccount(scheduleItem.getElsAccount());
                scheduleItemList.add(schedu);
            });
            this.supplierTalentScheduleItemMapper.deleteByHeadId(id, scheduleItems.get(0).getToElsAccount());
            this.supplierTalentScheduleItemMapper.insertBatchSomeColumn(scheduleItemList);
        }
        List<PurchaserTalentWorksItem> worksItems = purchaserTalentManageHeadVO.getWorksItems();
        ArrayList worksItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty(worksItems)) {
            worksItems.forEach(worksItem -> {
                SupplierTalentWorksItem works = new SupplierTalentWorksItem();
                BeanUtils.copyProperties((Object)worksItem, (Object)((Object)works));
                works.setElsAccount(worksItem.getToElsAccount());
                works.setToElsAccount(worksItem.getElsAccount());
                worksItemList.add(works);
            });
            this.supplierTalentWorksItemMapper.deleteByHeadId(id, worksItems.get(0).getToElsAccount());
            this.supplierTalentWorksItemMapper.insertBatchSomeColumn(worksItemList);
        }
    }

    @Override
    @Transactional
    public void submit(PurchaserTalentManageHead purchaserTalentManageHead) {
        String id = purchaserTalentManageHead.getId();
        PurchaserTalentManageHead byId = (PurchaserTalentManageHead)((Object)super.getById((Serializable)((Object)id)));
        boolean b = this.setApproveParamStatus(purchaserTalentManageHead);
        if (byId == null) {
            purchaserTalentManageHead.setBillNumber(StringUtils.isEmpty((CharSequence)purchaserTalentManageHead.getBillNumber()) ? this.invokeBaseRpcService.getNextCode("purchaseTalentManageNumber", (Object)purchaserTalentManageHead) : purchaserTalentManageHead.getBillNumber());
            int n = this.manageHeadMapper.insert((Object)purchaserTalentManageHead);
        } else {
            this.manageHeadMapper.updateById((Object)purchaserTalentManageHead);
        }
        if (b) {
            PurchaserTalentManageHead p = this.setSubclass("0", purchaserTalentManageHead);
            this.submitAudit(p);
        } else {
            this.updateGoodsStock(purchaserTalentManageHead);
            this.setSubclass("1", purchaserTalentManageHead);
            log.info("\u53d1\u5e03\u540e\u7684\u6570\u636e\u590d\u5236\u4e00\u4efd\u5230\u4f9b\u5e94\u5546=" + (Object)((Object)purchaserTalentManageHead));
            this.updateSupplierCooperate(true, purchaserTalentManageHead);
        }
    }

    @Override
    public void submitAudit(PurchaserTalentManageHead purchaserTalentManageHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(purchaserTalentManageHead.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaserTalentManageHead.getFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(purchaserTalentManageHead.getFlowId())));
        }
        auditInputParamVO.setBusinessType("talentManageApprove");
        auditInputParamVO.setAuditSubject("\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u5ba1\u6279\u5355\u636e:" + purchaserTalentManageHead.getBillNumber());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)purchaserTalentManageHead)));
        String s = JSONObject.toJSONString((Object)((Object)purchaserTalentManageHead));
        this.workflowAuditRpcService.submit(auditInputParamVO);
    }

    @Override
    @Transactional
    public void updateMain(String status, PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        if ("0".equals(status)) {
            this.setSubclass("2", purchaserTalentManageHeadVO);
        } else {
            this.updateGoodsStock(purchaserTalentManageHeadVO);
            this.setSubclass("1", purchaserTalentManageHeadVO);
            this.updateSupplierCooperate(false, purchaserTalentManageHeadVO);
        }
    }

    @Override
    @Transactional
    public void finishCooperation(String id) {
        this.checkUpdate(id);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(PurchaserTalentManageHead::getCooperateBillStatus, (Object)"2")).set(BaseEntity::getUpdateBy, (Object)SysUtil.getLoginUser().getSubAccount())).set(BaseEntity::getUpdateTime, (Object)new Date());
        this.manageHeadMapper.update(null, (Wrapper)updateWrapper);
        this.updateSupplierCooperate(true, (PurchaserTalentManageHead)((Object)this.manageHeadMapper.selectById((Serializable)((Object)id))));
    }

    @Override
    public PurchaserTalentManageHead changeVO(PurchaserTalentManageHeadVo purchaserTalentManageHeadVo) {
        PurchaserTalentManageHead purchaserTalentManageHead = new PurchaserTalentManageHead();
        purchaserTalentManageHead = purchaserTalentManageHeadVo.getPurchaserTalentManageHead();
        purchaserTalentManageHead.setPotencyItems(purchaserTalentManageHeadVo.getPotencyItems());
        purchaserTalentManageHead.setSampleItems(purchaserTalentManageHeadVo.getSampleItems());
        purchaserTalentManageHead.setScheduleItems(purchaserTalentManageHeadVo.getScheduleItems());
        purchaserTalentManageHead.setWorksItems(purchaserTalentManageHeadVo.getWorksItems());
        return purchaserTalentManageHead;
    }

    private boolean setApproveParamStatus(PurchaserTalentManageHead purchaserTalentManageHead) {
        boolean isApprove = false;
        if (StringUtils.isEmpty((CharSequence)purchaserTalentManageHead.getIsNeedAudit())) {
            throw new PurchaseTalentDataCheckException.NotExist("\u53d1\u5e03\u5ba1\u6279\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(purchaserTalentManageHead.getIsNeedAudit())) {
            purchaserTalentManageHead.setCooperateBillStatus("1");
            purchaserTalentManageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            purchaserTalentManageHead.setSubmitStatus("1");
        } else {
            purchaserTalentManageHead.setCooperateBillStatus("0");
            purchaserTalentManageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            purchaserTalentManageHead.setSubmitStatus("0");
            isApprove = true;
        }
        purchaserTalentManageHead.setSubAccount(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentManageHead.setRealname(SysUtil.getLoginUser().getRealname());
        purchaserTalentManageHead.setTopManAccount(purchaserTalentManageHead.getToElsAccount());
        return isApprove;
    }

    private boolean checkUpdate(String id) {
        List<PurchaserTalentWorksItem> worksItems;
        List<PurchaserTalentScheduleItem> scheduleItems;
        List<PurchaserTalentSampleItem> sampleItems;
        PurchaserTalentManageHead purchaserTalentManageHead = this.queryById(id);
        if (purchaserTalentManageHead == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (StringUtils.isNotEmpty((CharSequence)purchaserTalentManageHead.getCooperateBillStatus()) && !PurchaseTalentStatusEnum.doing(purchaserTalentManageHead.getCooperateBillStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u66f4\u65b0\u5355\u636e\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u7684\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u4fe1\u606f");
        }
        if (!TenantContext.getTenant().equals(purchaserTalentManageHead.getElsAccount())) {
            throw new PurchaseTalentDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        List<PurchaserTalentPotencyItem> potencyItems = purchaserTalentManageHead.getPotencyItems();
        if (CollectionUtils.isNotEmpty(potencyItems)) {
            potencyItems.forEach(a -> Assert.isTrue((boolean)"2".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u6548\u80fd\u884c\u72b6\u6001\u6709\u672a\u786e\u8ba4\u7684\uff0c\u8bf7\u5148\u786e\u8ba4")));
        }
        if (CollectionUtils.isNotEmpty(sampleItems = purchaserTalentManageHead.getSampleItems())) {
            sampleItems.forEach(a -> Assert.isTrue((boolean)"3".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u6837\u54c1\u884c\u72b6\u6001\u6709\u672a\u6536\u8d27\u7684\uff0c\u8bf7\u5148\u786e\u8ba4\u6536\u8d27")));
        }
        if (CollectionUtils.isNotEmpty(scheduleItems = purchaserTalentManageHead.getScheduleItems())) {
            scheduleItems.forEach(a -> Assert.isTrue(("2".equals(a.getItemStatus()) || "3".equals(a.getItemStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6863\u671f\u884c\u72b6\u6001\u6709\u5f85\u786e\u8ba4\u7684\uff0c\u8bf7\u5148\u786e\u8ba4\u6216\u8005\u62d2\u7edd")));
        }
        if (CollectionUtils.isNotEmpty(worksItems = purchaserTalentManageHead.getWorksItems())) {
            worksItems.forEach(a -> Assert.isTrue(("2".equals(a.getItemStatus()) || "3".equals(a.getItemStatus()) || "4".equals(a.getItemStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u4f5c\u54c1\u884c\u72b6\u6001\u6709\u5f85\u786e\u8ba4\u7684\uff0c\u8bf7\u5148\u786e\u8ba4")));
        }
        return true;
    }

    private boolean checkPrivilege(String id) {
        PurchaserTalentManageHead purchaserTalentManageHead = (PurchaserTalentManageHead)((Object)super.getById((Serializable)((Object)id)));
        if (purchaserTalentManageHead == null) {
            throw new PurchaseTalentDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (StringUtils.isNotEmpty((CharSequence)purchaserTalentManageHead.getCooperateBillStatus()) && !PurchaseTalentStatusEnum.isNew(purchaserTalentManageHead.getCooperateBillStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)purchaserTalentManageHead.getAuditStatus()) && PurchaseTalentStatusEnum.doing(purchaserTalentManageHead.getAuditStatus())) {
            throw new PurchaseTalentDataCheckException.InvalidState("\u8be5\u5355\u636e\u5df2\u5728\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
        }
        if (!TenantContext.getTenant().equals(purchaserTalentManageHead.getElsAccount())) {
            throw new PurchaseTalentDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        return true;
    }

    public void setDefaultParam(PurchaserTalentManageHead purchaserTalentManageHead) {
        purchaserTalentManageHead.setBillNumber(StringUtils.isEmpty((CharSequence)purchaserTalentManageHead.getBillNumber()) ? this.invokeBaseRpcService.getNextCode("purchaseTalentManageNumber", (Object)purchaserTalentManageHead) : purchaserTalentManageHead.getBillNumber());
        purchaserTalentManageHead.setCooperateBillStatus("0");
        purchaserTalentManageHead.setSubmitStatus("0");
        String pubishAudit = StringUtils.isEmpty((CharSequence)purchaserTalentManageHead.getIsNeedAudit()) ? "0" : purchaserTalentManageHead.getIsNeedAudit();
        purchaserTalentManageHead.setIsNeedAudit(pubishAudit);
        String s = StringUtils.isEmpty((CharSequence)purchaserTalentManageHead.getIsNeedAudit()) || "0".equals(purchaserTalentManageHead.getIsNeedAudit()) ? "4" : "0";
        purchaserTalentManageHead.setAuditStatus(s);
        purchaserTalentManageHead.setSubAccount(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentManageHead.setRealname(SysUtil.getLoginUser().getRealname());
        purchaserTalentManageHead.setTopManAccount(purchaserTalentManageHead.getToElsAccount());
    }

    public void saveSample(PurchaserTalentManageHead purchaserTalentManageHead) {
        log.info("purchaserTalentManageHead=" + (Object)((Object)purchaserTalentManageHead));
        SampleTopMainHead sampleTopMainHead = new SampleTopMainHead();
        sampleTopMainHead.setTemplateNumber("TC2022052902");
        sampleTopMainHead.setTemplateName("\u6837\u54c1\u5bc4\u9001\u7ba1\u7406");
        sampleTopMainHead.setTemplateAccount("100000");
        sampleTopMainHead.setTemplateVersion("3");
        sampleTopMainHead.setPlatform(purchaserTalentManageHead.getPlatform());
        sampleTopMainHead.setToElsAccount(purchaserTalentManageHead.getToElsAccount());
        sampleTopMainHead.setBrand(purchaserTalentManageHead.getBrand());
        sampleTopMainHead.setTopmanId(purchaserTalentManageHead.getTopmanId());
        sampleTopMainHead.setTopmanName(purchaserTalentManageHead.getTalent());
        sampleTopMainHead.setTopmanSex(purchaserTalentManageHead.getTopmanSex());
        sampleTopMainHead.setTopmanRegion(purchaserTalentManageHead.getTopmanRegion());
        sampleTopMainHead.setMobile(purchaserTalentManageHead.getPhone());
        sampleTopMainHead.setWechat(purchaserTalentManageHead.getWechatNumber());
        sampleTopMainHead.setSendAddress(purchaserTalentManageHead.getAddress());
        sampleTopMainHead.setSourceBillType("0");
        sampleTopMainHead.setSourceBillCode(purchaserTalentManageHead.getBillNumber());
        sampleTopMainHead.setLead(purchaserTalentManageHead.getProjectPerson());
        sampleTopMainHead.setLeadSubAccount(purchaserTalentManageHead.getSubAccount());
        sampleTopMainHead.setPubishAudit(purchaserTalentManageHead.getIsNeedAudit());
        sampleTopMainHead.setPubishAuditStatus(purchaserTalentManageHead.getAuditStatus());
        sampleTopMainHead.setPubishFlowId(purchaserTalentManageHead.getFlowId());
        sampleTopMainHead.setSubmitStatus("1");
        sampleTopMainHead.setBillStatus("1");
        sampleTopMainHead.setBillCode(this.invokeBaseRpcService.getNextCode("sampleTopMainNumber", (Object)sampleTopMainHead));
        List<PurchaserTalentSampleItem> sampleItems = purchaserTalentManageHead.getSampleItems();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(sampleItems), (String)I18nUtil.translate((String)"", (String)"\u4f5c\u54c1\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        ArrayList<SampleTopMainItem> sampleTopMainItemList = new ArrayList<SampleTopMainItem>();
        sampleItems.forEach(a -> {
            if ("1".equals(a.getItemStatus())) {
                SampleTopMainItem sampleTopMainItem = new SampleTopMainItem();
                sampleTopMainItem.setGoodsCode(a.getMatterNumber());
                sampleTopMainItem.setGoodsName(a.getMatterName());
                sampleTopMainItem.setGoodsCategory(a.getMatterCategory());
                sampleTopMainItem.setGoodsGroup(a.getMatterGroup());
                sampleTopMainItem.setQuantity(a.getNumber());
                sampleTopMainItem.setId(a.getId());
                sampleTopMainItem.setToElsAccount(a.getToElsAccount());
                sampleTopMainItem.setItemStatus(a.getItemStatus());
                sampleTopMainItemList.add(sampleTopMainItem);
            }
        });
        if (CollectionUtils.isNotEmpty(sampleTopMainItemList)) {
            sampleTopMainHead.setSampleTopMainItems(sampleTopMainItemList);
            this.sampleTopMainHeadService.add("1", sampleTopMainHead);
        }
    }

    @Override
    public void updateGoodsStock(PurchaserTalentManageHead purchaserTalentManageHeadVO) {
        ArrayList<MerchandiseInventoryHead> ids;
        List<PurchaserTalentScheduleItem> scheduleItems;
        List<PurchaserTalentSampleItem> sampleItems = purchaserTalentManageHeadVO.getSampleItems();
        ArrayList headList = new ArrayList();
        HashMap paramMap = new HashMap();
        if (CollectionUtils.isNotEmpty(sampleItems)) {
            sampleItems.forEach(sampleItem -> {
                if ("0".equals(sampleItem.getItemStatus())) {
                    if (paramMap.containsKey(sampleItem.getMatterId())) {
                        MerchandiseInventoryHead merchandiseInventoryHead = (MerchandiseInventoryHead)((Object)((Object)paramMap.get(sampleItem.getMatterId())));
                        merchandiseInventoryHead.setAssignedQuantity(merchandiseInventoryHead.getAssignedQuantity().add(sampleItem.getNumber()));
                        paramMap.put(sampleItem.getMatterId(), merchandiseInventoryHead);
                    } else {
                        MerchandiseInventoryHead merchandiseInventoryHead = new MerchandiseInventoryHead();
                        merchandiseInventoryHead.setId(sampleItem.getMatterId());
                        merchandiseInventoryHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
                        merchandiseInventoryHead.setUpdateTime(new Date());
                        merchandiseInventoryHead.setAssignedQuantity(sampleItem.getNumber());
                        merchandiseInventoryHead.setElsAccount(TenantContext.getTenant());
                        merchandiseInventoryHead.setSupplierNo(sampleItem.getMatterNumber());
                        paramMap.put(sampleItem.getMatterId(), merchandiseInventoryHead);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty(scheduleItems = purchaserTalentManageHeadVO.getScheduleItems())) {
            scheduleItems.forEach(scheduleItem -> {
                if ("0".equals(scheduleItem.getItemStatus())) {
                    if (paramMap.containsKey(scheduleItem.getMatterId())) {
                        MerchandiseInventoryHead merchandiseInventoryHead = (MerchandiseInventoryHead)((Object)((Object)paramMap.get(scheduleItem.getMatterId())));
                        merchandiseInventoryHead.setAssignedQuantity(merchandiseInventoryHead.getAssignedQuantity().add(scheduleItem.getStockNumber()));
                        paramMap.put(scheduleItem.getMatterId(), merchandiseInventoryHead);
                    } else {
                        MerchandiseInventoryHead merchandiseInventoryHead = new MerchandiseInventoryHead();
                        merchandiseInventoryHead.setId(scheduleItem.getMatterId());
                        merchandiseInventoryHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
                        merchandiseInventoryHead.setUpdateTime(new Date());
                        merchandiseInventoryHead.setAssignedQuantity(scheduleItem.getStockNumber());
                        merchandiseInventoryHead.setElsAccount(TenantContext.getTenant());
                        merchandiseInventoryHead.setSupplierNo(scheduleItem.getMatterNumber());
                        paramMap.put(scheduleItem.getMatterId(), merchandiseInventoryHead);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty(ids = new ArrayList<MerchandiseInventoryHead>(paramMap.values()))) {
            log.info("updateGoodsStock :" + ids);
            int i = this.merchandiseInventoryHeadMapper.updateGoodsStock(ids);
            Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u6570\u91cf\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
        }
    }
}

