/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core.threadpool;

import com.doudian.open.core.DoudianOpConfig;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DoudianOpThreadPool {
    private static volatile DoudianOpThreadPool INSTANCE;
    private final ThreadPoolExecutor executor;

    private DoudianOpThreadPool(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DoudianOpThreadPool getInstance(DoudianOpConfig config) {
        if (INSTANCE != null) return INSTANCE;
        Class<DoudianOpThreadPool> clazz = DoudianOpThreadPool.class;
        synchronized (DoudianOpThreadPool.class) {
            if (INSTANCE != null) return INSTANCE;
            ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getAsyncThreadPoolSize(), config.getAsyncThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(config.getAsyncThreadPoolQueueSize()));
            INSTANCE = new DoudianOpThreadPool(executor);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public <T> Future<T> submit(Callable<T> call) {
        return this.executor.submit(call);
    }
}

