/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.utils;

import com.doudian.open.utils.Logger;
import java.lang.reflect.Method;

public class LogUtils {
    private static final Logger LOG = Logger.getLogger(LogUtils.class);
    private static final String LOG_ID_KEY = "x-tt-logid";
    private static volatile Method getLogMethod;
    private static volatile boolean init;

    public static String getLogId() {
        if (!init) {
            try {
                Class<?> clientClass = Class.forName("org.slf4j.MDC");
                getLogMethod = clientClass.getDeclaredMethod("get", String.class);
            }
            catch (ClassNotFoundException ignored) {
                LOG.warning("MDC ClassNotFound", new Object[0]);
            }
            catch (Exception e) {
                LOG.warning("Failed to init DMC! %s", e.getMessage());
            }
            finally {
                init = true;
            }
        }
        if (init && getLogMethod == null) {
            return null;
        }
        try {
            return (String)getLogMethod.invoke(null, LOG_ID_KEY);
        }
        catch (Exception e) {
            LOG.warning("Unexpected exp! %s", e.getMessage());
            return null;
        }
    }
}

