/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companystore.entity.DyItems;
import com.els.modules.companystore.service.DyItemsService;
import com.els.modules.companystore.vo.CompanyGoodsHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6296\u97f3\u76d1\u63a7\u5546\u54c1"})
@RestController
@RequestMapping(value={"/companystore/dyItmes"})
public class DyItemsController
extends BaseController<DyItems, DyItemsService> {
    @Autowired
    private DyItemsService dyItemsService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> queryPageList(DyItems dyItems, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)dyItems), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dyItemsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u4e00\u952e\u4e0a\u67b6", notes="\u4e00\u952e\u4e0a\u67b6")
    @PostMapping(value={"/oneKeyPut"})
    public Result<?> oneKeyPut(@RequestBody CompanyGoodsHeadVO vo) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)vo)), (String)"\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(vo.getIds()), (String)"\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
        this.dyItemsService.oneKeyPut(vo.getIds());
        return Result.ok();
    }

    @GetMapping(value={"/shopList"})
    public Result<?> shopList(DyItems dyItems, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Assert.notBlank((CharSequence)dyItems.getShopId(), (String)"\u5c0f\u5e97id\u5f02\u5e38", (Object[])new Object[0]);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)dyItems), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dyItemsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u6296\u97f3\u76d1\u63a7\u5546\u54c1-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody DyItems dyItems) {
        this.dyItemsService.add(dyItems);
        return Result.ok((Object)((Object)dyItems));
    }

    @AutoLog(value="\u6296\u97f3\u76d1\u63a7\u5546\u54c1-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody DyItems dyItems) {
        this.dyItemsService.edit(dyItems);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6296\u97f3\u76d1\u63a7\u5546\u54c1-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.dyItemsService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6296\u97f3\u76d1\u63a7\u5546\u54c1-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.dyItemsService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        DyItems dyItems = (DyItems)((Object)this.dyItemsService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)dyItems));
    }
}

