/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyTopmanRecordQueryParam {
    private static final Logger log = LoggerFactory.getLogger(CompanyTopmanRecordQueryParam.class);

    public static QueryWrapper<CompanyStoreOrderItem> getQueryParam(CompanyStoreOrderItem head, Map<String, String[]> parameterMap, CompanyTopmanItemQueryDTO queryDTO) {
        Boolean phoneNumber;
        String goodsWom;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), parameterMap);
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryWrapper.between((Object)"order_time", (Object)dates[0], (Object)dates[1]);
        String fansNum = queryDTO.getTopmanFansNum();
        if (StringUtils.isNotBlank((CharSequence)fansNum)) {
            String[] strings;
            if (fansNum.contains("-")) {
                strings = fansNum.split("-");
                queryWrapper.gt((Object)"fans_num", (Object)new BigDecimal(strings[0]));
                queryWrapper.le((Object)"fans_num", (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains("<")) {
                strings = fansNum.split("<");
                queryWrapper.lt((Object)"fans_num", (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains(">")) {
                strings = fansNum.split(">");
                queryWrapper.gt((Object)"fans_num", (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsWom = queryDTO.getTopmanGoodsWom()))) {
            String[] strings;
            if (goodsWom.contains("-")) {
                strings = goodsWom.split("-");
                queryWrapper.between((Object)"goods_wom", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (goodsWom.contains("<")) {
                strings = goodsWom.split("<");
                queryWrapper.lt((Object)"goods_wom", (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.eq((Object)"goods_wom", (Object)new BigDecimal(goodsWom));
            }
        }
        if ((phoneNumber = queryDTO.getTopmanPhoneNumber()) != null && phoneNumber.booleanValue()) {
            queryWrapper.isNotNull((Object)"mobile");
        }
        return queryWrapper;
    }
}

