/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.companystore.dto.CompanyGoodsItemQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsLiveRecordVO;
import com.els.modules.companystore.entity.CompanyGoodsLiveRecord;
import com.els.modules.companystore.mapper.CompanyGoodsLiveRecordMapper;
import com.els.modules.companystore.mapper.CompanyStoreOrderItemMapper;
import com.els.modules.companystore.service.CompanyGoodsLiveRecordService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGoodsLiveRecordServiceImpl
extends BaseServiceImpl<CompanyGoodsLiveRecordMapper, CompanyGoodsLiveRecord>
implements CompanyGoodsLiveRecordService {
    @Autowired
    private CompanyGoodsLiveRecordMapper companyGoodsLiveRecordMapper;
    @Autowired
    private CompanyStoreOrderItemMapper companyStoreOrderItemMapper;

    @Override
    public List<CompanyGoodsLiveRecord> selectByMainId(String mainId) {
        return this.companyGoodsLiveRecordMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyGoodsLiveRecordVO> queryLivePage(Page<CompanyGoodsLiveRecord> page, QueryWrapper<CompanyGoodsLiveRecord> queryWrapper, CompanyGoodsItemQueryDTO queryDTO) {
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<CompanyGoodsLiveRecordVO> livePage = this.companyStoreOrderItemMapper.companyGoodsLiveRecordList(queryWrapper, queryDTO);
        return this.replenish(livePage);
    }

    private List<CompanyGoodsLiveRecordVO> replenish(List<CompanyGoodsLiveRecordVO> records) {
        ArrayList<CompanyGoodsLiveRecordVO> list = new ArrayList<CompanyGoodsLiveRecordVO>();
        if (CollectionUtils.isNotEmpty(records)) {
            List liveIds = records.stream().map(CompanyGoodsLiveRecordVO::getLiveId).distinct().collect(Collectors.toList());
            Map<String, List<CompanyGoodsLiveRecordVO>> listMap = records.stream().collect(Collectors.groupingBy(CompanyGoodsLiveRecordVO::getLiveId));
            for (String liveId : liveIds) {
                CompanyGoodsLiveRecordVO vo = new CompanyGoodsLiveRecordVO();
                List<CompanyGoodsLiveRecordVO> itemList = listMap.get(liveId);
                if (CollectionUtil.isEmpty(itemList)) break;
                CompanyGoodsLiveRecordVO itemVO = itemList.get(0);
                BeanUtil.copyProperties((Object)itemVO, (Object)vo, (String[])new String[0]);
                BigDecimal salesNum = itemList.stream().map(CompanyGoodsLiveRecordVO::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setSalesNum(salesNum);
                if (vo.getGoodsPrice() != null) {
                    vo.setSalesAmountMin(vo.getGoodsPrice().multiply(salesNum));
                    vo.setSalesAmountMax(vo.getGoodsPrice().multiply(salesNum));
                }
                if (vo.getLiveBrowsesNum() != null && vo.getLiveBrowsesNum().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal convertRate = salesNum.divide(vo.getLiveBrowsesNum(), 4, 4);
                    vo.setConvertRate(convertRate);
                }
                list.add(vo);
            }
        }
        return list;
    }
}

