/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doudian.open.api.buyin_simplePlanList.BuyinSimplePlanListRequest;
import com.doudian.open.api.buyin_simplePlanList.BuyinSimplePlanListResponse;
import com.doudian.open.api.buyin_simplePlanList.data.BuyinSimplePlanListData;
import com.doudian.open.api.buyin_simplePlanList.data.PromotionsItem;
import com.doudian.open.api.buyin_simplePlanList.param.BuyinSimplePlanListParam;
import com.doudian.open.api.product_detail.ProductDetailRequest;
import com.doudian.open.api.product_detail.ProductDetailResponse;
import com.doudian.open.api.product_detail.data.ProductDetailData;
import com.doudian.open.api.product_detail.param.ProductDetailParam;
import com.doudian.open.api.product_listV2.ProductListV2Request;
import com.doudian.open.api.product_listV2.ProductListV2Response;
import com.doudian.open.api.product_listV2.data.CategoryDetail;
import com.doudian.open.api.product_listV2.data.DataItem;
import com.doudian.open.api.product_listV2.data.ProductListV2Data;
import com.doudian.open.api.product_listV2.param.ProductListV2Param;
import com.doudian.open.api.shop_getShopCategory.ShopGetShopCategoryRequest;
import com.doudian.open.api.shop_getShopCategory.ShopGetShopCategoryResponse;
import com.doudian.open.api.shop_getShopCategory.param.ShopGetShopCategoryParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.dto.DyCategoryDto;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.DyProductCategory;
import com.els.modules.companystore.entity.DyShopProduct;
import com.els.modules.companystore.entity.DyShopProductPromotion;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.DyShopProductMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.DyProductCategoryService;
import com.els.modules.companystore.service.DyShopProductPromotionService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import com.els.modules.companystore.vo.DyShopItemsVO;
import com.els.modules.companystore.vo.TopMansVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DyShopProductServiceImpl
extends BaseServiceImpl<DyShopProductMapper, DyShopProduct>
implements DyShopProductService {
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private DouDianApiUtil douDianApiUtil;
    @Autowired
    private DyShopProductPromotionService dyShopProductPromotionService;
    @Autowired
    private DyProductCategoryService dyProductCategoryService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;

    @Override
    public void add(DyShopProduct dyShopProduct) {
        ((DyShopProductMapper)this.baseMapper).insert((Object)dyShopProduct);
    }

    @Override
    public void edit(DyShopProduct dyShopProduct) {
        int count = ((DyShopProductMapper)this.baseMapper).updateById((Object)dyShopProduct);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((DyShopProductMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((DyShopProductMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void processDyShopProduct() {
        Map<String, CompanyStoreHead> storeMap = this.companyStoreHeadService.getDyInitData();
        for (String shopId : storeMap.keySet()) {
            CompanyStoreHead companyStoreHead = storeMap.get(shopId);
            AccessToken accessToken = this.douDianApiUtil.getToken(shopId);
            if (ObjectUtil.isEmpty((Object)accessToken)) {
                companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue());
                continue;
            }
            this.pull(companyStoreHead, accessToken);
        }
    }

    @Override
    public void pullCategory() {
        String url = "https://open.douyin.com/oauth/client_token/";
        HashMap params = Maps.newHashMap();
        params.put("grant_type", "client_credential");
        params.put("client_key", "aw7ryobv463b71ns");
        params.put("client_secret", "deaff7dee1a94389d8ee59dcae47a082");
        ResponseEntity res = this.restTemplate.postForEntity(url, (Object)params, JSONObject.class, new Object[0]);
        System.out.println(res);
        String accessToken = ((JSONObject)res.getBody()).getJSONObject("data").getString("access_token");
        if (StrUtil.isNotBlank((CharSequence)accessToken)) {
            this.dyProductCategoryService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000"));
            List<DyProductCategory> dataItems = this.getCategory(0L, accessToken);
            dataItems.forEach(dataItem -> {
                dataItem.setElsAccount("100000");
                this.dyProductCategoryService.save(dataItem);
                this.handleCategory(this.getCategory(dataItem.getCategoryId(), accessToken), accessToken);
            });
        }
    }

    @Override
    public IPage<DyShopItemsVO> queryPage(Page<DyShopProduct> page, DyShopItemsVO dyShopItemsVO) {
        dyShopItemsVO.setCompanyList(this.permissionDataRpcService.getCompany("companyStore"));
        return ((DyShopProductMapper)this.baseMapper).queryPage(page, dyShopItemsVO);
    }

    @Override
    public IPage<TopMansVO> getDyTopMans(Page<TopMansVO> page, CompanyStoreHeadQueryDTO queryDTO) {
        return ((DyShopProductMapper)this.baseMapper).getDyTopMans(page, queryDTO);
    }

    @Override
    public long queryPageCount(DyShopItemsVO dyShopProduct) {
        return ((DyShopProductMapper)this.baseMapper).queryPageCount(dyShopProduct);
    }

    @Override
    public void pullById(String productId, CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        ProductDetailRequest request = new ProductDetailRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        ProductDetailParam param = (ProductDetailParam)request.getParam();
        param.setProductId(productId);
        ProductDetailResponse response = (ProductDetailResponse)request.execute(accessToken);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData())) {
            ProductDetailData detailData = (ProductDetailData)response.getData();
            DyShopProduct db = new DyShopProduct();
            BeanUtil.copyProperties((Object)detailData, (Object)((Object)db), (String[])new String[0]);
            db.setElsAccount(companyStoreHead.getElsAccount());
            db.setCreateTime((Date)DateUtil.parse((CharSequence)detailData.getCreateTime()));
            db.setUpdateTime((Date)DateUtil.parse((CharSequence)detailData.getUpdateTime()));
            db.setProductHref("https://haohuo.jinritemai.com/views/product/item2?id=" + productId);
            db.setShopId(companyStoreHead.getShopId());
            db.setShopName(companyStoreHead.getName());
            com.doudian.open.api.product_detail.data.CategoryDetail categoryDetail2 = detailData.getCategoryDetail();
            if (ObjectUtil.isNotEmpty((Object)categoryDetail2)) {
                if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFirstCid())) {
                    db.setFirstCid(categoryDetail2.getFirstCid() + "");
                    db.setFirstCname(categoryDetail2.getFirstCname());
                }
                if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getSecondCid())) {
                    db.setSecondCid(categoryDetail2.getSecondCid() + "");
                    db.setSecondCname(categoryDetail2.getSecondCname());
                }
                if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getThirdCid())) {
                    db.setThirdCid(categoryDetail2.getThirdCid() + "");
                    db.setThirdCname(categoryDetail2.getThirdCname());
                }
                if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFourthCid())) {
                    db.setFourthCid(categoryDetail2.getFourthCid() + "");
                    db.setFourthCname(categoryDetail2.getFourthCname());
                }
            }
            if (ObjectUtil.isNotEmpty((Object)detailData.getStandardBrandId())) {
                db.setStandardBrandId(detailData.getStandardBrandId() + "");
            }
            db.setDescription(detailData.getDescription());
            db.setDiscountPrice(detailData.getDiscountPrice());
            if (ObjectUtil.isNotEmpty((Object)detailData.getDraftStatus())) {
                db.setDraftStatus(detailData.getDraftStatus() + "");
            }
            this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).eq(DyShopProduct::getProductId, (Object)productId));
            this.save((Object)db);
            this.handlePlant(db, accessToken);
        }
    }

    public void handleCategory(List<DyProductCategory> dataItems, String accessToken) {
        for (DyProductCategory dataItem : dataItems) {
            dataItem.setElsAccount("100000");
            this.dyProductCategoryService.save((Object)dataItem);
            List<DyProductCategory> child = this.getCategory(dataItem.getCategoryId(), accessToken);
            if (CollUtil.isEmpty(child)) continue;
            this.handleCategory(child, accessToken);
        }
    }

    public List<DyProductCategory> getCategory(Long cid, String token) {
        JSONArray category_list;
        if (!cid.equals(0L)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList categories = Lists.newArrayList();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("parent_id", (Object)cid);
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Type", "application/json");
        header.add("Access-Token", token);
        HttpEntity formEntity = new HttpEntity((Object)JSON.toJSONString((Object)jsonObject), (MultiValueMap)header);
        JSONObject response = null;
        try {
            response = (JSONObject)this.restTemplate.postForObject("https://open.douyinec.com/alliance/materials/product/category/", (Object)formEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception E) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            response = (JSONObject)this.restTemplate.postForObject("https://open.douyinec.com/alliance/materials/product/category/", (Object)formEntity, JSONObject.class, new Object[0]);
        }
        JSONObject data = response.getJSONObject("data");
        if (ObjectUtil.isNotEmpty((Object)data) && ObjectUtil.isNotEmpty((Object)(category_list = data.getJSONArray("category_list")))) {
            List dyCategoryDtos = category_list.toJavaList(DyCategoryDto.class);
            for (DyCategoryDto dyCategoryDto : dyCategoryDtos) {
                if (dyCategoryDto.getId().equals(cid)) continue;
                DyProductCategory dyProductCategory = new DyProductCategory();
                dyProductCategory.setCategoryId(dyCategoryDto.getId());
                dyProductCategory.setLevel(dyCategoryDto.getLevel());
                dyProductCategory.setCategoryName(dyCategoryDto.getName());
                dyProductCategory.setCategoryPid(cid);
                categories.add(dyProductCategory);
            }
        }
        return categories;
    }

    public static void main(String[] args) {
        ShopGetShopCategoryRequest request = new ShopGetShopCategoryRequest();
        ShopGetShopCategoryParam param = (ShopGetShopCategoryParam)request.getParam();
        param.setCid(20023L);
        DoudianOpConfig doudianOpConfig = new DoudianOpConfig();
        doudianOpConfig.setAppKey("7238784366355154487");
        doudianOpConfig.setAppSecret("1c216dd8-7cab-40fb-99cd-33d2273f68ce");
        request.setConfig(doudianOpConfig);
        AccessToken accessToken = AccessToken.wrap("0c1c4be2-32a0-477e-b829-d2245376cc64", "6a7af222-4b96-4d90-ab82-6ea8adfe8259");
        ShopGetShopCategoryResponse response = (ShopGetShopCategoryResponse)request.execute(accessToken);
        List dataItems = (List)response.getData();
        System.out.println(dataItems);
    }

    public void pull(CompanyStoreHead companyStoreHead, AccessToken accessToken) {
        long page = 1L;
        int errorIndex = 10;
        while (errorIndex > 0) {
            try {
                ProductListV2Request request = new ProductListV2Request();
                request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
                ProductListV2Param param = (ProductListV2Param)request.getParam();
                param.setPage(page);
                param.setSize(10L);
                param.setUseCursor(false);
                ProductListV2Response response = (ProductListV2Response)request.execute(accessToken);
                ProductListV2Data productListV2Data = (ProductListV2Data)response.getData();
                if (ObjectUtil.isEmpty((Object)productListV2Data)) {
                    return;
                }
                List<DataItem> dataItems = productListV2Data.getData();
                if (CollUtil.isEmpty(dataItems)) {
                    return;
                }
                ArrayList dbs = Lists.newArrayList();
                for (DataItem dataItem : dataItems) {
                    DyShopProduct db = new DyShopProduct();
                    BeanUtil.copyProperties((Object)dataItem, (Object)((Object)db), (String[])new String[0]);
                    db.setElsAccount(companyStoreHead.getElsAccount());
                    if (ObjectUtil.isNotEmpty((Object)dataItem.getCreateTime()) && !dataItem.getCreateTime().equals(0L)) {
                        db.setCreateTime(new Date(dataItem.getCreateTime() * 1000L));
                    } else {
                        db.setCreateTime(null);
                    }
                    if (ObjectUtil.isNotEmpty((Object)dataItem.getUpdateTime()) && !dataItem.getUpdateTime().equals(0L)) {
                        db.setUpdateTime(new Date(dataItem.getUpdateTime() * 1000L));
                    } else {
                        db.setUpdateTime(null);
                    }
                    db.setProductHref("https://haohuo.jinritemai.com/views/product/item2?id=" + dataItem.getProductId());
                    db.setShopId(companyStoreHead.getShopId());
                    db.setShopName(companyStoreHead.getName());
                    CategoryDetail categoryDetail2 = dataItem.getCategoryDetail();
                    if (ObjectUtil.isNotEmpty((Object)categoryDetail2)) {
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFirstCid())) {
                            db.setFirstCid(categoryDetail2.getFirstCid() + "");
                            db.setFirstCname(categoryDetail2.getFirstCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getSecondCid())) {
                            db.setSecondCid(categoryDetail2.getSecondCid() + "");
                            db.setSecondCname(categoryDetail2.getSecondCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getThirdCid())) {
                            db.setThirdCid(categoryDetail2.getThirdCid() + "");
                            db.setThirdCname(categoryDetail2.getThirdCname());
                        }
                        if (ObjectUtil.isNotEmpty((Object)categoryDetail2.getFourthCid())) {
                            db.setFourthCid(categoryDetail2.getFourthCid() + "");
                            db.setFourthCname(categoryDetail2.getFourthCname());
                        }
                    }
                    this.handleDetail(db, accessToken);
                    this.handlePlant(db, accessToken);
                    dbs.add(db);
                }
                if (CollUtil.isNotEmpty((Collection)dbs)) {
                    List ids = dbs.stream().map(x -> x.getProductId()).distinct().collect(Collectors.toList());
                    this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)companyStoreHead.getElsAccount())).in(DyShopProduct::getProductId, ids));
                    this.saveBatch(dbs);
                }
                ++page;
            }
            catch (Exception e) {
                --errorIndex;
                this.log.error("\u62c9\u53d6\u6296\u5e97\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void handlePlant(DyShopProduct db, AccessToken accessToken) {
        BuyinSimplePlanListRequest request = new BuyinSimplePlanListRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        BuyinSimplePlanListParam param = (BuyinSimplePlanListParam)request.getParam();
        param.setProductInfo(db.getProductId());
        BuyinSimplePlanListResponse response = (BuyinSimplePlanListResponse)request.execute(accessToken);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData()) && CollUtil.isNotEmpty(((BuyinSimplePlanListData)response.getData()).getPromotions())) {
            List<PromotionsItem> promotionsItems = ((BuyinSimplePlanListData)response.getData()).getPromotions();
            ArrayList dbs = Lists.newArrayList();
            for (PromotionsItem promotionsItem : promotionsItems) {
                DyShopProductPromotion productPromotion = (DyShopProductPromotion)((Object)BeanUtil.copyProperties((Object)promotionsItem, DyShopProductPromotion.class, (String[])new String[0]));
                productPromotion.setElsAccount(db.getElsAccount());
                dbs.add(productPromotion);
            }
            this.dyShopProductPromotionService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)db.getElsAccount())).eq(DyShopProductPromotion::getProductId, (Object)db.getProductId()));
            this.dyShopProductPromotionService.saveBatch(dbs);
        }
    }

    private void handleDetail(DyShopProduct db, AccessToken accessToken) {
        ProductDetailRequest request = new ProductDetailRequest();
        request.setConfig(this.douDianApiUtil.getDoudianOpConfig());
        ProductDetailParam param = (ProductDetailParam)request.getParam();
        param.setProductId(db.getProductId());
        ProductDetailResponse response = (ProductDetailResponse)request.execute(accessToken);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty(response.getData())) {
            ProductDetailData detailData = (ProductDetailData)response.getData();
            if (ObjectUtil.isNotEmpty((Object)detailData.getStandardBrandId())) {
                db.setStandardBrandId(detailData.getStandardBrandId() + "");
            }
            db.setDescription(detailData.getDescription());
            db.setDiscountPrice(detailData.getDiscountPrice());
            if (ObjectUtil.isNotEmpty((Object)detailData.getDraftStatus())) {
                db.setDraftStatus(detailData.getDraftStatus() + "");
            }
        }
    }
}

