/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.monitor.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.monitor.entity.LiveDashboardEntity;
import com.els.modules.monitor.entity.LiveMonitorEntity;
import com.els.modules.monitor.entity.LiveSummaryEntity;
import com.els.modules.monitor.entity.LiveUsersEntity;
import com.els.modules.monitor.service.LivesMonitorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/lives"})
@Api(tags={"\u76f4\u64ad\u76d1\u63a7"})
public class LivesMonitorController
extends BaseController<LiveMonitorEntity, LivesMonitorService> {
    private static final Logger log = LoggerFactory.getLogger(LivesMonitorController.class);
    @Resource
    private LivesMonitorService livesMonitorService;

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u641c\u7d22")
    @ApiOperation(value="\u641c\u7d22", notes="\u641c\u7d22")
    @PostMapping(value={"/serach"})
    public Result<?> serach(@RequestBody LiveMonitorEntity entity) throws Exception {
        return Result.ok(this.livesMonitorService.searchTopmanMonitor(entity.getKeyWord()));
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u958b\u59cb\u76e3\u63a7")
    @ApiOperation(value="\u958b\u59cb\u76e3\u63a7", notes="\u958b\u59cb\u76e3\u63a7")
    @PostMapping(value={"/startMonitor"})
    public Result<?> startMonitor(@RequestBody LiveMonitorEntity entity) throws Exception {
        int result = this.livesMonitorService.startMonitor(entity);
        if (result == 0) {
            return Result.error((String)"\u76d1\u63a7\u6b21\u6570\u4e0d\u591f\uff0c\u8bf7\u5145\u503c\u540e\u518d\u4f7f\u7528!");
        }
        return Result.ok();
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u641c\u7d22")
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> seachMonitorList(LiveMonitorEntity entity, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)entity), (Map)req.getParameterMap());
        String keyWord = entity.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            queryWrapper.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(LiveMonitorEntity::getNikeName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(LiveMonitorEntity::getAccount, (Object)keyWord);
                });
            });
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.livesMonitorService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u76f4\u64ad\u6982\u89c8")
    @ApiOperation(value="\u76f4\u64ad\u6982\u89c8", notes="\u76f4\u64ad\u6982\u89c8")
    @PostMapping(value={"/getLiveSummary"})
    public Result<?> getLiveSummary(@RequestBody LiveMonitorEntity entity) throws Exception {
        LiveSummaryEntity result = this.livesMonitorService.getLiveSummary(entity);
        return Result.ok((Object)result);
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u76f4\u64ad\u76d1\u63a7\u56fe\u8868")
    @ApiOperation(value="\u76f4\u64ad\u76d1\u63a7\u56fe\u8868", notes="\u76f4\u64ad\u76d1\u63a7\u56fe\u8868")
    @PostMapping(value={"/getLiveDashboard"})
    public Result<?> getLiveDashboard(@RequestBody LiveMonitorEntity entity) throws Exception {
        List<LiveDashboardEntity> result = this.livesMonitorService.getLiveDashboard(entity);
        return Result.ok(result);
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u7528\u6237\u753b\u50cf")
    @ApiOperation(value="\u7528\u6237\u753b\u50cf", notes="\u7528\u6237\u753b\u50cf")
    @PostMapping(value={"/getLiveUsers"})
    public Result<?> getLiveUsers(@RequestBody LiveMonitorEntity entity) throws Exception {
        List<LiveUsersEntity> result = this.livesMonitorService.getLiveUsers(entity);
        return Result.ok(result);
    }

    @AutoLog(busModule="\u76f4\u64ad\u76d1\u63a7", value="\u641c\u7d22")
    @ApiOperation(value="\u67e5\u8be2\u72b6\u6001", notes="\u67e5\u8be2\u72b6\u6001")
    @GetMapping(value={"/statusCnt"})
    public Result<?> seachLiveStatus(LiveMonitorEntity entity, HttpServletRequest req) {
        return Result.ok((Object)this.livesMonitorService.querySumStatusData());
    }
}

